/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.part.PartFluidIO;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PartFluidExport
extends PartFluidIO {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        rh.setTexture(TextureManager.EXPORT_SIDE.getTexture());
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        IIcon side = TextureManager.EXPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.EXPORT_FRONT.getTexture(), side, side);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setInvColor(AEColor.Cyan.blackVariant);
        ts.func_78380_c(0xF000F0);
        rh.renderInventoryFace(TextureManager.EXPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        rh.setTexture(TextureManager.EXPORT_SIDE.getTexture());
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        IIcon side = TextureManager.EXPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.EXPORT_FRONT.getTextures()[0], side, side);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        if (this.isActive()) {
            ts.func_78380_c(0xF000F0);
        }
        rh.renderFace(x, y, z, TextureManager.EXPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public boolean doWork(int rate, int TicksSinceLastCall) {
        int i;
        IFluidHandler facingTank = this.getFacingTank();
        if (facingTank == null || !this.isActive()) {
            return false;
        }
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        filter.add(this.filterFluids[4]);
        if (this.filterSize >= 1) {
            for (i = 1; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        if (this.filterSize >= 2) {
            for (i = 0; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        for (Fluid fluid : filter) {
            int filled;
            IAEFluidStack stack;
            if (fluid == null || (stack = this.extractFluid(AEApi.instance().storage().createFluidStack(new FluidStack(fluid, rate * TicksSinceLastCall)), Actionable.SIMULATE)) == null || (filled = facingTank.fill(this.getSide().getOpposite(), stack.getFluidStack(), true)) <= 0) continue;
            this.extractFluid(AEApi.instance().storage().createFluidStack(new FluidStack(fluid, filled)), Actionable.MODULATE);
            return true;
        }
        return false;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }
}

