/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerDrive;
import extracells.gui.GuiDrive;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class PartDrive
extends PartECBase
implements ICellContainer,
IInventoryUpdateReceiver {
    private int priority = 0;
    private short[] blinkTimers;
    private byte[] cellStatuses = new byte[6];
    List<IMEInventoryHandler> fluidHandlers = new ArrayList<IMEInventoryHandler>();
    List<IMEInventoryHandler> itemHandlers = new ArrayList<IMEInventoryHandler>();
    private ECPrivateInventory inventory = new ECPrivateInventory("extracells.part.drive", 6, 1, this){
        ICellRegistry cellRegistry;
        {
            this.cellRegistry = AEApi.instance().registries().cell();
        }

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return this.cellRegistry.isCellHandled(itemStack);
        }
    };

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon side = TextureManager.DRIVE_SIDE.getTexture();
        IIcon[] front = TextureManager.DRIVE_FRONT.getTextures();
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.999f);
        rh.renderInventoryFace(front[3], ForgeDirection.SOUTH, renderer);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.setTexture(side, side, side, front[0], side, side);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        int j;
        int i;
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.DRIVE_SIDE.getTexture();
        IIcon[] front = TextureManager.DRIVE_FRONT.getTextures();
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.999f);
        rh.renderFace(x, y, z, front[3], ForgeDirection.SOUTH, renderer);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.setTexture(side, side, side, front[0], side, side);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78378_d(0xFFFFFF);
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 3; ++j) {
                if (this.cellStatuses[j + i * 3] <= 0) continue;
                if (this.getSide() == ForgeDirection.EAST || this.getSide() == ForgeDirection.WEST ? i == 1 : i == 0) {
                    rh.setBounds(8.0f, (float)(12 - j * 3), 14.0f, 13.0f, (float)(10 - j * 3), 16.0f);
                } else {
                    rh.setBounds(3.0f, (float)(12 - j * 3), 14.0f, 8.0f, (float)(10 - j * 3), 16.0f);
                }
                rh.renderFace(x, y, z, front[1], ForgeDirection.SOUTH, renderer);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 3; ++j) {
                if (this.getSide() == ForgeDirection.EAST || this.getSide() == ForgeDirection.WEST ? i == 1 : i == 0) {
                    rh.setBounds(8.0f, (float)(12 - j * 3), 14.0f, 13.0f, (float)(10 - j * 3), 16.0f);
                } else {
                    rh.setBounds(3.0f, (float)(12 - j * 3), 14.0f, 8.0f, (float)(10 - j * 3), 16.0f);
                }
                ts.func_78378_d(this.getColorByStatus(this.cellStatuses[j + i * 3]));
                ts.func_78380_c(0xD000D0);
                rh.renderFace(x, y, z, front[2], ForgeDirection.SOUTH, renderer);
            }
        }
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        for (byte aCellStati : this.cellStatuses) {
            data.writeByte((int)aCellStati);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            this.cellStatuses[i] = data.readByte();
        }
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    public int getColorByStatus(int status) {
        switch (status) {
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFFFF00;
            }
            case 3: {
                return 0xFF0000;
            }
        }
        return 0;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
        this.onInventoryChanged();
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (!this.isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        return channel == StorageChannel.ITEMS ? this.itemHandlers : this.fluidHandlers;
    }

    @Override
    public void setPartHostInfo(ForgeDirection _side, IPartHost _host, TileEntity _tile) {
        super.setPartHostInfo(_side, _host, _tile);
        this.onInventoryChanged();
    }

    public int getPriority() {
        return this.priority;
    }

    public void blinkCell(int slot) {
        if (slot > 0 && slot < this.blinkTimers.length) {
            this.blinkTimers[slot] = 15;
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.onInventoryChanged();
    }

    @Override
    public void onInventoryChanged() {
        this.itemHandlers = this.updateHandlers(StorageChannel.ITEMS);
        this.fluidHandlers = this.updateHandlers(StorageChannel.FLUIDS);
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            ICellHandler cellHandler;
            ItemStack stackInSlot = this.inventory.func_70301_a(i);
            IMEInventoryHandler inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.ITEMS);
            if (inventoryHandler == null) {
                inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.FLUIDS);
            }
            this.cellStatuses[i] = (cellHandler = AEApi.instance().registries().cell().getHandler(stackInSlot)) == null || inventoryHandler == null ? (byte)0 : (byte)cellHandler.getStatusForCell(stackInSlot, (IMEInventory)inventoryHandler);
        }
        IGridNode node = this.getGridNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            this.getHost().markForUpdate();
        }
        this.saveData();
    }

    private List<IMEInventoryHandler> updateHandlers(StorageChannel channel) {
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ArrayList<IMEInventoryHandler> handlers = new ArrayList<IMEInventoryHandler>();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            IMEInventoryHandler cellInventory;
            ItemStack cell = this.inventory.func_70301_a(i);
            if (!cellRegistry.isCellHandled(cell) || (cellInventory = cellRegistry.getCellInventory(cell, null, channel)) == null) continue;
            handlers.add(cellInventory);
        }
        return handlers;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (!wrenched) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack cell = this.inventory.func_70301_a(i);
                if (cell == null) continue;
                drops.add(cell);
            }
        }
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerDrive(this, player);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiDrive(this, player);
    }

    public void saveChanges(IMEInventory cellInventory) {
        this.getHost().markForSave();
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged channel) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange event) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }
}

