/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.part.PartStorageMonitor;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class PartConversionMonitor
extends PartStorageMonitor {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        rh.setInvColor(0xFFFFFF);
        rh.renderInventoryFace(TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.setInvColor(AEColor.Transparent.blackVariant);
        rh.renderInventoryFace(TextureManager.CONVERSION_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.mediumVariant);
        rh.renderInventoryFace(TextureManager.CONVERSION_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.whiteVariant);
        rh.renderInventoryFace(TextureManager.CONVERSION_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        ts.func_78378_d(0xFFFFFF);
        rh.renderFace(x, y, z, TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        IPartHost host = this.getHost();
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(host.getColor().mediumVariant);
        rh.renderFace(x, y, z, TextureManager.CONVERSION_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().whiteVariant);
        rh.renderFace(x, y, z, TextureManager.CONVERSION_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().blackVariant);
        rh.renderFace(x, y, z, TextureManager.CONVERSION_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        boolean b = super.onActivate(player, pos);
        if (b) {
            return b;
        }
        if (player == null || player.field_70170_p == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack s = player.func_71045_bC();
        IMEMonitor<IAEFluidStack> mon = this.getFluidStorage();
        if (this.locked && s != null && mon != null) {
            ItemStack s2 = s.func_77946_l();
            s2.field_77994_a = 1;
            if (FluidUtil.isFilled(s2)) {
                FluidStack f = FluidUtil.getFluidFromContainer(s2);
                if (f == null) {
                    return true;
                }
                IAEFluidStack fl = FluidUtil.createAEFluidStack(f);
                IAEFluidStack not = (IAEFluidStack)mon.injectItems((IAEStack)fl.copy(), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (mon.canAccept((IAEStack)fl) && (not == null || not.getStackSize() == 0L)) {
                    mon.injectItems((IAEStack)fl, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    MutablePair<Integer, ItemStack> empty1 = FluidUtil.drainStack(s2, f);
                    ItemStack empty = (ItemStack)empty1.right;
                    if (empty != null) {
                        this.dropItems(this.getHost().getTile().func_145831_w(), this.getHost().getTile().field_145851_c + this.getSide().offsetX, this.getHost().getTile().field_145848_d + this.getSide().offsetY, this.getHost().getTile().field_145849_e + this.getSide().offsetZ, empty);
                    }
                    ItemStack s3 = s.func_77946_l();
                    --s3.field_77994_a;
                    if (s3.field_77994_a == 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, s3);
                    }
                }
                return true;
            }
            if (FluidUtil.isEmpty(s2)) {
                if (this.fluid == null) {
                    return true;
                }
                IAEFluidStack extract = s2.func_77973_b() instanceof IFluidContainerItem ? (IAEFluidStack)mon.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.fluid, (long)((IFluidContainerItem)s2.func_77973_b()).getCapacity(s2)), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this)) : (IAEFluidStack)mon.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.fluid), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (extract != null) {
                    mon.extractItems((IAEStack)FluidUtil.createAEFluidStack(new FluidStack(this.fluid, (int)extract.getStackSize())), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    MutablePair<Integer, ItemStack> empty1 = FluidUtil.fillStack(s2, extract.getFluidStack());
                    if ((Integer)empty1.left == 0) {
                        mon.injectItems((IAEStack)FluidUtil.createAEFluidStack(new FluidStack(this.fluid, (int)extract.getStackSize())), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                        return true;
                    }
                    ItemStack empty = (ItemStack)empty1.right;
                    if (empty != null) {
                        this.dropItems(this.getHost().getTile().func_145831_w(), this.getHost().getTile().field_145851_c + this.getSide().offsetX, this.getHost().getTile().field_145848_d + this.getSide().offsetY, this.getHost().getTile().field_145849_e + this.getSide().offsetZ, empty);
                    }
                    ItemStack s3 = s.func_77946_l();
                    --s3.field_77994_a;
                    if (s3.field_77994_a == 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, s3);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

