/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.container.ContainerFluidStorage;
import extracells.gui.GuiFluidStorage;
import extracells.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidStorage
extends AbstractPacket {
    private IItemList<IAEFluidStack> fluidStackList;
    private Fluid currentFluid;
    private boolean hasTermHandler;

    public PacketFluidStorage() {
    }

    public PacketFluidStorage(EntityPlayer _player, IItemList<IAEFluidStack> _list) {
        super(_player);
        this.mode = 0;
        this.fluidStackList = _list;
    }

    public PacketFluidStorage(EntityPlayer _player, Fluid _currentFluid) {
        super(_player);
        this.mode = 1;
        this.currentFluid = _currentFluid;
    }

    public PacketFluidStorage(EntityPlayer _player) {
        super(_player);
        this.mode = (byte)2;
    }

    public PacketFluidStorage(EntityPlayer _player, boolean _hasTermHandler) {
        super(_player);
        this.mode = (byte)3;
        this.hasTermHandler = _hasTermHandler;
    }

    @Override
    public void writeData(ByteBuf out) {
        switch (this.mode) {
            case 0: {
                for (IAEFluidStack stack : this.fluidStackList) {
                    FluidStack fluidStack = stack.getFluidStack();
                    PacketFluidStorage.writeFluid(fluidStack.getFluid(), out);
                    out.writeLong((long)fluidStack.amount);
                }
                break;
            }
            case 1: {
                PacketFluidStorage.writeFluid(this.currentFluid, out);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                out.writeBoolean(this.hasTermHandler);
            }
        }
    }

    @Override
    public void readData(ByteBuf in) {
        switch (this.mode) {
            case 0: {
                this.fluidStackList = AEApi.instance().storage().createFluidList();
                while (in.readableBytes() > 0) {
                    Fluid fluid = PacketFluidStorage.readFluid(in);
                    long fluidAmount = in.readLong();
                    if (fluid == null) continue;
                    IAEFluidStack stack = AEApi.instance().storage().createFluidStack(new FluidStack(fluid, 1));
                    stack.setStackSize(fluidAmount);
                    this.fluidStackList.add((IAEStack)stack);
                }
                break;
            }
            case 1: {
                this.currentFluid = PacketFluidStorage.readFluid(in);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.hasTermHandler = in.readBoolean();
            }
        }
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                GuiScreen gui;
                if (this.player == null || !this.player.func_70613_aW() || !((gui = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluidStorage)) break;
                ContainerFluidStorage container = (ContainerFluidStorage)((GuiFluidStorage)gui).field_147002_h;
                container.updateFluidList(this.fluidStackList);
                break;
            }
            case 1: {
                if (this.player == null || !(this.player.field_71070_bA instanceof ContainerFluidStorage)) break;
                ((ContainerFluidStorage)this.player.field_71070_bA).receiveSelectedFluid(this.currentFluid);
                break;
            }
            case 2: {
                if (this.player == null || this.player.field_70170_p.field_72995_K || !(this.player.field_71070_bA instanceof ContainerFluidStorage)) break;
                ((ContainerFluidStorage)this.player.field_71070_bA).forceFluidUpdate();
                ((ContainerFluidStorage)this.player.field_71070_bA).doWork();
                break;
            }
            case 3: {
                GuiScreen gui;
                if (this.player == null || !this.player.func_70613_aW() || !((gui = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluidStorage)) break;
                ContainerFluidStorage container = (ContainerFluidStorage)((GuiFluidStorage)gui).field_147002_h;
                container.hasWirelessTermHandler = this.hasTermHandler;
            }
        }
    }
}

