/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.tileentity.TileEntityCertusTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemBlockCertusTank
extends ItemBlock
implements IFluidContainerItem {
    private final int capacity = 32000;

    public ItemBlockCertusTank(Block block) {
        super(block);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack != null) {
            if (itemstack.func_77942_o()) {
                try {
                    FluidStack fluidInTank = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("tileEntity"));
                    if (fluidInTank != null && fluidInTank.getFluid() != null) {
                        return StatCollector.func_74838_a((String)this.func_77667_c(itemstack)) + " - " + fluidInTank.getFluid().getLocalizedName(fluidInTank);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return StatCollector.func_74838_a((String)this.func_77667_c(itemstack));
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack != null && stack.func_77942_o() && FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("tileEntity")) != null) {
            list.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l((String)"tileEntity")).amount + "mB");
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_147465_d(x, y, z, this.field_150939_a, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == this.field_150939_a) {
            this.field_150939_a.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            this.field_150939_a.func_149714_e(world, x, y, z, metadata);
        }
        if (stack != null && stack.func_77942_o()) {
            ((TileEntityCertusTank)world.func_147438_o(x, y, z)).readFromNBTWithoutCoords(stack.func_77978_p().func_74775_l("tileEntity"));
        }
        return true;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("tileEntity")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("tileEntity"));
    }

    public int getCapacity(ItemStack container) {
        return 32000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("tileEntity")) {
                return Math.min(32000, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("tileEntity"));
            if (stack == null) {
                return Math.min(32000, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(32000 - stack.amount, resource.amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("tileEntity") || container.field_77990_d.func_74775_l("tileEntity").func_74764_b("Empty")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (32000 < resource.amount) {
                fluidTag.func_74768_a("Amount", 32000);
                container.field_77990_d.func_74782_a("tileEntity", (NBTBase)fluidTag);
                return 32000;
            }
            container.field_77990_d.func_74782_a("tileEntity", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("tileEntity");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = 32000 - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = 32000;
        }
        container.field_77990_d.func_74782_a("tileEntity", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("tileEntity") || container.field_77990_d.func_74775_l("tileEntity").func_74764_b("Empty")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("tileEntity"));
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (currentAmount == stack.amount) {
                container.field_77990_d.func_82580_o("tileEntity");
                if (container.field_77990_d.func_82582_d()) {
                    container.field_77990_d = null;
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("tileEntity");
            fluidTag.func_74768_a("Amount", currentAmount - stack.amount);
            container.field_77990_d.func_74782_a("tileEntity", (NBTBase)fluidTag);
        }
        return stack;
    }
}

