/*
 * Decompiled with CFR 0.152.
 */
package extracells.block;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGridNode;
import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.api.IECTileEntity;
import extracells.network.GuiHandler;
import extracells.tileentity.IListenerTile;
import extracells.tileentity.TileEntityFluidFiller;
import extracells.tileentity.TileEntityFluidInterface;
import extracells.util.PermissionUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ECBaseBlock
extends BlockContainer {
    private IIcon[] icons = new IIcon[2];

    public ECBaseBlock() {
        super(Material.field_151573_f);
        this.func_149647_a(Extracells.ModTab);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityFluidInterface();
            }
            case 1: {
                return new TileEntityFluidFiller();
            }
        }
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        switch (world.func_72805_g(x, y, z)) {
            case 0: 
            case 1: {
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile != null) {
                    if (tile instanceof IECTileEntity) {
                        IGridNode node = ((IECTileEntity)tile).getGridNode(ForgeDirection.UNKNOWN);
                        if (entity != null && entity instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)entity;
                            node.setPlayerID(AEApi.instance().registries().players().getID(player));
                        }
                        node.updateState();
                    }
                    if (tile instanceof IListenerTile) {
                        ((IListenerTile)tile).registerListener();
                    }
                }
                return;
            }
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            return;
        }
        switch (meta) {
            case 0: 
            case 1: {
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile != null) {
                    IGridNode node;
                    if (tile instanceof IECTileEntity && (node = ((IECTileEntity)tile).getGridNode(ForgeDirection.UNKNOWN)) != null) {
                        node.destroy();
                    }
                    if (tile instanceof IListenerTile) {
                        ((IListenerTile)tile).removeListener();
                    }
                }
                return;
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (world.field_72995_K) {
            return false;
        }
        Random rand = new Random();
        switch (world.func_72805_g(x, y, z)) {
            case 0: 
            case 1: {
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile instanceof IECTileEntity && !PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, ((IECTileEntity)tile).getGridNode(ForgeDirection.UNKNOWN))) {
                    return false;
                }
                ItemStack current = player.func_71045_bC();
                if (player.func_70093_af() && current != null) {
                    try {
                        if (current.func_77973_b() instanceof IToolWrench && ((IToolWrench)current.func_77973_b()).canWrench(player, x, y, z)) {
                            ItemStack block = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
                            if (tile != null && tile instanceof TileEntityFluidInterface) {
                                block.func_77982_d(((TileEntityFluidInterface)tile).writeFilter(new NBTTagCompound()));
                            }
                            this.func_149642_a(world, x, y, z, block);
                            world.func_147468_f(x, y, z);
                            ((IToolWrench)current.func_77973_b()).wrenchUsed(player, x, y, z);
                            return true;
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (current.func_77973_b() instanceof IAEWrench && ((IAEWrench)current.func_77973_b()).canWrench(current, player, x, y, z)) {
                        ItemStack block = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
                        if (tile != null && tile instanceof TileEntityFluidInterface) {
                            block.func_77982_d(((TileEntityFluidInterface)tile).writeFilter(new NBTTagCompound()));
                        }
                        this.func_149642_a(world, x, y, z, block);
                        world.func_147468_f(x, y, z);
                        return true;
                    }
                }
                GuiHandler.launchGui(0, player, world, x, y, z);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons[0] = register.func_94245_a("extracells:fluid.interface");
        this.icons[1] = register.func_94245_a("extracells:fluid.filler");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= 0 && meta + 1 <= this.icons.length) {
            return this.icons[meta];
        }
        return null;
    }

    public int func_149692_a(int p_149692_1_) {
        return p_149692_1_;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        this.dropPatter(world, x, y, z);
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private void dropPatter(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityFluidInterface)) {
            return;
        }
        TileEntityFluidInterface.FluidInterfaceInventory inventory = ((TileEntityFluidInterface)tileEntity).inventory;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), item.func_77946_l());
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }
}

