/*
 * Decompiled with CFR 0.152.
 */
package extracells;

import appeng.api.AEApi;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.recipes.ISubItemResolver;
import appeng.api.storage.ICellHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import extracells.network.ChannelHandler;
import extracells.network.GuiHandler;
import extracells.proxy.CommonProxy;
import extracells.registries.ItemEnum;
import extracells.render.RenderHandler;
import extracells.util.ExtraCellsEventHandler;
import extracells.util.FluidCellHandler;
import extracells.util.NameHandler;
import extracells.waila.Waila;
import extracells.wireless.AEWirelessTermHandler;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="extracells", name="Extra Cells", dependencies="after:LogisticsPipes|Main;after:Waila;required-after:appliedenergistics2")
public class Extracells {
    @Mod.Instance(value="extracells")
    public static Extracells instance;
    @SidedProxy(clientSide="extracells.proxy.ClientProxy", serverSide="extracells.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static String VERSION;
    private static File configFolder;
    public static boolean shortenedBuckets;
    public static boolean dynamicTypes;
    public static CreativeTabs ModTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        VERSION = Loader.instance().activeModContainer().getVersion();
        configFolder = event.getModConfigurationDirectory();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        Configuration config = new Configuration(new File(configFolder.getPath() + File.separator + "AppliedEnergistics2" + File.separator + "extracells.cfg"));
        config.load();
        shortenedBuckets = config.get("Tooltips", "shortenedBuckets", true, "Shall the guis shorten large mB values?").getBoolean(true);
        dynamicTypes = config.get("Storage Cells", "dynamicTypes", true, "Should the mount of bytes needed for a new type depend on the cellsize?").getBoolean(true);
        config.save();
        proxy.registerItems();
        proxy.registerBlocks();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        AEApi.instance().registries().recipes().addNewSubItemResolver((ISubItemResolver)new NameHandler());
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)new AEWirelessTermHandler());
        AEApi.instance().registries().cell().addCellHandler((ICellHandler)new FluidCellHandler());
        ExtraCellsEventHandler handler = new ExtraCellsEventHandler();
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
        proxy.registerMovables();
        proxy.registerRenderers();
        proxy.registerTileEntities();
        proxy.addRecipes(configFolder);
        ChannelHandler.registerMessages();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderHandler(RenderingRegistry.getNextAvailableRenderId()));
        Waila.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        ModTab = new CreativeTabs("Extra_Cells"){

            public ItemStack func_151244_d() {
                return new ItemStack(ItemEnum.FLUIDSTORAGE.getItem());
            }

            public Item func_78016_d() {
                return ItemEnum.FLUIDSTORAGE.getItem();
            }
        };
    }
}

