/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import openblocks.OpenBlocks;
import openmods.OpenMods;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.EnchantmentUtils;

public class TileEntityXPDrain
extends OpenTileEntity {
    private WeakReference<TileEntity> targetTank;

    public void func_145845_h() {
        super.func_145845_h();
        if (OpenMods.proxy.getTicks(this.field_145850_b) % 100L == 0L) {
            this.searchForTank();
        }
        if (this.targetTank != null) {
            TileEntity tile = (TileEntity)this.targetTank.get();
            if (!(tile instanceof IFluidHandler) || tile.func_145837_r()) {
                this.targetTank = null;
            } else if (!this.field_145850_b.field_72995_K) {
                IFluidHandler tank = (IFluidHandler)tile;
                for (EntityXPOrb orb : this.getXPOrbsOnGrid()) {
                    this.tryConsumeOrb(tank, orb);
                }
                for (EntityPlayer player : this.getPlayersOnGrid()) {
                    this.tryDrainPlayer(tank, player);
                }
            }
        }
    }

    protected void tryDrainPlayer(IFluidHandler tank, EntityPlayer player) {
        int acceptedLiquid;
        int playerXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
        if (playerXP <= 0) {
            return;
        }
        int maxDrainedXp = Math.min(4, playerXP);
        FluidStack liquid = OpenBlocks.XP_FLUID.copy();
        liquid.amount = EnchantmentUtils.XPToLiquidRatio((int)maxDrainedXp);
        int maxAcceptedLiquid = tank.fill(ForgeDirection.UP, liquid, false);
        int acceptedXP = EnchantmentUtils.liquidToXPRatio((int)maxAcceptedLiquid);
        liquid.amount = acceptedLiquid = EnchantmentUtils.XPToLiquidRatio((int)acceptedXP);
        int finallyAcceptedLiquid = tank.fill(ForgeDirection.UP, liquid, true);
        if (finallyAcceptedLiquid <= 0) {
            return;
        }
        if (OpenMods.proxy.getTicks(this.field_145850_b) % 4L == 0L) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.orb", 0.1f, 0.5f * ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.8f));
        }
        EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)(-acceptedXP));
    }

    protected void tryConsumeOrb(IFluidHandler tank, EntityXPOrb orb) {
        if (!orb.field_70128_L) {
            FluidStack xpStack = OpenBlocks.XP_FLUID.copy();
            xpStack.amount = EnchantmentUtils.XPToLiquidRatio((int)orb.func_70526_d());
            int filled = tank.fill(ForgeDirection.UP, xpStack, false);
            if (filled == xpStack.amount) {
                tank.fill(ForgeDirection.UP, xpStack, true);
                orb.func_70106_y();
            }
        }
    }

    public void searchForTank() {
        this.targetTank = null;
        for (int y = this.field_145848_d - 1; y > 0; --y) {
            boolean isAir = this.field_145850_b.func_147437_c(this.field_145851_c, y, this.field_145849_e);
            if (isAir) continue;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
            if (!(te instanceof IFluidHandler) && te != null) {
                Block block = te.func_145838_q();
                if (!block.func_149662_c()) continue;
                return;
            }
            this.targetTank = new WeakReference<TileEntity>(te);
            return;
        }
    }

    protected List<EntityPlayer> getPlayersOnGrid() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        return this.field_145850_b.func_72872_a(EntityPlayer.class, bb);
    }

    protected List<EntityXPOrb> getXPOrbsOnGrid() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.3), (double)(this.field_145849_e + 1));
        return this.field_145850_b.func_72872_a(EntityXPOrb.class, bb);
    }
}

