/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiVacuumHopper;
import openblocks.common.container.ContainerVacuumHopper;
import openblocks.common.entity.EntityItemProjectile;
import openmods.OpenMods;
import openmods.api.IActivateAwareTile;
import openmods.api.IHasGui;
import openmods.api.IValueProvider;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.legacy.ItemDistribution;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableDirs;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

public class TileEntityVacuumHopper
extends SyncedTileEntity
implements IInventoryProvider,
IActivateAwareTile,
IHasGui,
IEntitySelector {
    public static final int TANK_CAPACITY = EnchantmentUtils.XPToLiquidRatio((int)EnchantmentUtils.getExperienceForLevel((int)5));
    private SyncableTank tank;
    public SyncableDirs xpOutputs;
    public SyncableDirs itemOutputs;
    public SyncableBoolean vacuumDisabled;
    private final GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("vacuumhopper", true, 10));
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter sided = new SidedInventoryAdapter((IInventory)this.inventory);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Source((IReadableBitMap)this.xpOutputs, (IFluidTank)this.tank);

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
        this.xpOutputs = new SyncableDirs();
        this.itemOutputs = new SyncableDirs();
        this.vacuumDisabled = new SyncableBoolean();
    }

    public TileEntityVacuumHopper() {
        this.sided.registerAllSlots((IReadableBitMap)this.itemOutputs, false, true);
    }

    public IReadableBitMap<ForgeDirection> getReadableXpOutputs() {
        return this.xpOutputs;
    }

    public IWriteableBitMap<ForgeDirection> getWriteableXpOutputs() {
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)this.xpOutputs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IReadableBitMap<ForgeDirection> getReadableItemOutputs() {
        return this.itemOutputs;
    }

    public IWriteableBitMap<ForgeDirection> getWriteableItemOutputs() {
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)this.itemOutputs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    public boolean func_82704_a(Entity entity) {
        if (entity.field_70128_L) {
            return false;
        }
        if (entity instanceof EntityItemProjectile) {
            return entity.field_70181_x < 0.01;
        }
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            return ItemDistribution.testInventoryInsertion((IInventory)this.inventory, (ItemStack)stack) > 0;
        }
        if (entity instanceof EntityXPOrb) {
            return this.tank.getSpace() > 0;
        }
        return false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.vacuumDisabled.get()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72869_a("portal", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.field_145850_b.field_73012_v.nextDouble() - 0.5, this.field_145850_b.field_73012_v.nextDouble() - 1.0, this.field_145850_b.field_73012_v.nextDouble() - 0.5);
        }
        List interestingItems = this.field_145850_b.func_82733_a(Entity.class, this.getBB().func_72314_b(3.0, 3.0, 3.0), (IEntitySelector)this);
        for (Entity entity : interestingItems) {
            double x = (double)this.field_145851_c + 0.5 - entity.field_70165_t;
            double y = (double)this.field_145848_d + 0.5 - entity.field_70163_u;
            double z = (double)this.field_145849_e + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.1) {
                this.onEntityCollidedWithBlock(entity);
                continue;
            }
            double var11 = 1.0 - distance / 15.0;
            if (!(var11 > 0.0)) continue;
            var11 *= var11;
            entity.field_70159_w += x / distance * var11 * 0.05;
            entity.field_70181_x += y / distance * var11 * 0.2;
            entity.field_70179_y += z / distance * var11 * 0.05;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.outputToNeighbors();
        }
    }

    private void outputToNeighbors() {
        this.tank.distributeToSides(50, this.field_145850_b, this.getPosition(), this.xpOutputs.getValue());
        if (OpenMods.proxy.getTicks(this.field_145850_b) % 10L == 0L) {
            this.autoInventoryOutput();
        }
    }

    private void autoInventoryOutput() {
        int firstUsedSlot = -1;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            firstUsedSlot = i;
            break;
        }
        if (firstUsedSlot < 0) {
            return;
        }
        ArrayList outputSides = Lists.newArrayList((Iterable)this.itemOutputs.getValue());
        Collections.shuffle(outputSides);
        for (ForgeDirection output : outputSides) {
            TileEntity tileOnSurface = this.getTileInDirection(output);
            if (ItemDistribution.moveItemInto((IInventory)this.inventory, (int)firstUsedSlot, (TileEntity)tileOnSurface, (ForgeDirection)output, (int)64, (boolean)true) <= 0) continue;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            break;
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerVacuumHopper((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiVacuumHopper(new ContainerVacuumHopper((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c) == null) {
            this.vacuumDisabled.toggle();
            return true;
        }
        return false;
    }

    public void onEntityCollidedWithBlock(Entity entity) {
        if (!this.field_145850_b.field_72995_K) {
            if (entity instanceof EntityItem && !entity.field_70128_L) {
                EntityItem item = (EntityItem)entity;
                ItemStack stack = item.func_92059_d().func_77946_l();
                ItemDistribution.insertItemIntoInventory((IInventory)this.inventory, (ItemStack)stack);
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                } else {
                    item.func_92058_a(stack);
                }
            } else if (entity instanceof EntityXPOrb && this.tank.getSpace() > 0) {
                FluidStack newFluid = new FluidStack(OpenBlocks.Fluids.xpJuice, EnchantmentUtils.XPToLiquidRatio((int)((EntityXPOrb)entity).func_70526_d()));
                this.tank.fill(newFluid, true);
                entity.func_70106_y();
            }
        }
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

