/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.TrophyHandler;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomHarvestDrops;
import openmods.api.IPlaceAwareTile;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityTrophy
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile,
ICustomHarvestDrops {
    public static TrophyHandler.Trophy debugTrophy = TrophyHandler.Trophy.Wolf;
    private int cooldown = 0;
    private SyncableInt trophyIndex;

    protected void createSyncedFields() {
        this.trophyIndex = new SyncableInt(-1);
    }

    public TrophyHandler.Trophy getTrophy() {
        int trophyId = this.trophyIndex.get();
        return trophyId >= 0 ? TrophyHandler.Trophy.VALUES[trophyId] : null;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            TrophyHandler.Trophy trophy = this.getTrophy();
            if (trophy != null) {
                trophy.executeTickBehavior(this);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TrophyHandler.Trophy trophyType;
        if (!this.field_145850_b.field_72995_K && (trophyType = this.getTrophy()) != null) {
            trophyType.playSound(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.cooldown <= 0) {
                this.cooldown = trophyType.executeActivateBehavior(this, player);
            }
        }
        return true;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag;
        boolean set = false;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("entity")) {
            String entityKey = tag.func_74779_i("entity");
            this.trophyIndex.set(TrophyHandler.Trophy.valueOf(entityKey).ordinal());
            set = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!set) {
                int next = (debugTrophy.ordinal() + 1) % TrophyHandler.Trophy.values().length;
                debugTrophy = TrophyHandler.Trophy.values()[next];
                this.trophyIndex.set(debugTrophy.ordinal());
            }
            this.sync();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cooldown = tag.func_74762_e("cooldown");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        Preconditions.checkElementIndex((int)metadata, (int)TrophyHandler.Trophy.VALUES.length);
        super.prepareForInventoryRender(block, metadata);
        this.trophyIndex.set(metadata);
    }

    public boolean suppressNormalHarvestDrops() {
        return true;
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops) {
        TrophyHandler.Trophy trophy = this.getTrophy();
        if (trophy != null) {
            drops.add(trophy.getItemStack());
        }
    }
}

