/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityGrave
extends SyncedTileEntity
implements IPlaceAwareTile,
IInventoryProvider,
INeighbourAwareTile {
    private SyncableString perishedUsername;
    public SyncableBoolean onSoil;
    private int ticksSinceLastSound = 0;
    private GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("grave", false, 100));

    protected void createSyncedFields() {
        this.perishedUsername = new SyncableString();
        this.onSoil = new SyncableBoolean();
    }

    public void func_145845_h() {
        List mobs;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K && this.ticksSinceLastSound++ > 100) {
            this.ticksSinceLastSound = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73013_u != EnumDifficulty.PEACEFUL && this.field_145850_b.field_73012_v.nextDouble() < 0.002 && (mobs = this.field_145850_b.func_72872_a(IMob.class, this.getBB().func_72314_b(7.0, 7.0, 7.0))).size() < 5) {
            double chance = this.field_145850_b.field_73012_v.nextDouble();
            EntitySkeleton living = chance < 0.5 ? new EntitySkeleton(this.field_145850_b) : new EntityBat(this.field_145850_b);
            living.func_70080_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (living.func_70601_bi()) {
                this.field_145850_b.func_72838_d((Entity)living);
            }
        }
    }

    public String getUsername() {
        return this.perishedUsername.getValue();
    }

    public void setUsername(String username) {
        this.perishedUsername.setValue(username);
    }

    public void setLoot(IInventory invent) {
        this.inventory.copyFrom(invent);
    }

    public boolean isOnSoil() {
        return this.onSoil.get();
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K && !(player instanceof FakePlayer)) {
            this.setUsername(player.func_146103_bH().getName());
            if (player.field_71075_bZ.field_75098_d) {
                this.setLoot((IInventory)player.field_71071_by);
            }
            this.sync();
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    protected void updateBlockBelow() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        this.onSoil.set(block == Blocks.field_150346_d || block == Blocks.field_150349_c);
    }

    public void initialize() {
        this.updateBlockBelow();
    }

    public void onNeighbourChanged(Block block) {
        this.updateBlockBelow();
        this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }
}

