/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockCanvas;
import openblocks.common.tileentity.TileEntityCanvas;
import openmods.infobook.BookDocumentation;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;
import openmods.utils.render.PaintUtils;

@BookDocumentation(customName="paintbrush")
public class ItemPaintBrush
extends Item {
    private static final String TAG_COLOR = "color";
    public static final int MAX_USES = 24;
    public IIcon paintIcon;

    public ItemPaintBrush() {
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77625_d(1);
        this.func_77656_e(24);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Integer color = ItemPaintBrush.getColorFromStack(itemStack);
        if (color != null) {
            list.add(String.format("#%06X", color));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a("openblocks:paintbrush");
        this.paintIcon = registry.func_94245_a("openblocks:paintbrush_paint");
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Item)this));
        for (ColorUtils.ColorMeta color : ColorUtils.getAllColors()) {
            list.add(ItemPaintBrush.createStackWithColor(color.rgb));
        }
    }

    public static ItemStack createStackWithColor(int color) {
        ItemStack stack = new ItemStack((Item)OpenBlocks.Items.paintBrush);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        Integer color = ItemPaintBrush.getColorFromStack(stack);
        if (stack.func_77960_j() >= 24 || color == null) {
            return true;
        }
        if (PaintUtils.instance.isAllowedToReplace(world, x, y, z)) {
            BlockCanvas.replaceBlock(world, x, y, z);
        }
        if ((te = world.func_147438_o(x, y, z)) instanceof TileEntityCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            if (player.func_70093_af()) {
                canvas.applyPaint(color, TileEntityCanvas.ALL_SIDES);
            } else {
                canvas.applyPaint(color, side);
            }
            world.func_72956_a((Entity)player, "mob.slime.small", 0.1f, 0.8f);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int pass) {
        Integer color;
        if (pass == 1 && (color = ItemPaintBrush.getColorFromStack(itemStack)) != null) {
            return color;
        }
        return 0xFFFFFF;
    }

    public IIcon func_77618_c(int dmg, int pass) {
        return pass == 1 ? this.paintIcon : this.func_77617_a(dmg);
    }

    public static Integer getColorFromStack(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b(TAG_COLOR)) {
            return tag.func_74762_e(TAG_COLOR);
        }
        return null;
    }

    public static void setColor(ItemStack stack, int color) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
    }
}

