/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.core.CoFHProps;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModVersion;
import cofh.mod.updater.UpdateCheckThread;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class UpdateManager {
    private static transient int pollOffset = 0;
    private static final ChatStyle description = new ChatStyle();
    private static final ChatStyle version = new ChatStyle();
    private boolean _notificationDisplayed;
    private final IUpdatableMod _mod;
    private final UpdateCheckThread _updateThread;
    private final String _downloadUrl;
    private int lastPoll = 400;

    public static void registerUpdater(UpdateManager updateManager) {
        FMLCommonHandler.instance().bus().register((Object)updateManager);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod) {
        this(iUpdatableMod, null);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod, String string) {
        this(iUpdatableMod, string, null);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod, String string, String string2) {
        this._mod = iUpdatableMod;
        this._updateThread = new UpdateCheckThread(iUpdatableMod, string);
        this._updateThread.start();
        this._downloadUrl = string2;
        this.lastPoll += (pollOffset += 140);
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (!this._notificationDisplayed && this._updateThread.checkComplete()) {
            this._notificationDisplayed = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            if (this._updateThread.newVersionAvailable()) {
                if (!CoFHProps.enableUpdateNotice && !this._updateThread.isCriticalUpdate()) {
                    return;
                }
                ModVersion modVersion = this._updateThread.newVersion();
                EntityPlayer entityPlayer = playerTickEvent.player;
                entityPlayer.func_145747_a(new ChatComponentText(EnumChatFormatting.GOLD + "[" + this._mod.getModName() + "]").func_150258_a(EnumChatFormatting.WHITE + " A new version is available:"));
                String string = modVersion.modVersion().toString();
                IChatComponent iChatComponent = Strings.isNullOrEmpty((String)this._downloadUrl) ? new ChatComponentText(string).func_150255_a(version) : IChatComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + string + "\",\"color\":\"aqua\"}," + "{\"text\":\" " + EnumChatFormatting.WHITE + "[" + EnumChatFormatting.GREEN + "Download" + EnumChatFormatting.WHITE + "]\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"Click this to download the latest version\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this._downloadUrl + "\"}}]"));
                entityPlayer.func_145747_a(iChatComponent);
                entityPlayer.func_145747_a(new ChatComponentText(modVersion.description()).func_150255_a(description));
            }
        }
    }

    static {
        description.func_150238_a(EnumChatFormatting.GRAY);
        version.func_150238_a(EnumChatFormatting.AQUA);
    }
}

