/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod;

import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModRange;
import cofh.mod.updater.ModVersion;
import com.google.common.base.Strings;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.helpers.Loader;
import org.apache.logging.log4j.spi.AbstractLogger;

public abstract class BaseMod
implements IUpdatableMod {
    protected File _configFolder;
    protected final String _modid;
    protected final Logger _log;

    protected BaseMod(Logger logger) {
        String string = this.getModId();
        this._modid = string.toLowerCase();
        this._log = logger;
    }

    protected BaseMod() {
        String string = this.getModId();
        this._modid = string.toLowerCase();
        this._log = LogManager.getLogger((String)string);
    }

    @NetworkCheckHandler
    public final boolean networkCheck(Map<String, String> map, Side side) throws InvalidVersionSpecificationException {
        if (!this.requiresRemoteFrom(side)) {
            return true;
        }
        Mod mod = this.getClass().getAnnotation(Mod.class);
        String string = mod.modid();
        if (!map.containsKey(string)) {
            return false;
        }
        String string2 = mod.acceptableRemoteVersions();
        if (!"*".equals(string2)) {
            String string3 = map.get(string);
            if (Strings.isNullOrEmpty((String)string2)) {
                return this.getModVersion().equalsIgnoreCase(string3);
            }
            return ModRange.createFromVersionSpec(string, string2).containsVersion((ArtifactVersion)new ModVersion(string, string3));
        }
        return true;
    }

    protected boolean requiresRemoteFrom(Side side) {
        return true;
    }

    protected String getConfigBaseFolder() {
        String string = this.getClass().getPackage().getName();
        int n = string.indexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    protected void setConfigFolderBase(File file) {
        this._configFolder = new File(file, this.getConfigBaseFolder() + "/" + this._modid + "/");
    }

    protected File getConfig(String string) {
        return new File(this._configFolder, string + ".cfg");
    }

    protected File getClientConfig() {
        return this.getConfig("client");
    }

    protected File getCommonConfig() {
        return this.getConfig("common");
    }

    protected String getAssetDir() {
        return this._modid;
    }

    @Override
    public Logger getLogger() {
        return this._log;
    }

    private LinkedList<String> loadLanguageList(InputStream inputStream) throws Throwable {
        return this.loadLanguageList(inputStream, new LinkedList<String>());
    }

    private LinkedList<String> loadLanguageList(InputStream inputStream, LinkedList<String> linkedList) throws Throwable {
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        jsonReader.setLenient(true);
        if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
        }
        block3: while (true) {
            switch (jsonReader.peek()) {
                case END_ARRAY: 
                case END_DOCUMENT: {
                    break block3;
                }
                default: {
                    linkedList.add(jsonReader.nextString());
                    continue block3;
                }
            }
            break;
        }
        jsonReader.close();
        return linkedList;
    }

    private void loadLanguageFile(String string, InputStream inputStream) throws Throwable {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        Properties properties = new Properties();
        properties.load(inputStreamReader);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.putAll(properties);
        LanguageRegistry.instance().injectLanguage(string.intern(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLang() {
        if (FMLLaunchHandler.side() == Side.CLIENT) {
            try {
                this.loadClientLang();
                return;
            }
            catch (Throwable throwable) {
                this._log.error(AbstractLogger.CATCHING_MARKER, "???", throwable);
            }
        }
        String string = "assets/" + this.getAssetDir() + "/language/";
        InputStream inputStream = null;
        try {
            inputStream = Loader.getResource((String)(string + ".languages"), null).openStream();
            for (String string2 : this.loadLanguageList(inputStream)) {
                InputStream inputStream2 = null;
                try {
                    inputStream2 = Loader.getResource((String)(string + string2 + ".lang"), null).openStream();
                    this.loadLanguageFile(string2, inputStream2);
                }
                catch (Throwable throwable) {
                    this._log.catching(Level.INFO, throwable);
                }
                finally {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                        this._log.catching(Level.INFO, (Throwable)iOException);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this._log.catching(Level.WARN, throwable);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this._log.catching(Level.WARN, (Throwable)iOException);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClientLang() {
        IReloadableResourceManager iReloadableResourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        iReloadableResourceManager.func_110542_a((IResourceManagerReloadListener)new LangManager((IResourceManager)iReloadableResourceManager));
    }

    @SideOnly(value=Side.CLIENT)
    private class LangManager
    implements IResourceManagerReloadListener {
        private final String _path;

        public LangManager(IResourceManager iResourceManager) {
            this._path = BaseMod.this.getAssetDir() + ":language/";
            this.loadAllLanguages(iResourceManager);
        }

        public void func_110549_a(IResourceManager iResourceManager) {
            String string = null;
            try {
                string = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            }
            catch (Throwable throwable) {
                BaseMod.this._log.catching(Level.WARN, throwable);
            }
            for (String string2 : Arrays.asList("en_US", string)) {
                if (string2 == null) continue;
                try {
                    List list = iResourceManager.func_135056_b(new ResourceLocation(this._path + string2 + ".lang"));
                    for (IResource iResource : list) {
                        if (iResource.func_110527_b() == null) {
                            BaseMod.this._log.warn("A resource pack defines an entry for language '" + string2 + "' but the InputStream is null.");
                            continue;
                        }
                        try {
                            BaseMod.this.loadLanguageFile(string2, iResource.func_110527_b());
                        }
                        catch (Throwable throwable) {
                            BaseMod.this._log.warn(AbstractLogger.CATCHING_MARKER, "A resource pack has a file for language '" + string2 + "' but the file is invalid.", throwable);
                        }
                    }
                }
                catch (Throwable throwable) {
                    BaseMod.this._log.info(AbstractLogger.CATCHING_MARKER, "No language data for '" + string2 + "'", throwable);
                }
            }
        }

        public void loadAllLanguages(IResourceManager iResourceManager) {
            try {
                LinkedList linkedList = new LinkedList();
                List list = iResourceManager.func_135056_b(new ResourceLocation(this._path + ".languages"));
                for (Object object : list) {
                    try {
                        BaseMod.this.loadLanguageList(object.func_110527_b(), linkedList);
                    }
                    catch (Throwable throwable) {
                        BaseMod.this._log.warn(AbstractLogger.CATCHING_MARKER, "A resource pack's .language file is invalid.", throwable);
                    }
                }
                for (Object object : linkedList) {
                    try {
                        list = iResourceManager.func_135056_b(new ResourceLocation(this._path + (String)object + ".lang"));
                        for (IResource iResource : list) {
                            if (iResource.func_110527_b() == null) {
                                BaseMod.this._log.warn("A resource pack defines an entry for language '" + (String)object + "' but the InputStream is null.");
                                continue;
                            }
                            try {
                                BaseMod.this.loadLanguageFile((String)object, iResource.func_110527_b());
                            }
                            catch (Throwable throwable) {
                                BaseMod.this._log.warn(AbstractLogger.CATCHING_MARKER, "A resource pack has a file for language '" + (String)object + "' but the file is invalid.", throwable);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        BaseMod.this._log.warn(AbstractLogger.CATCHING_MARKER, "A resource pack defines the language '" + (String)object + "' but the file does not exist.", throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                BaseMod.this._log.info(AbstractLogger.CATCHING_MARKER, "There is no '.languages' file.", throwable);
                try {
                    BaseMod.this.loadLanguageFile("en_US", iResourceManager.func_110536_a(new ResourceLocation(this._path + "en_US.lang")).func_110527_b());
                }
                catch (Throwable throwable2) {
                    BaseMod.this._log.error(AbstractLogger.CATCHING_MARKER, "There are no language files.", throwable2);
                }
            }
        }
    }
}

