/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidHelper {
    public static final int BUCKET_VOLUME = 1000;
    public static final Fluid WATER_FLUID = FluidRegistry.WATER;
    public static final Fluid LAVA_FLUID = FluidRegistry.LAVA;
    public static final FluidStack WATER = new FluidStack(WATER_FLUID, 1000);
    public static final FluidStack LAVA = new FluidStack(LAVA_FLUID, 1000);
    public static final FluidTankInfo[] NULL_TANK_INFO = new FluidTankInfo[0];

    private FluidHelper() {
    }

    public static FluidStack extractFluidFromHeldContainer(EntityPlayer entityPlayer, int n, boolean bl) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        return FluidHelper.isFluidContainerItem(itemStack) ? ((IFluidContainerItem)itemStack.func_77973_b()).drain(itemStack, n, bl) : null;
    }

    public static int insertFluidIntoHeldContainer(EntityPlayer entityPlayer, FluidStack fluidStack, boolean bl) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        return FluidHelper.isFluidContainerItem(itemStack) ? ((IFluidContainerItem)itemStack.func_77973_b()).fill(itemStack, fluidStack, bl) : 0;
    }

    public static boolean isPlayerHoldingFluidContainerItem(EntityPlayer entityPlayer) {
        return FluidHelper.isFluidContainerItem(entityPlayer.func_71045_bC());
    }

    public static boolean isFluidContainerItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof IFluidContainerItem;
    }

    public static FluidStack getFluidStackFromContainerItem(ItemStack itemStack) {
        return ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack);
    }

    public static ItemStack setDefaultFluidTag(ItemStack itemStack, FluidStack fluidStack) {
        itemStack.func_77982_d(new NBTTagCompound());
        NBTTagCompound nBTTagCompound = fluidStack.writeToNBT(new NBTTagCompound());
        itemStack.field_77990_d.func_74782_a("Fluid", (NBTBase)nBTTagCompound);
        return itemStack;
    }

    public static FluidStack extractFluidFromAdjacentFluidHandler(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IFluidHandler ? ((IFluidHandler)tileEntity2).drain(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : null;
    }

    public static int insertFluidIntoAdjacentFluidHandler(TileEntity tileEntity, int n, FluidStack fluidStack, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IFluidHandler ? ((IFluidHandler)tileEntity2).fill(ForgeDirection.VALID_DIRECTIONS[n ^ 1], fluidStack, bl) : 0;
    }

    public static boolean isAdjacentFluidHandler(TileEntity tileEntity, int n) {
        return BlockHelper.getAdjacentTileEntity(tileEntity, n) instanceof IFluidHandler;
    }

    public static boolean isFluidHandler(TileEntity tileEntity) {
        return tileEntity instanceof IFluidHandler;
    }

    public static boolean fillContainerFromHandler(World world, IFluidHandler iFluidHandler, EntityPlayer entityPlayer, FluidStack fluidStack) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
            ItemStack itemStack2 = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack);
            FluidStack fluidStack2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack2);
            if (fluidStack2 == null || itemStack2 == null) {
                return false;
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                if (itemStack.field_77994_a == 1) {
                    itemStack = itemStack.func_77946_l();
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, itemStack2);
                } else if (!entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                    return false;
                }
                iFluidHandler.drain(ForgeDirection.UNKNOWN, fluidStack2.amount, true);
                --itemStack.field_77994_a;
                if (itemStack.field_77994_a <= 0) {
                    itemStack = null;
                }
            } else {
                iFluidHandler.drain(ForgeDirection.UNKNOWN, fluidStack2.amount, true);
            }
            return true;
        }
        return false;
    }

    public static boolean fillHandlerWithContainer(World world, IFluidHandler iFluidHandler, EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (fluidStack != null && (iFluidHandler.fill(ForgeDirection.UNKNOWN, fluidStack, false) == fluidStack.amount || entityPlayer.field_71075_bZ.field_75098_d)) {
            if (ServerHelper.isClientWorld(world)) {
                return true;
            }
            iFluidHandler.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, ItemHelper.consumeItem(itemStack));
            }
            return true;
        }
        return false;
    }

    public static void writeFluidStackToPacket(FluidStack fluidStack, DataOutput dataOutput) throws IOException {
        if (!FluidHelper.isValidFluidStack(fluidStack)) {
            dataOutput.writeShort(-1);
        } else {
            byte[] byArray = CompressedStreamTools.func_74798_a((NBTTagCompound)fluidStack.writeToNBT(new NBTTagCompound()));
            dataOutput.writeShort((short)byArray.length);
            dataOutput.write(byArray);
        }
    }

    public static FluidStack readFluidStackFromPacket(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        if (s < 0) {
            return null;
        }
        byte[] byArray = new byte[s];
        dataInput.readFully(byArray);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)CompressedStreamTools.func_152457_a((byte[])byArray, (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
    }

    public static boolean isValidFluidStack(FluidStack fluidStack) {
        return fluidStack == null ? false : (fluidStack.fluidID == 0 ? false : FluidRegistry.getFluidName((FluidStack)fluidStack) != null);
    }

    public static int getFluidLuminosity(FluidStack fluidStack) {
        return fluidStack == null ? 0 : FluidHelper.getFluidLuminosity(fluidStack.getFluid());
    }

    public static int getFluidLuminosity(Fluid fluid) {
        return fluid == null ? 0 : fluid.getLuminosity();
    }

    public static FluidStack getFluidFromWorld(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        int n4 = world.func_72805_g(n, n2, n3);
        if (Block.func_149680_a((Block)block, (Block)Blocks.field_150355_j)) {
            if (n4 == 0) {
                return WATER.copy();
            }
            return null;
        }
        if (Block.func_149680_a((Block)block, (Block)Blocks.field_150353_l)) {
            if (n4 == 0) {
                return LAVA.copy();
            }
            return null;
        }
        if (block instanceof IFluidBlock) {
            IFluidBlock iFluidBlock = (IFluidBlock)block;
            return iFluidBlock.drain(world, n, n2, n3, true);
        }
        return null;
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (block == Blocks.field_150358_i) {
            return WATER_FLUID;
        }
        if (block == Blocks.field_150356_k) {
            return LAVA_FLUID;
        }
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack getFluidForFilledItem(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
    }

    public static boolean isFluidEqualOrNull(FluidStack fluidStack, FluidStack fluidStack2) {
        return fluidStack == null || fluidStack2 == null || fluidStack.isFluidEqual(fluidStack2);
    }

    public static boolean isFluidEqualOrNull(Fluid fluid, FluidStack fluidStack) {
        return fluid == null || fluidStack == null || fluid == fluidStack.getFluid();
    }

    public static boolean isFluidEqualOrNull(Fluid fluid, Fluid fluid2) {
        return fluid == null || fluid2 == null || fluid == fluid2;
    }

    public static boolean isFluidEqual(FluidStack fluidStack, FluidStack fluidStack2) {
        return fluidStack != null && fluidStack.isFluidEqual(fluidStack2);
    }

    public static boolean isFluidEqual(Fluid fluid, FluidStack fluidStack) {
        return fluid != null && fluidStack != null && fluid == fluidStack.getFluid();
    }

    public static boolean isFluidEqual(Fluid fluid, Fluid fluid2) {
        return fluid != null && fluid2 != null && fluid.equals(fluid2);
    }
}

