/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.WeightedRandomNBTTag;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.world.WorldGenAdvLakes;
import cofh.lib.world.WorldGenBoulder;
import cofh.lib.world.WorldGenDecoration;
import cofh.lib.world.WorldGenDungeon;
import cofh.lib.world.WorldGenGeode;
import cofh.lib.world.WorldGenMinableCluster;
import cofh.lib.world.WorldGenMinableLargeVein;
import cofh.lib.world.WorldGenSparseMinableCluster;
import cofh.lib.world.WorldGenSpike;
import cofh.lib.world.feature.FeatureBase;
import cofh.lib.world.feature.FeatureGenUniform;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.DungeonHooks;
import org.apache.logging.log4j.Logger;

public class UniformParser
implements IFeatureParser {
    private final List<WeightedRandomBlock> defaultMaterial = this.generateDefaultMaterial();

    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(new ItemStack(Blocks.field_150348_b, 1, -1)));
    }

    @Override
    public IFeatureGenerator parseFeature(String string, JsonObject jsonObject, Logger logger) {
        Object object;
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(jsonObject.get("block"), arrayList)) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        FeatureBase.GenRestriction genRestriction = FeatureBase.GenRestriction.NONE;
        FeatureBase.GenRestriction genRestriction2 = FeatureBase.GenRestriction.NONE;
        if (jsonObject.has("clusterSize")) {
            n = jsonObject.get("clusterSize").getAsInt();
        }
        if (jsonObject.has("numClusters")) {
            n2 = jsonObject.get("numClusters").getAsInt();
        }
        if (n < 0 || n2 <= 0) {
            logger.error("Invalid cluster size or count specified in \"" + string + "\"");
            return null;
        }
        if (jsonObject.has("retrogen")) {
            bl = jsonObject.get("retrogen").getAsBoolean();
        }
        if (jsonObject.has("biomeRestriction")) {
            object = jsonObject.get("biomeRestriction").getAsString().toLowerCase();
            if (((String)object).equals("blacklist")) {
                genRestriction = FeatureBase.GenRestriction.BLACKLIST;
            }
            if (((String)object).equals("whitelist")) {
                genRestriction = FeatureBase.GenRestriction.WHITELIST;
            }
        }
        if (jsonObject.has("dimensionRestriction")) {
            object = jsonObject.get("dimensionRestriction").getAsString().toLowerCase();
            if (((String)object).equals("blacklist")) {
                genRestriction2 = FeatureBase.GenRestriction.BLACKLIST;
            }
            if (((String)object).equals("whitelist")) {
                genRestriction2 = FeatureBase.GenRestriction.WHITELIST;
            }
        }
        object = this.parseMaterial(jsonObject, logger);
        FeatureBase featureBase = this.getFeature(string, jsonObject, this.getGenerator(jsonObject, logger, arrayList, n, (List<WeightedRandomBlock>)object), (List<WeightedRandomBlock>)object, n2, genRestriction, bl, genRestriction2, logger);
        if (jsonObject.has("chunkChance")) {
            int n3 = MathHelper.clampI(jsonObject.get("chunkChance").getAsInt(), 1, 1000000);
            featureBase.setRarity(n3);
        }
        if (featureBase != null) {
            UniformParser.addFeatureRestrictions(featureBase, jsonObject);
        }
        return featureBase;
    }

    protected FeatureBase getFeature(String string, JsonObject jsonObject, WorldGenerator worldGenerator, List<WeightedRandomBlock> list, int n, FeatureBase.GenRestriction genRestriction, boolean bl, FeatureBase.GenRestriction genRestriction2, Logger logger) {
        int n2;
        int n3 = jsonObject.get("minHeight").getAsInt();
        if (n3 >= (n2 = jsonObject.get("maxHeight").getAsInt()) || n3 < 0) {
            logger.error("Invalid height parameters specified in \"" + string + "\"");
            return null;
        }
        return new FeatureGenUniform(string, worldGenerator, n, n3, n2, genRestriction, bl, genRestriction2);
    }

    protected String getDefaultTemplate() {
        return "cluster";
    }

    protected List<WeightedRandomBlock> parseMaterial(JsonObject jsonObject, Logger logger) {
        List<WeightedRandomBlock> list = this.defaultMaterial;
        if (jsonObject.has("material")) {
            list = new ArrayList<WeightedRandomBlock>();
            if (!FeatureParser.parseResList(jsonObject.get("material"), list)) {
                logger.warn("Invalid material list! Using default list.");
                list = this.defaultMaterial;
            }
        }
        return list;
    }

    protected WorldGenerator getGenerator(JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        String string = this.getDefaultTemplate();
        boolean bl = false;
        JsonObject jsonObject2 = jsonObject;
        JsonElement jsonElement = jsonObject.get("template");
        if (jsonElement.isJsonObject()) {
            jsonObject = jsonElement.getAsJsonObject();
            bl = true;
            if (jsonObject.has("generator")) {
                string = jsonObject.get("generator").getAsString();
            }
        }
        if ("sparse-cluster".equals(string)) {
            return new WorldGenSparseMinableCluster(list, n, list2);
        }
        if ("large-vein".equals(string)) {
            boolean bl2 = true;
            if (bl) {
                bl2 = jsonObject.has("sparse") ? jsonObject.get("sparse").getAsBoolean() : bl2;
            }
            return new WorldGenMinableLargeVein(list, n, list2, bl2);
        }
        if ("lake".equals(string)) {
            boolean bl3 = false;
            if (bl) {
                bl3 = jsonObject.has("useMaterial") ? jsonObject.get("useMaterial").getAsBoolean() : bl3;
            }
            WorldGenAdvLakes worldGenAdvLakes = new WorldGenAdvLakes(list, bl3 ? list2 : null);
            if (bl) {
                if (jsonObject.has("outlineWithStone")) {
                    WeightedRandomBlock weightedRandomBlock = worldGenAdvLakes.outlineBlock = jsonObject.get("outlineWithStone").getAsBoolean() ? new WeightedRandomBlock(Blocks.field_150348_b, 0) : null;
                }
                if (jsonObject.has("outlineBlock")) {
                    worldGenAdvLakes.outlineBlock = FeatureParser.parseBlockEntry(jsonObject.get("outlineBlock"));
                }
                if (jsonObject.has("gapBlock")) {
                    worldGenAdvLakes.gapBlock = FeatureParser.parseBlockEntry(jsonObject.get("gapBlock"));
                }
                if (jsonObject.has("lineWithFiller")) {
                    worldGenAdvLakes.lineWithFiller = jsonObject.get("lineWithFiller").getAsBoolean();
                }
            }
            return worldGenAdvLakes;
        }
        if ("geode".equals(string)) {
            ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
            if (!jsonObject2.has("crust")) {
                logger.info("Entry does not specify crust for 'geode' generator. Using stone.");
                arrayList.add(new WeightedRandomBlock(Blocks.field_150348_b));
            } else if (!FeatureParser.parseResList(jsonObject2.get("crust"), arrayList)) {
                logger.warn("Entry specifies invalid crust for 'geode' generator! Using obsidian!");
                arrayList.clear();
                arrayList.add(new WeightedRandomBlock(Blocks.field_150343_Z));
            }
            WorldGenGeode worldGenGeode = new WorldGenGeode(list, list2, arrayList);
            if (bl && jsonObject.has("hollow")) {
                worldGenGeode.hollow = jsonObject.get("hollow").getAsBoolean();
            }
            return worldGenGeode;
        }
        if ("decoration".equals(string)) {
            ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
            if (!jsonObject2.has("genSurface")) {
                logger.info("Entry does not specify genSurface for 'decoration' generator. Using grass.");
                arrayList.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
            } else if (!FeatureParser.parseResList(jsonObject2.get("genSurface"), arrayList)) {
                logger.warn("Entry specifies invalid genSurface for 'decoration' generator! Using grass!");
                arrayList.clear();
                arrayList.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
            }
            WorldGenDecoration worldGenDecoration = new WorldGenDecoration(list, n, list2, arrayList);
            if (jsonObject.has("genSky")) {
                worldGenDecoration.seeSky = jsonObject.get("genSky").getAsBoolean();
            }
            if (jsonObject.has("checkStay")) {
                worldGenDecoration.checkStay = jsonObject.get("checkStay").getAsBoolean();
            }
            if (jsonObject.has("stackHeight")) {
                worldGenDecoration.stackHeight = jsonObject.get("stackHeight").getAsInt();
            }
            if (jsonObject.has("xVariance")) {
                worldGenDecoration.stackHeight = jsonObject.get("xVariance").getAsInt();
            }
            if (jsonObject.has("yVariance")) {
                worldGenDecoration.stackHeight = jsonObject.get("yVariance").getAsInt();
            }
            if (jsonObject.has("zVariance")) {
                worldGenDecoration.stackHeight = jsonObject.get("zVariance").getAsInt();
            }
            return worldGenDecoration;
        }
        if ("boulder".equals(string)) {
            WorldGenBoulder worldGenBoulder = new WorldGenBoulder(list, n, list2);
            if (bl) {
                if (jsonObject.has("sizeVariance")) {
                    worldGenBoulder.sizeVariance = jsonObject.get("sizeVariance").getAsInt();
                }
                if (jsonObject.has("count")) {
                    worldGenBoulder.clusters = jsonObject.get("count").getAsInt();
                }
            }
            return worldGenBoulder;
        }
        if ("spike".equals(string)) {
            WorldGenSpike worldGenSpike = new WorldGenSpike(list, list2);
            if (bl && jsonObject.has("largeSpikes")) {
                worldGenSpike.largeSpikes = jsonObject.get("largeSpikes").getAsBoolean();
            }
            return worldGenSpike;
        }
        if ("dungeon".equals(string)) {
            Object object;
            ArrayList<WeightedRandomNBTTag> arrayList = new ArrayList<WeightedRandomNBTTag>();
            if (jsonObject2.has("spawnEntity")) {
                if (!FeatureParser.parseEntityList(jsonObject2.get("spawnEntity"), arrayList)) {
                    logger.warn("Entry specifies invalid entity list for 'dungeon' generator! Using 'Pig'!");
                    arrayList.clear();
                    object = new NBTTagCompound();
                    object.func_74778_a("EntityId", "Pig");
                    arrayList.add(new WeightedRandomNBTTag(100, (NBTBase)object));
                }
            } else {
                logger.warn("Entry specifies invalid entity list for 'dungeon' generator! Using 'Pig'!");
                object = new NBTTagCompound();
                object.func_74778_a("EntityId", "Pig");
                arrayList.add(new WeightedRandomNBTTag(100, (NBTBase)object));
            }
            object = new WorldGenDungeon(list, list2, arrayList);
            if (jsonObject2.has("spawnerFloor")) {
                list = new ArrayList<WeightedRandomBlock>();
                if (FeatureParser.parseResList(jsonObject2.get("spawnerFloor"), list)) {
                    object.floor = list;
                } else {
                    logger.warn("Entry specifies invalid block list for 'spawnerFloor'! Using walls.");
                }
            }
            if (bl) {
                if (jsonObject.has("lootTable")) {
                    ArrayList<DungeonHooks.DungeonMob> arrayList2 = new ArrayList<DungeonHooks.DungeonMob>();
                    if (FeatureParser.parseWeightedStringList(jsonObject.get("lootTable"), arrayList2)) {
                        object.lootTables = arrayList2;
                    } else {
                        logger.warn("Entry specifies invalid string list for 'lootTable'! Using default.");
                    }
                }
                if (jsonObject.has("maxChests")) {
                    object.maxChests = jsonObject.get("maxChests").getAsInt();
                }
                if (jsonObject.has("minHoles")) {
                    object.minHoles = jsonObject.get("minHoles").getAsInt();
                }
                if (jsonObject.has("maxHoles")) {
                    object.maxHoles = jsonObject.get("maxHoles").getAsInt();
                }
                if (jsonObject.has("minHeight")) {
                    object.minHeight = jsonObject.get("minHeight").getAsInt();
                }
                if (jsonObject.has("maxHeight")) {
                    object.maxHeight = jsonObject.get("maxHeight").getAsInt();
                }
                if (jsonObject.has("minWidthX")) {
                    object.minWidthX = jsonObject.get("minWidthX").getAsInt();
                }
                if (jsonObject.has("maxWidthX")) {
                    object.maxWidthX = jsonObject.get("maxWidthX").getAsInt();
                }
                if (jsonObject.has("minWidthZ")) {
                    object.minWidthZ = jsonObject.get("minWidthZ").getAsInt();
                }
                if (jsonObject.has("maxWidthZ")) {
                    object.maxWidthZ = jsonObject.get("maxWidthZ").getAsInt();
                }
            }
            return object;
        }
        if (!"cluster".equals(string)) {
            logger.warn("Unknown generator " + string + "! Using 'cluster'");
        }
        return new WorldGenMinableCluster(list, n, list2);
    }

    protected static boolean addFeatureRestrictions(FeatureBase featureBase, JsonObject jsonObject) {
        if (featureBase.biomeRestriction != FeatureBase.GenRestriction.NONE) {
            featureBase.addBiomes(FeatureParser.parseBiomeRestrictions(jsonObject));
        }
        if (featureBase.dimensionRestriction != FeatureBase.GenRestriction.NONE && jsonObject.has("dimensions")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("dimensions");
            for (int i = 0; i < jsonArray.size(); ++i) {
                featureBase.addDimension(jsonArray.get(i).getAsInt());
            }
        }
        return true;
    }
}

