/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network;

import cofh.core.network.PacketBase;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public abstract class PacketCoFHBase
extends PacketBase {
    private ByteArrayOutputStream arrayout;
    private DataOutputStream dataout;
    public DataInputStream datain;

    public PacketCoFHBase() {
        this.arrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.arrayout);
    }

    public PacketCoFHBase(byte[] byArray) {
        this.datain = new DataInputStream(new ByteArrayInputStream(byArray));
    }

    public PacketCoFHBase addString(String string) {
        try {
            this.dataout.writeUTF(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addInt(int n) {
        try {
            this.dataout.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addBool(boolean bl) {
        try {
            this.dataout.writeBoolean(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addByte(byte by) {
        try {
            this.dataout.writeByte(by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addByte(int n) {
        return this.addByte((byte)n);
    }

    public PacketCoFHBase addShort(short s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addShort(int n) {
        return this.addShort((short)n);
    }

    public PacketCoFHBase addByteArray(byte[] byArray) {
        try {
            this.dataout.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addItemStack(ItemStack itemStack) {
        try {
            this.writeItemStack(itemStack);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addFluidStack(FluidStack fluidStack) {
        try {
            FluidHelper.writeFluidStackToPacket(fluidStack, this.dataout);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public PacketCoFHBase addCoords(TileEntity tileEntity) {
        this.addInt(tileEntity.field_145851_c);
        this.addInt(tileEntity.field_145848_d);
        return this.addInt(tileEntity.field_145849_e);
    }

    public PacketCoFHBase addCoords(int n, int n2, int n3) {
        this.addInt(n);
        this.addInt(n2);
        return this.addInt(n3);
    }

    public String getString() {
        try {
            return this.datain.readUTF();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int getInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public boolean getBool() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public byte getByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public short getShort() {
        try {
            return this.datain.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public void getByteArray(byte[] byArray) {
        try {
            this.datain.readFully(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public float getFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0.0f;
        }
    }

    public ItemStack getItemStack() {
        try {
            return this.readItemStack();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public FluidStack getFluidStack() {
        try {
            return FluidHelper.readFluidStackFromPacket(this.datain);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int[] getCoords() {
        return new int[]{this.getInt(), this.getInt(), this.getInt()};
    }

    private void writeItemStack(ItemStack itemStack) throws IOException {
        if (itemStack == null) {
            this.addShort(-1);
        } else {
            this.addShort(Item.func_150891_b((Item)itemStack.func_77973_b()));
            this.addByte(itemStack.field_77994_a);
            this.addShort(ItemHelper.getItemDamage(itemStack));
            this.writeNBT(itemStack.field_77990_d);
        }
    }

    public ItemStack readItemStack() throws IOException {
        ItemStack itemStack = null;
        short s = this.getShort();
        if (s >= 0) {
            byte by = this.getByte();
            short s2 = this.getShort();
            itemStack = new ItemStack(Item.func_150899_d((int)s), (int)by, (int)s2);
            itemStack.field_77990_d = this.readNBT();
        }
        return itemStack;
    }

    public void writeNBT(NBTTagCompound nBTTagCompound) throws IOException {
        if (nBTTagCompound == null) {
            this.addShort(-1);
        } else {
            byte[] byArray = CompressedStreamTools.func_74798_a((NBTTagCompound)nBTTagCompound);
            this.addShort((short)byArray.length);
            this.addByteArray(byArray);
        }
    }

    public NBTTagCompound readNBT() throws IOException {
        short s = this.getShort();
        if (s < 0) {
            return null;
        }
        byte[] byArray = new byte[s];
        this.getByteArray(byArray);
        return CompressedStreamTools.func_152457_a((byte[])byArray, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    @Override
    public void encodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        byteBuf.writeBytes(this.arrayout.toByteArray());
    }

    @Override
    public void decodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.datain = new DataInputStream(new ByteArrayInputStream(byteBuf.array()));
        try {
            this.datain.skipBytes(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer entityPlayer) {
        this.handlePacket(entityPlayer, false);
    }

    @Override
    public void handleServerSide(EntityPlayer entityPlayer) {
        this.handlePacket(entityPlayer, true);
    }

    public abstract void handlePacket(EntityPlayer var1, boolean var2);
}

