/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import xreliquary.Reliquary;

public class ItemTear
extends ItemToggleable {
    @SideOnly(value=Side.CLIENT)
    protected IIcon emptyIcon;
    protected boolean useAmount = false;
    protected boolean absorbByDefault = true;

    public ItemTear(String langName) {
        super(langName);
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77960_j() == 1 ? 1 : 16;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta == 0) {
            return this.emptyIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        this.emptyIcon = register.func_94245_a("xreliquary:" + this.func_77658_a().substring(5) + "_empty");
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return super.func_77667_c(stack) + "_empty";
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        this.formatTooltip(null, stack, list);
        NBTTagCompound tag = stack.func_77978_p();
        if (stack.func_77960_j() == 0 || this.getStackFromTear(stack) == null) {
            list.add(LanguageHelper.getLocalization((String)"tooltip.tear_empty"));
        } else {
            String itemName;
            ItemStack contents = this.getStackFromTear(stack);
            String holds = itemName = contents.func_82833_r();
            if (tag.func_74764_b("itemQuantity")) {
                LanguageHelper.formatTooltip((String)"tooltip.tear_quantity", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)itemName, (Object)"amount", (Object)String.valueOf(tag.func_74765_d("itemQuantity"))), (ItemStack)stack, (List)list);
            } else {
                LanguageHelper.formatTooltip((String)"tooltip.tear", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)itemName), (ItemStack)stack, (List)list);
            }
            if (this.isEnabled(stack)) {
                LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.YELLOW + holds)), (ItemStack)stack, (List)list);
                list.add(LanguageHelper.getLocalization((String)"tooltip.absorb_tear"));
            }
            list.add(LanguageHelper.getLocalization((String)"tooltip.absorb"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return stack.func_77960_j() == 1 && this.isEnabled(stack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack newStack = super.func_77659_a(stack, world, player);
        if (player.func_70093_af() && stack.func_77960_j() == 1) {
            return newStack;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (stack.func_77960_j() == 1) {
            if (this.shouldEmpty(stack, player)) {
                tag.func_82580_o("itemID");
                tag.func_82580_o("itemMeta");
                if (tag.func_74764_b("itemQuantity")) {
                    tag.func_82580_o("itemQuantity");
                }
                stack.func_77964_b(0);
            }
        } else {
            ItemStack returnStack = this.buildTear(stack, player, (IInventory)player.field_71071_by, player.field_71071_by.field_70462_a.length);
            if (returnStack != null) {
                return returnStack;
            }
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (world.func_147438_o(x, y, z) instanceof IInventory) {
            IInventory inventory = (IInventory)world.func_147438_o(x, y, z);
            if (stack.func_77960_j() == 1) {
                if (this.shouldEmpty(stack, player, inventory, 0)) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.newItemStack());
                }
                return true;
            }
            ItemStack returnStack = this.buildTear(stack, player, inventory, 0);
            if (returnStack != null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean f) {
        if (world.field_72995_K || stack.func_77960_j() == 0 || !this.isEnabled(stack)) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack contents = this.getStackFromTear(stack);
        if (InventoryHelper.consumeItem((Object)contents, (EntityPlayer)player, (int)contents.func_77976_d())) {
            this.onAbsorb(stack, player);
        }
    }

    protected ItemStack buildTear(ItemStack stack, EntityPlayer player, IInventory inventory, int limit) {
        ItemStack tear = this.newItemStack();
        NBTTagCompound tT = tear.func_77978_p();
        ItemStack target = InventoryHelper.getTargetItem((ItemStack)stack, (IInventory)inventory, (boolean)false);
        if (target == null) {
            return null;
        }
        tT.func_74778_a("itemID", ContentHelper.getIdent((Item)target.func_77973_b()));
        tT.func_74777_a("itemMeta", (short)target.func_77960_j());
        if (this.useAmount) {
            int quantity = InventoryHelper.getItemQuantity((ItemStack)target, (IInventory)inventory, (int)(limit > 0 ? limit : 0));
            InventoryHelper.removeItem((ItemStack)target, (IInventory)inventory, (int)quantity, (int)(limit > 0 ? limit : 0));
            tT.func_74777_a("itemQuantity", (short)quantity);
        } else {
            InventoryHelper.removeItem((ItemStack)target, (IInventory)inventory, (int)1, (int)(limit > 0 ? limit : 0));
        }
        if (this.absorbByDefault) {
            tT.func_74757_a("enabled", true);
        }
        tear.func_77964_b(1);
        --stack.field_77994_a;
        if (stack.field_77994_a == 0) {
            return tear;
        }
        this.addTearToInventory(player, tear);
        return null;
    }

    protected void addTearToInventory(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            EntityItem entity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            player.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    public ItemStack getStackFromTear(ItemStack tear) {
        NBTTagCompound tag = tear.func_77978_p();
        if (tag == null) {
            return null;
        }
        return new ItemStack((Item)Item.field_150901_e.func_82594_a(tag.func_74779_i("itemID")), 1, (int)tag.func_74765_d("itemMeta"));
    }

    protected boolean shouldEmpty(ItemStack stack, EntityPlayer player) {
        return this.shouldEmpty(stack, player, (IInventory)player.field_71071_by, player.field_71071_by.field_70462_a.length);
    }

    protected boolean shouldEmpty(ItemStack stack, EntityPlayer player, IInventory inventory, int limit) {
        return true;
    }

    protected void onAbsorb(ItemStack stack, EntityPlayer player) {
    }
}

