/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.entities.EntityCondensedFertility;
import xreliquary.entities.EntityCondensedSplashAphrodite;
import xreliquary.entities.EntityCondensedSplashBlindness;
import xreliquary.entities.EntityCondensedSplashConfusion;
import xreliquary.entities.EntityCondensedSplashHarm;
import xreliquary.entities.EntityCondensedSplashPoison;
import xreliquary.entities.EntityCondensedSplashRuin;
import xreliquary.entities.EntityCondensedSplashSlowness;
import xreliquary.entities.EntityCondensedSplashWeakness;
import xreliquary.entities.EntityCondensedSplashWither;
import xreliquary.event.ClientEventHandler;

@ContentInit
public class ItemCondensedPotion
extends ItemBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBaseOverlay;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSplash;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSplashOverlay;

    public ItemCondensedPotion() {
        super("condensed_potion");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.canRepair = false;
    }

    public boolean hasContainerItem(ItemStack ist) {
        return false;
    }

    public int emptyVialMeta() {
        return 11;
    }

    public int waterVialMeta() {
        return 29;
    }

    public int panaceaMeta() {
        return 27;
    }

    public int basePotionMeta() {
        return 12;
    }

    public int baseSplashMeta() {
        return 0;
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return this.hasPotionEffect(stack);
    }

    private boolean hasPotionEffect(ItemStack stack) {
        return !this.isEmptyVial(stack) && !this.isBaseSplash(stack) && !this.isBasePotion(stack) && !this.isJustWater(stack);
    }

    public boolean isSplash(ItemStack stack) {
        return stack.func_77960_j() > this.baseSplashMeta() && stack.func_77960_j() < this.emptyVialMeta();
    }

    public boolean isPotion(ItemStack stack) {
        return stack.func_77960_j() > this.basePotionMeta() && stack.func_77960_j() < this.waterVialMeta();
    }

    public boolean isEmptyVial(ItemStack stack) {
        return stack.func_77960_j() == this.emptyVialMeta();
    }

    public boolean isBaseSplash(ItemStack stack) {
        return stack.func_77960_j() == this.baseSplashMeta();
    }

    public boolean isBasePotion(ItemStack stack) {
        return stack.func_77960_j() == this.basePotionMeta();
    }

    public boolean isPanacea(ItemStack stack) {
        return stack.func_77960_j() == this.panaceaMeta();
    }

    public boolean isJustWater(ItemStack stack) {
        return stack.func_77960_j() == this.waterVialMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (this.func_77636_d(stack)) {
            return EnumRarity.epic;
        }
        return EnumRarity.common;
    }

    public String func_77667_c(ItemStack ist) {
        return "item.potion_" + ist.func_77960_j();
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
        par3List.add(new ItemStack(par1, 1, 6));
        par3List.add(new ItemStack(par1, 1, 7));
        par3List.add(new ItemStack(par1, 1, 8));
        par3List.add(new ItemStack(par1, 1, 9));
        par3List.add(new ItemStack(par1, 1, 10));
        par3List.add(new ItemStack(par1, 1, 11));
        par3List.add(new ItemStack(par1, 1, 12));
        par3List.add(new ItemStack(par1, 1, 13));
        par3List.add(new ItemStack(par1, 1, 14));
        par3List.add(new ItemStack(par1, 1, 15));
        par3List.add(new ItemStack(par1, 1, 16));
        par3List.add(new ItemStack(par1, 1, 17));
        par3List.add(new ItemStack(par1, 1, 18));
        par3List.add(new ItemStack(par1, 1, 19));
        par3List.add(new ItemStack(par1, 1, 20));
        par3List.add(new ItemStack(par1, 1, 21));
        par3List.add(new ItemStack(par1, 1, 22));
        par3List.add(new ItemStack(par1, 1, 23));
        par3List.add(new ItemStack(par1, 1, 24));
        par3List.add(new ItemStack(par1, 1, 25));
        par3List.add(new ItemStack(par1, 1, 26));
        par3List.add(new ItemStack(par1, 1, 27));
        par3List.add(new ItemStack(par1, 1, 28));
        par3List.add(new ItemStack(par1, 1, 29));
    }

    public ItemStack func_77654_b(ItemStack ist, World world, EntityPlayer player) {
        if (!this.isPotion(ist)) {
            return ist;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --ist.field_77994_a;
        }
        if (!world.field_72995_K) {
            for (PotionEffect effect : this.getPotionEffects(ist)) {
                if (effect == null) continue;
                player.func_70690_d(effect);
            }
            if (this.isPanacea(ist)) {
                player.func_82170_o(Potion.field_82731_v.field_76415_H);
                player.func_82170_o(Potion.field_76438_s.field_76415_H);
                player.func_82170_o(Potion.field_76436_u.field_76415_H);
                player.func_82170_o(Potion.field_76431_k.field_76415_H);
                player.func_82170_o(Potion.field_76419_f.field_76415_H);
                player.func_82170_o(Potion.field_76421_d.field_76415_H);
                player.func_82170_o(Potion.field_76440_q.field_76415_H);
                player.func_82170_o(Potion.field_76437_t.field_76415_H);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (ist.field_77994_a <= 0) {
                return new ItemStack((Item)this, 1, this.emptyVialMeta());
            }
            player.field_71071_by.func_70441_a(new ItemStack((Item)this, 1, this.emptyVialMeta()));
        }
        return ist;
    }

    private Entity getNewPotionEntity(ItemStack ist, World world, EntityPlayer player) {
        int potion = ist.func_77960_j();
        switch (potion) {
            case 1: {
                return new EntityCondensedSplashAphrodite(world, player);
            }
            case 2: {
                return new EntityCondensedSplashPoison(world, player);
            }
            case 3: {
                return new EntityCondensedSplashHarm(world, player);
            }
            case 4: {
                return new EntityCondensedSplashConfusion(world, player);
            }
            case 5: {
                return new EntityCondensedSplashSlowness(world, player);
            }
            case 6: {
                return new EntityCondensedSplashWeakness(world, player);
            }
            case 7: {
                return new EntityCondensedSplashWither(world, player);
            }
            case 8: {
                return new EntityCondensedSplashBlindness(world, player);
            }
            case 9: {
                return new EntityCondensedSplashRuin(world, player);
            }
            case 10: {
                return new EntityCondensedFertility(world, player);
            }
        }
        return null;
    }

    private PotionEffect[] getPotionEffects(ItemStack ist) {
        PotionEffect[] effects = new PotionEffect[2];
        int potion = ist.func_77960_j();
        switch (potion) {
            case 13: {
                effects[0] = new PotionEffect(Potion.field_76424_c.field_76415_H, 3600, 1);
                break;
            }
            case 14: {
                effects[0] = new PotionEffect(Potion.field_76422_e.field_76415_H, 3600, 1);
                break;
            }
            case 15: {
                effects[0] = new PotionEffect(Potion.field_76420_g.field_76415_H, 3600, 1);
                break;
            }
            case 16: {
                effects[0] = new PotionEffect(Potion.field_76432_h.field_76415_H, 0, 1);
                break;
            }
            case 17: {
                effects[0] = new PotionEffect(Potion.field_76430_j.field_76415_H, 3600, 1);
                break;
            }
            case 18: {
                effects[0] = new PotionEffect(Potion.field_76428_l.field_76415_H, 900, 1);
                break;
            }
            case 19: {
                effects[0] = new PotionEffect(Potion.field_76429_m.field_76415_H, 3600, 0);
                break;
            }
            case 20: {
                effects[0] = new PotionEffect(Potion.field_76426_n.field_76415_H, 3600, 0);
                break;
            }
            case 21: {
                effects[0] = new PotionEffect(Potion.field_76427_o.field_76415_H, 3600, 0);
                break;
            }
            case 22: {
                effects[0] = new PotionEffect(Potion.field_76441_p.field_76415_H, 3600, 0);
                break;
            }
            case 23: {
                effects[0] = new PotionEffect(Potion.field_76439_r.field_76415_H, 3600, 0);
                break;
            }
            case 24: {
                effects[0] = new PotionEffect(Potion.field_76429_m.field_76415_H, 3600, 1);
                effects[1] = new PotionEffect(Potion.field_76426_n.field_76415_H, 3600, 0);
                break;
            }
            case 25: {
                effects[0] = new PotionEffect(Potion.field_76420_g.field_76415_H, 3600, 1);
                effects[1] = new PotionEffect(Potion.field_76422_e.field_76415_H, 3600, 1);
                break;
            }
            case 26: {
                effects[0] = new PotionEffect(Potion.field_76430_j.field_76415_H, 3600, 1);
                effects[1] = new PotionEffect(Potion.field_76424_c.field_76415_H, 3600, 1);
                break;
            }
            case 27: {
                effects[0] = new PotionEffect(Potion.field_76432_h.field_76415_H, 0, 1);
                effects[1] = new PotionEffect(Potion.field_76428_l.field_76415_H, 900, 1);
                break;
            }
            case 28: {
                effects[0] = new PotionEffect(Potion.field_76439_r.field_76415_H, 3600, 0);
                effects[1] = new PotionEffect(Potion.field_76441_p.field_76415_H, 3600, 0);
            }
        }
        return effects;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconBaseOverlay = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "condensed_potion_overlay");
        this.iconSplash = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "condensed_potion_splash");
        this.iconSplashOverlay = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "condensed_potion_splash_overlay");
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        if (this.isEmptyVial(itemStack)) {
            return this.field_77791_bV;
        }
        if (this.isPanacea(itemStack) || this.isPotion(itemStack) || this.isBasePotion(itemStack) || this.isJustWater(itemStack)) {
            if (renderPass == 1) {
                return this.iconBaseOverlay;
            }
            return this.field_77791_bV;
        }
        if (renderPass == 1) {
            return this.iconSplashOverlay;
        }
        return this.iconSplash;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        if (renderPass == 1) {
            return this.getColor(itemStack);
        }
        return Integer.parseInt("FFFFFF", 16);
    }

    public int getColor(ItemStack itemStack) {
        int timeFactor = ClientEventHandler.getTime() % 256;
        if (timeFactor > 127) {
            timeFactor = 255 - timeFactor;
        }
        int potion = itemStack.func_77960_j();
        switch (potion) {
            case 13: {
                return Integer.parseInt("0022FF", 16);
            }
            case 14: {
                return Integer.parseInt("DDDD22", 16);
            }
            case 15: {
                return Integer.parseInt("440000", 16);
            }
            case 16: {
                return Integer.parseInt("EE5566", 16);
            }
            case 17: {
                return Integer.parseInt("44BB44", 16);
            }
            case 18: {
                return Integer.parseInt("DD22DD", 16);
            }
            case 19: {
                return Integer.parseInt("999999", 16);
            }
            case 20: {
                return Integer.parseInt("DD9900", 16);
            }
            case 21: {
                return Integer.parseInt("0088FF", 16);
            }
            case 22: {
                String red = Integer.toHexString(timeFactor * 2);
                String green = Integer.toHexString(timeFactor * 2);
                String blue = Integer.toHexString(timeFactor * 2);
                return Integer.parseInt(String.format("%s%s%s", red, green, blue), 16);
            }
            case 23: {
                return Integer.parseInt("000044", 16);
            }
            case 24: {
                String red = Integer.toHexString(timeFactor + 127);
                String green = Integer.toHexString(timeFactor + 127);
                String blue = Integer.toHexString(timeFactor + 127);
                return Integer.parseInt(String.format("%s%s%s", red, green, blue), 16);
            }
            case 25: {
                String red = Integer.toHexString(timeFactor + 127);
                String green = Integer.toHexString(timeFactor / 4 + 32);
                String blue = "00";
                return Integer.parseInt(String.format("%s%s%s", red, green, blue), 16);
            }
            case 26: {
                String red = "00";
                String green = Integer.toHexString(timeFactor * 2);
                String blue = "FF";
                return Integer.parseInt(String.format("%s%s%s", red, green, blue), 16);
            }
            case 27: {
                String red = Integer.toHexString(timeFactor * 2);
                String green = "00";
                String blue = "FF";
                return Integer.parseInt(String.format("%s%s%s", red, green, blue), 16);
            }
            case 28: {
                return Integer.parseInt("222266", 16);
            }
            case 1: {
                return Integer.parseInt("CC3366", 16);
            }
            case 2: {
                return Integer.parseInt("44BB44", 16);
            }
            case 3: {
                return Integer.parseInt("DD9900", 16);
            }
            case 4: {
                return Integer.parseInt("DD22DD", 16);
            }
            case 5: {
                return Integer.parseInt("0022FF", 16);
            }
            case 6: {
                return Integer.parseInt("DDDD22", 16);
            }
            case 7: {
                return Integer.parseInt("777777", 16);
            }
            case 8: {
                return Integer.parseInt("333333", 16);
            }
            case 9: {
                String red = Integer.toHexString(timeFactor * 2);
                String green = "FF";
                String blue = "00";
                return Integer.parseInt(String.format("%s%s%s", red, green, blue), 16);
            }
            case 10: {
                return Integer.parseInt("DDDDDD", 16);
            }
            case 0: 
            case 12: 
            case 29: {
                return Integer.parseInt("0055DD", 16);
            }
        }
        return Integer.parseInt("FFFFFF", 16);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack ist) {
        if (this.isPotion(ist)) {
            return EnumAction.drink;
        }
        return EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (this.isEmptyVial(ist)) {
            int var15;
            int var14;
            int var13;
            boolean var11 = this.isEmptyVial(ist);
            MovingObjectPosition mop = this.func_77621_a(world, player, var11);
            if (mop == null) {
                return ist;
            }
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147439_a(var13 = mop.field_72311_b, var14 = mop.field_72312_c, var15 = mop.field_72309_d).func_149688_o() == Material.field_151586_h) {
                if (--ist.field_77994_a <= 0) {
                    return new ItemStack((Item)this, 1, this.waterVialMeta());
                }
                if (!player.field_71071_by.func_70441_a(new ItemStack((Item)this, 1, this.waterVialMeta()))) {
                    player.func_70099_a(new ItemStack((Item)this, 1, this.waterVialMeta()), 0.1f);
                }
            }
        } else {
            if (!this.hasPotionEffect(ist)) {
                return ist;
            }
            if (this.isPotion(ist)) {
                player.func_71008_a(ist, this.func_77626_a(ist));
            } else if (this.isSplash(ist)) {
                if (world.field_72995_K) {
                    return ist;
                }
                Entity e = this.getNewPotionEntity(ist, world, player);
                if (e == null) {
                    return ist;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --ist.field_77994_a;
                }
                world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                world.func_72838_d(e);
            }
        }
        return ist;
    }
}

