/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.Weapon;
import tconstruct.tools.TinkerTools;

public class Scythe
extends Weapon {
    static Material[] materials = new Material[]{Material.field_151569_G, Material.field_151570_A, Material.field_151585_k, Material.field_151584_j, Material.field_151582_l, Material.field_151572_C};

    public Scythe() {
        super(4);
        this.func_77655_b("InfiTool.Scythe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.scytheBlade;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughRod;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_scythe_head";
            }
            case 1: {
                return "_scythe_head_broken";
            }
            case 2: {
                return "_scythe_handle";
            }
            case 3: {
                return "_scythe_binding";
            }
            case 4: {
                return "_scythe_accessory";
            }
        }
        return "";
    }

    @Override
    public float getDurabilityModifier() {
        return 3.0f;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public String getEffectSuffix() {
        return "_scythe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "scythe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 1;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public float getDamageModifier() {
        return 0.75f;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "melee", "harvest"};
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        World world = player.field_70170_p;
        Block blockB = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        boolean butter = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    float localHardness;
                    if (tags.func_74767_n("Broken")) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLivingBase)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest) continue;
                    Block localBlock = world.func_147439_a(xPos, yPos, zPos);
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                    if (localBlock == null) continue;
                    for (int iter = 0; iter < materials.length; ++iter) {
                        if (materials[iter] != localBlock.func_149688_o()) continue;
                        if (!player.field_71075_bZ.field_75098_d) {
                            INetHandler handler;
                            if (butter && localBlock instanceof IShearable && ((IShearable)localBlock).isShearable(stack, (IBlockAccess)player.field_70170_p, xPos, yPos, zPos)) {
                                ArrayList drops = ((IShearable)localBlock).onSheared(stack, (IBlockAccess)player.field_70170_p, xPos, yPos, zPos, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
                                Random rand = new Random();
                                if (!world.field_72995_K) {
                                    for (ItemStack dropStack : drops) {
                                        float f2 = 0.7f;
                                        double d = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        double d1 = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        double d2 = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        EntityItem entityitem = new EntityItem(player.field_70170_p, (double)xPos + d, (double)yPos + d1, (double)zPos + d2, dropStack);
                                        entityitem.field_145804_b = 10;
                                        player.field_70170_p.func_72838_d((Entity)entityitem);
                                    }
                                }
                                if (localHardness > 0.0f) {
                                    this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                                }
                                player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)localBlock)], 1);
                                world.func_147468_f(xPos, yPos, zPos);
                                continue;
                            }
                            int exp = localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune);
                            localBlock.func_149681_a(world, xPos, yPos, zPos, localMeta, player);
                            if (localBlock.removedByPlayer(world, player, xPos, yPos, zPos, true)) {
                                localBlock.func_149664_b(world, xPos, yPos, zPos, localMeta);
                                localBlock.func_149636_a(world, player, xPos, yPos, zPos, localMeta);
                                if (!butter) {
                                    localBlock.func_149657_c(world, xPos, yPos, zPos, exp);
                                }
                            }
                            if (world.field_72995_K && (handler = FMLClientHandler.instance().getClientPlayHandler()) != null && handler instanceof NetHandlerPlayClient) {
                                NetHandlerPlayClient handlerClient = (NetHandlerPlayClient)handler;
                                handlerClient.func_147297_a((Packet)new C07PacketPlayerDigging(0, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
                                handlerClient.func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
                            }
                            if (!(localHardness > 0.0f)) continue;
                            this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                            continue;
                        }
                        world.func_147468_f(xPos, yPos, zPos);
                    }
                }
            }
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)blockB) + (meta << 12));
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)(entity.field_70165_t + 1.0), (double)(entity.field_70163_u + 1.0), (double)(entity.field_70161_v + 1.0)).func_72314_b(1.0, 1.0, 1.0);
        List list = player.field_70170_p.func_72839_b((Entity)player, box);
        for (Object o : list) {
            AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, (Entity)o, this);
        }
        return true;
    }
}

