/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.tuples;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPPosition
extends Triplet<Double, Double, Double> {
    public LPPosition(double xPos, double yPos, double zPos) {
        super(xPos, yPos, zPos);
    }

    public LPPosition(int xPos, int yPos, int zPos) {
        super(Double.valueOf(xPos), Double.valueOf(yPos), Double.valueOf(zPos));
    }

    public LPPosition(TileEntity tile) {
        super(Double.valueOf(tile.field_145851_c), Double.valueOf(tile.field_145848_d), Double.valueOf(tile.field_145849_e));
    }

    public LPPosition(CoreRoutedPipe pipe) {
        super(Double.valueOf(pipe.getX()), Double.valueOf(pipe.getY()), Double.valueOf(pipe.getZ()));
    }

    public LPPosition(IPipeInformationProvider pipe) {
        super(Double.valueOf(pipe.getX()), Double.valueOf(pipe.getY()), Double.valueOf(pipe.getZ()));
    }

    public LPPosition(CoordinatesPacket packet) {
        super(Double.valueOf(packet.getPosX()), Double.valueOf(packet.getPosY()), Double.valueOf(packet.getPosZ()));
    }

    public int getX() {
        return (int)((Double)this.getValue1()).doubleValue();
    }

    public int getY() {
        return (int)((Double)this.getValue2()).doubleValue();
    }

    public int getZ() {
        return (int)((Double)this.getValue3()).doubleValue();
    }

    public double getXD() {
        return (Double)this.getValue1();
    }

    public double getYD() {
        return (Double)this.getValue2();
    }

    public double getZD() {
        return (Double)this.getValue3();
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.getX(), this.getY(), this.getZ());
    }

    public void moveForward(ForgeDirection dir, double steps) {
        switch (dir) {
            case UP: {
                LPPosition lPPosition = this;
                lPPosition.value2 = (Double)lPPosition.value2 + steps;
                break;
            }
            case DOWN: {
                LPPosition lPPosition = this;
                lPPosition.value2 = (Double)lPPosition.value2 - steps;
                break;
            }
            case NORTH: {
                LPPosition lPPosition = this;
                lPPosition.value3 = (Double)lPPosition.value3 - steps;
                break;
            }
            case SOUTH: {
                LPPosition lPPosition = this;
                lPPosition.value3 = (Double)lPPosition.value3 + steps;
                break;
            }
            case EAST: {
                LPPosition lPPosition = this;
                lPPosition.value1 = (Double)lPPosition.value1 + steps;
                break;
            }
            case WEST: {
                LPPosition lPPosition = this;
                lPPosition.value1 = (Double)lPPosition.value1 - steps;
                break;
            }
        }
    }

    public void moveForward(ForgeDirection dir) {
        this.moveForward(dir, 1.0);
    }

    public void moveBackward(ForgeDirection dir, double steps) {
        this.moveForward(dir, -1.0 * steps);
    }

    public void moveBackward(ForgeDirection dir) {
        this.moveBackward(dir, 1.0);
    }

    @Override
    public String toString() {
        return "(" + this.getXD() + ", " + this.getYD() + ", " + this.getZD() + ")";
    }

    @Override
    public LPPosition copy() {
        return new LPPosition((Double)this.value1, (Double)this.value2, (Double)this.value3);
    }
}

