/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class SimpleStackInventory
implements IInventory,
ISaveState {
    private ItemStack[] _contents;
    private final String _name;
    private final int _stackLimit;
    private final LinkedList<ISimpleInventoryEventHandler> _listener = new LinkedList();

    public SimpleStackInventory(int size, String name, int stackLimit) {
        this._contents = new ItemStack[size];
        this._name = name;
        this._stackLimit = stackLimit;
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    public ItemStack func_70301_a(int i) {
        return this._contents[i];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this._contents[slot] == null) {
            return null;
        }
        if (this._contents[slot].field_77994_a > count) {
            ItemStack ret = this._contents[slot].func_77946_l();
            ret.field_77994_a = count;
            this._contents[slot].field_77994_a -= count;
            return ret;
        }
        ItemStack ret = this._contents[slot];
        this._contents[slot] = null;
        return ret;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._contents[i] = itemstack != null ? itemstack.func_77946_l() : null;
    }

    public String func_145825_b() {
        return this._name;
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(prefix + "items", (int)nbttagcompound.func_74732_a());
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            if (index < this._contents.length) {
                this._contents[index] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
                continue;
            }
            LogisticsPipes.log.fatal("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this._contents.length);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].field_77994_a <= 0) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            this._contents[j].func_77955_b(nbttagcompound2);
        }
        nbttagcompound.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(World worldObj, int posX, int posY, int posZ) {
        if (MainProxy.isServer(worldObj)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null) {
                    ItemStack todrop = this.func_70298_a(i, this._contents[i].func_77976_d());
                    this.dropItems(worldObj, todrop, posX, posY, posZ);
                }
            }
        }
    }

    private void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public void addListener(ISimpleInventoryEventHandler listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryEventHandler listner) {
        if (this._listener.contains(listner)) {
            this._listener.remove(listner);
        }
    }

    public ItemStack func_70304_b(int i) {
        if (this._contents[i] == null) {
            return null;
        }
        ItemStack stackToTake = this._contents[i];
        this._contents[i] = null;
        return stackToTake;
    }

    private int tryAddToSlot(int i, ItemStack stack, int realstacklimit) {
        ItemStack slot = this._contents[i];
        if (slot == null) {
            this._contents[i] = stack.func_77946_l();
            this._contents[i].field_77994_a = Math.min(this._contents[i].field_77994_a, realstacklimit);
            return this._contents[i].field_77994_a;
        }
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        ItemIdentifier slotIdent = ItemIdentifier.get(slot);
        if (slotIdent.equals(stackIdent)) {
            slot.field_77994_a += stack.field_77994_a;
            if (slot.field_77994_a > realstacklimit) {
                int ans = stack.field_77994_a - (slot.field_77994_a - realstacklimit);
                slot.field_77994_a = realstacklimit;
                return ans;
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    public int addCompressed(ItemStack stack, boolean ignoreMaxStackSize) {
        int added;
        int i;
        if (stack == null) {
            return 0;
        }
        stack = stack.func_77946_l();
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        int stacklimit = this._stackLimit;
        if (!ignoreMaxStackSize) {
            stacklimit = Math.min(stacklimit, stackIdent.getMaxStackSize());
        }
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            if (this._contents[i] == null) continue;
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.field_77994_a -= added;
        }
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.field_77994_a -= added;
        }
        this.func_70296_d();
        return stack.field_77994_a;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void clearInventorySlotContents(int i) {
        this._contents[i] = null;
    }

    public boolean func_145818_k_() {
        return true;
    }
}

