/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.LPConstants;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.IItemTextureRenderSlot;
import logisticspipes.utils.gui.IRenderSlot;
import logisticspipes.utils.gui.ISmallColorRenderSlot;
import logisticspipes.utils.gui.ISubGuiControler;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.gui.extention.GuiExtentionController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class LogisticsBaseGuiScreen
extends GuiContainer
implements ISubGuiControler {
    protected static final ResourceLocation ITEMSINK = new ResourceLocation("logisticspipes", "textures/gui/itemsink.png");
    protected static final ResourceLocation SUPPLIER = new ResourceLocation("logisticspipes", "textures/gui/supplier.png");
    protected static final ResourceLocation CHASSI1 = new ResourceLocation("logisticspipes", "textures/gui/itemsink.png");
    protected int right;
    protected int bottom;
    protected int xCenter;
    protected int yCenter;
    protected final int xCenterOffset;
    protected final int yCenterOffset;
    private SubGuiScreen subGui;
    protected List<IRenderSlot> slots = new ArrayList<IRenderSlot>();
    protected GuiExtentionController extentionController = new GuiExtentionController();
    private GuiButton selectedButton;

    public LogisticsBaseGuiScreen(int xSize, int ySize, int xCenterOffset, int yCenterOffset) {
        this(new DummyContainer(null, null), xSize, ySize, xCenterOffset, yCenterOffset);
    }

    public LogisticsBaseGuiScreen(Container container) {
        super(container);
        this.xCenterOffset = 0;
        this.yCenterOffset = 0;
    }

    public LogisticsBaseGuiScreen(Container container, int xSize, int ySize, int xCenterOffset, int yCenterOffset) {
        super(container);
        this.field_146999_f = xSize;
        this.field_147000_g = ySize;
        this.xCenterOffset = xCenterOffset;
        this.yCenterOffset = yCenterOffset;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i = this.field_146294_l / 2 - this.field_146999_f / 2 + this.xCenterOffset;
        this.field_147009_r = this.field_146295_m / 2 - this.field_147000_g / 2 + this.yCenterOffset;
        this.right = this.field_146294_l / 2 + this.field_146999_f / 2 + this.xCenterOffset;
        this.bottom = this.field_146295_m / 2 + this.field_147000_g / 2 + this.yCenterOffset;
        this.xCenter = (this.right + this.field_147003_i) / 2;
        this.yCenter = (this.bottom + this.field_147009_r) / 2;
        this.extentionController.setMaxBottom(this.bottom);
    }

    @Override
    public boolean hasSubGui() {
        return this.subGui != null;
    }

    @Override
    public SubGuiScreen getSubGui() {
        return this.subGui;
    }

    @Override
    public void setSubGui(SubGuiScreen gui) {
        if (this.subGui == null) {
            this.subGui = gui;
            this.subGui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subGui.register(this);
            this.subGui.func_73866_w_();
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        if (this.subGui != null) {
            this.subGui.func_146280_a(mc, width, height);
        }
    }

    @Override
    public void resetSubGui() {
        this.subGui = null;
    }

    public void func_146276_q_() {
        if (this.subGui == null) {
            super.func_146276_q_();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.checkButtons();
        if (this.subGui != null) {
            block9: {
                Field fY;
                Field fX;
                int y;
                int x;
                block8: {
                    x = Mouse.getX();
                    y = Mouse.getY();
                    try {
                        fX = Mouse.class.getDeclaredField("x");
                        fY = Mouse.class.getDeclaredField("y");
                        fX.setAccessible(true);
                        fY.setAccessible(true);
                        fX.set(null, 0);
                        fY.set(null, 0);
                    }
                    catch (Exception e) {
                        if (!LPConstants.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
                super.func_73863_a(0, 0, par3);
                try {
                    fX = Mouse.class.getDeclaredField("x");
                    fY = Mouse.class.getDeclaredField("y");
                    fX.setAccessible(true);
                    fY.setAccessible(true);
                    fX.set(null, x);
                    fY.set(null, y);
                }
                catch (Exception e) {
                    if (!LPConstants.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            RenderHelper.func_74518_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)101.0f);
            if (!this.subGui.hasSubGui()) {
                GL11.glDisable((int)2929);
                super.func_146276_q_();
                GL11.glEnable((int)2929);
            }
            GL11.glDisable((int)2929);
            this.subGui.func_73863_a(par1, par2, par3);
            GL11.glEnable((int)2929);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-101.0f);
            RenderHelper.func_74519_b();
        } else {
            super.func_73863_a(par1, par2, par3);
            RenderHelper.func_74518_a();
            for (IRenderSlot slot : this.slots) {
                int mouseX = par1 - this.field_147003_i;
                int mouseY = par2 - this.field_147009_r;
                int mouseXMax = mouseX - slot.getSize();
                int mouseYMax = mouseY - slot.getSize();
                if (slot.getXPos() >= mouseX || slot.getXPos() <= mouseXMax || slot.getYPos() >= mouseY || slot.getYPos() <= mouseYMax || !slot.displayToolTip() || slot.getToolTipText() == null || slot.getToolTipText().equals("")) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(slot.getToolTipText());
                BasicGuiHelper.drawToolTip(par1, par2, list, EnumChatFormatting.WHITE, false);
            }
            RenderHelper.func_74519_b();
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        this.renderExtentions();
    }

    protected void renderExtentions() {
        this.extentionController.render(this.field_147003_i, this.field_147009_r);
    }

    protected void func_146977_a(Slot slot) {
        if (this.extentionController.renderSlot(slot)) {
            super.func_146977_a(slot);
        }
    }

    protected boolean func_146981_a(Slot par1Slot, int par2, int par3) {
        if (!this.extentionController.renderSelectSlot(par1Slot)) {
            return false;
        }
        return super.func_146981_a(par1Slot, par2, par3);
    }

    protected void checkButtons() {
        for (GuiButton button : this.field_146292_n) {
            if (!this.extentionController.renderButtonControlled(button)) continue;
            button.field_146125_m = this.extentionController.renderButton(button);
        }
    }

    public GuiButton addButton(GuiButton button) {
        this.field_146292_n.add(button);
        return button;
    }

    public final void func_146274_d() {
        if (this.subGui != null) {
            this.subGui.func_146274_d();
        } else {
            this.handleMouseInputSub();
        }
    }

    public void handleMouseInputSub() {
        super.func_146274_d();
    }

    public final void func_146282_l() {
        if (this.subGui != null) {
            this.subGui.func_146282_l();
        } else {
            super.func_146282_l();
        }
    }

    public void addRenderSlot(IRenderSlot slot) {
        this.slots.add(slot);
    }

    protected void func_146979_b(int par1, int par2) {
        if (par1 < this.field_147003_i) {
            this.extentionController.mouseOver(par1, par2);
        }
        for (IRenderSlot slot : this.slots) {
            if (slot instanceof IItemTextureRenderSlot) {
                if (slot.drawSlotBackground()) {
                    BasicGuiHelper.drawSlotBackground(this.field_146297_k, slot.getXPos(), slot.getYPos());
                }
                if (!((IItemTextureRenderSlot)slot).drawSlotIcon() || ((IItemTextureRenderSlot)slot).customRender(this.field_146297_k, this.field_73735_i)) continue;
                BasicGuiHelper.renderIconAt(this.field_146297_k, slot.getXPos() + 1, slot.getYPos() + 1, this.field_73735_i, ((IItemTextureRenderSlot)slot).getTextureIcon());
                continue;
            }
            if (!(slot instanceof ISmallColorRenderSlot)) continue;
            if (slot.drawSlotBackground()) {
                BasicGuiHelper.drawSmallSlotBackground(this.field_146297_k, slot.getXPos(), slot.getYPos());
            }
            if (!((ISmallColorRenderSlot)slot).drawColor()) continue;
            LogisticsBaseGuiScreen.func_73734_a((int)(slot.getXPos() + 1), (int)(slot.getYPos() + 1), (int)(slot.getXPos() + 7), (int)(slot.getYPos() + 7), (int)((ISmallColorRenderSlot)slot).getColor());
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        for (IRenderSlot slot : this.slots) {
            int mouseX = par1 - this.field_147003_i;
            int mouseY = par2 - this.field_147009_r;
            int mouseXMax = mouseX - slot.getSize();
            int mouseYMax = mouseY - slot.getSize();
            if (slot.getXPos() >= mouseX || slot.getXPos() <= mouseXMax || slot.getYPos() >= mouseY || slot.getYPos() <= mouseYMax) continue;
            slot.mouseClicked(par3);
            return;
        }
        boolean handledButton = false;
        if (par3 == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, par1, par2)) continue;
                this.selectedButton = guibutton;
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
                handledButton = true;
                break;
            }
        }
        if (!handledButton) {
            super.func_73864_a(par1, par2, par3);
        }
        if (par3 == 0 && par1 < this.field_147003_i && !this.mouseCanPressButton(par1, par2) && !this.isOverSlot(par1, par2)) {
            this.extentionController.mouseClicked(par1, par2, par3);
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        if (this.selectedButton != null && par3 == 0) {
            this.selectedButton.func_146118_a(par1, par2);
            this.selectedButton = null;
        } else {
            super.func_146286_b(par1, par2, par3);
        }
    }

    private boolean mouseCanPressButton(int par1, int par2) {
        for (int l = 0; l < this.field_146292_n.size(); ++l) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
            if (!guibutton.func_146116_c(this.field_146297_k, par1, par2)) continue;
            return true;
        }
        return false;
    }

    private boolean isOverSlot(int par1, int par2) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.func_146981_a(slot, par1, par2)) continue;
            return true;
        }
        return false;
    }

    public void drawPoint(int x, int y, int color) {
        LogisticsBaseGuiScreen.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)color);
    }

    public void drawPoint(int x, int y, Colors color) {
        LogisticsBaseGuiScreen.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)BasicGuiHelper.ConvertEnumToColor(color));
    }

    public void drawRect(int x1, int y1, int x2, int y2, Colors color) {
        LogisticsBaseGuiScreen.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)BasicGuiHelper.ConvertEnumToColor(color));
    }

    public void drawLine(int x1, int y1, int x2, int y2, Colors color) {
        int lasty = y1;
        int dx = 0;
        while (x1 + dx < x2) {
            int plotx = x1 + dx;
            int ploty = y1 + (y2 - y1) / (x2 - x1 - 1) * dx;
            this.drawPoint(plotx, ploty, color);
            while (lasty < ploty) {
                this.drawPoint(plotx, ++lasty, color);
            }
            while (lasty > ploty) {
                this.drawPoint(plotx, --lasty, color);
            }
            ++dx;
        }
        while (lasty < y2) {
            this.drawPoint(x2, ++lasty, color);
        }
        while (lasty > y2) {
            this.drawPoint(x2, --lasty, color);
        }
    }

    public void closeGui() {
        this.func_73869_a(' ', 1);
    }

    public Minecraft getMC() {
        return this.field_146297_k;
    }

    public int getGuiID() {
        return 0;
    }

    public static enum Colors {
        White,
        Black,
        LightGrey,
        MiddleGrey,
        DarkGrey,
        Red;

    }
}

