/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import cpw.mods.fml.client.FMLClientHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class BasicGuiHelper {
    private static float zLevel;
    private static final ResourceLocation SLOT;
    private static final ResourceLocation BIGSLOT;
    private static final ResourceLocation SMALLSLOT;
    private static final ResourceLocation ITEMS;
    private static final ResourceLocation LOCK_ICON;
    private static final ResourceLocation LINES_ICON;
    private static final ResourceLocation STATS_ICON;
    private static final ResourceLocation BACKGROUND;

    public static String getCuttedString(String input, int maxLength, FontRenderer renderer) {
        if (renderer.func_78256_a(input) < maxLength) {
            return input;
        }
        input = input + "...";
        while (renderer.func_78256_a(input) > maxLength && input.length() > 0) {
            input = input.substring(0, input.length() - 4) + "...";
        }
        return input;
    }

    public static int ConvertEnumToColor(LogisticsBaseGuiScreen.Colors color) {
        switch (color) {
            case Black: {
                return -16777216;
            }
            case White: {
                return -1;
            }
            case DarkGrey: {
                return -11184811;
            }
            case MiddleGrey: {
                return -7631989;
            }
            case LightGrey: {
                return -3750202;
            }
            case Red: {
                return -65536;
            }
        }
        return 0;
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, Minecraft mc, boolean displayAmount, boolean forcenumber) {
        BasicGuiHelper.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, mc, displayAmount, forcenumber, true);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, Minecraft mc, boolean displayAmount, boolean forcenumber, boolean color) {
        BasicGuiHelper.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, mc, displayAmount, forcenumber, true, false);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, Minecraft mc, boolean displayAmount, boolean forcenumber, boolean color, boolean disableEffect) {
        GL11.glPushMatrix();
        int ppi = 0;
        int column = 0;
        int row = 0;
        FontRenderer fontRenderer = mc.field_71466_p;
        RenderItem renderItem = new RenderItem();
        RenderBlocks renderBlocks = new RenderBlocks();
        renderItem.field_77024_a = color;
        for (ItemIdentifierStack itemStack : _allItems) {
            if (itemStack == null) {
                if (++column >= columns) {
                    ++row;
                    column = 0;
                }
                ++ppi;
                continue;
            }
            ItemIdentifier item = itemStack.getItem();
            if (IItemSearch2 != null && !IItemSearch2.itemSearched(item) || ++ppi <= items * page || ppi > items * (page + 1)) continue;
            ItemStack st = itemStack.unsafeMakeNormalStack();
            int x = left + xSize * column;
            int y = top + ySize * row;
            GL11.glDisable((int)2896);
            if (st != null) {
                if (disableEffect) {
                    if (st != null && !ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)mc.field_71446_o, (ItemStack)st, (boolean)renderItem.field_77024_a, (float)renderItem.field_77023_b, (float)x, (float)y)) {
                        renderItem.func_77015_a(fontRenderer, mc.field_71446_o, st, x, y);
                    }
                } else {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)3.0);
                    renderItem.func_82406_b(fontRenderer, mc.field_71446_o, st, x, y);
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-3.0);
                }
            }
            GL11.glEnable((int)2896);
            if (displayAmount) {
                String s = st.field_77994_a == 1 && !forcenumber ? "" : (st.field_77994_a < 1000 ? st.field_77994_a + "" : (st.field_77994_a < 100000 ? st.field_77994_a / 1000 + "K" : (st.field_77994_a < 1000000 ? "0M" + st.field_77994_a / 100000 : st.field_77994_a / 1000000 + "M")));
                GL11.glDisable((int)2896);
                GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
                BasicGuiHelper.drawStringWithShadow(fontRenderer, s, x + 16 - fontRenderer.func_78256_a(s), y + 8, 0xFFFFFF);
                GL11.glTranslated((double)0.0, (double)0.0, (double)-100.0);
                GL11.glEnable((int)2896);
            }
            if (++column < columns) continue;
            ++row;
            column = 0;
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    private static int drawStringWithShadow(FontRenderer fontRenderer, String par1Str, int par2, int par3, int par4) {
        fontRenderer.func_78265_b();
        if (fontRenderer.field_78294_m) {
            par1Str = fontRenderer.func_147647_b(par1Str);
        }
        int var5 = fontRenderer.func_78258_a(par1Str, par2 + 1, par3 + 1, par4, true);
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        var5 = Math.max(var5, fontRenderer.func_78258_a(par1Str, par2, par3, par4, false));
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
        return var5;
    }

    public static void displayItemToolTip(Object[] tooltip, Gui gui, float pzLevel, int guiLeft, int guiTop) {
        BasicGuiHelper.displayItemToolTip(tooltip, pzLevel, guiLeft, guiTop, false, false);
    }

    public static void displayItemToolTip(Object[] tooltip, float pzLevel, int guiLeft, int guiTop, boolean forceminecraft, boolean forceAdd) {
        zLevel = pzLevel;
        if (tooltip != null) {
            try {
                Minecraft mc = FMLClientHandler.instance().getClient();
                ItemStack var22 = (ItemStack)tooltip[2];
                List var24 = var22.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                if (tooltip.length > 4) {
                    var24.addAll(1, (List)tooltip[4]);
                }
                if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (tooltip.length < 4 || Boolean.valueOf((Boolean)tooltip[3]).booleanValue())) {
                    var24.add(1, "\u00a77" + ((ItemStack)tooltip[2]).field_77994_a);
                }
                int var11 = (Integer)tooltip[0] - (forceAdd ? 0 : guiLeft) + 12;
                int var12 = (Integer)tooltip[1] - (forceAdd ? 0 : guiTop) - 12;
                BasicGuiHelper.drawToolTip(var11, var12, var24, var22.func_77953_t().field_77937_e, forceminecraft);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        zLevel = 0.0f;
    }

    public static void drawToolTip(int posX, int posY, List<String> msg, EnumChatFormatting rarityColor, boolean forceminecraft) {
        try {
            if (forceminecraft) {
                throw new Exception();
            }
            Class<?> LayoutManager2 = Class.forName("codechicken.nei.LayoutManager");
            Field GuiManagerField = LayoutManager2.getDeclaredField("gui");
            GuiManagerField.setAccessible(true);
            Object GuiManagerObject = GuiManagerField.get(null);
            Class<?> GuiManager = Class.forName("codechicken.nei.GuiManager");
            Method drawMultilineTip = GuiManager.getDeclaredMethod("drawMultilineTip", Integer.TYPE, Integer.TYPE, List.class, Integer.TYPE);
            drawMultilineTip.invoke(GuiManagerObject, posX, posY, msg, rarityColor);
        }
        catch (Exception e) {
            try {
                List<String> var24 = msg;
                if (var24.size() > 0) {
                    int var12;
                    int var11;
                    int var10 = 0;
                    for (var11 = 0; var11 < var24.size(); ++var11) {
                        var12 = FMLClientHandler.instance().getClient().field_71466_p.func_78256_a(var24.get(var11));
                        if (var12 <= var10) continue;
                        var10 = var12;
                    }
                    var11 = posX + 12;
                    var12 = posY - 12;
                    int var14 = 8;
                    if (var24.size() > 1) {
                        var14 += 2 + (var24.size() - 1) * 10;
                    }
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    zLevel = 300.0f;
                    int var15 = -267386864;
                    BasicGuiHelper.drawGradientRect(var11 - 3, var12 - 4, var11 + var10 + 3, var12 - 3, var15, var15);
                    BasicGuiHelper.drawGradientRect(var11 - 3, var12 + var14 + 3, var11 + var10 + 3, var12 + var14 + 4, var15, var15);
                    BasicGuiHelper.drawGradientRect(var11 - 3, var12 - 3, var11 + var10 + 3, var12 + var14 + 3, var15, var15);
                    BasicGuiHelper.drawGradientRect(var11 - 4, var12 - 3, var11 - 3, var12 + var14 + 3, var15, var15);
                    BasicGuiHelper.drawGradientRect(var11 + var10 + 3, var12 - 3, var11 + var10 + 4, var12 + var14 + 3, var15, var15);
                    int var16 = 0x505000FF;
                    int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
                    BasicGuiHelper.drawGradientRect(var11 - 3, var12 - 3 + 1, var11 - 3 + 1, var12 + var14 + 3 - 1, var16, var17);
                    BasicGuiHelper.drawGradientRect(var11 + var10 + 2, var12 - 3 + 1, var11 + var10 + 3, var12 + var14 + 3 - 1, var16, var17);
                    BasicGuiHelper.drawGradientRect(var11 - 3, var12 - 3, var11 + var10 + 3, var12 - 3 + 1, var16, var16);
                    BasicGuiHelper.drawGradientRect(var11 - 3, var12 + var14 + 2, var11 + var10 + 3, var12 + var14 + 3, var17, var17);
                    for (int var18 = 0; var18 < var24.size(); ++var18) {
                        String var19 = var24.get(var18);
                        var19 = var18 == 0 ? "\u00a7" + rarityColor.func_96298_a() + var19 : "\u00a77" + var19;
                        FMLClientHandler.instance().getClient().field_71466_p.func_78261_a(var19, var11, var12, -1);
                        if (var18 == 0) {
                            var12 += 2;
                        }
                        var12 += 10;
                    }
                    zLevel = 0.0f;
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)2896);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private static void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        zLevel = 0.0f;
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)par3, (double)par2, (double)zLevel);
        var15.func_78377_a((double)par1, (double)par2, (double)zLevel);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)par1, (double)par4, (double)zLevel);
        var15.func_78377_a((double)par3, (double)par4, (double)zLevel);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedModalRect(double par1, double par2, double par3, double par4, double par5, double par6, float zLevel) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a(par1 + 0.0, par2 + par6, (double)zLevel, (double)((float)(par3 + 0.0) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a(par1 + par5, par2 + par6, (double)zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_78374_a(par1 + par5, par2 + 0.0, (double)zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0.0) * var8));
        var9.func_78374_a(par1 + 0.0, par2 + 0.0, (double)zLevel, (double)((float)(par3 + 0.0) * var7), (double)((float)(par4 + 0.0) * var8));
        var9.func_78381_a();
    }

    public static void drawCenteredString(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5) {
        par1FontRenderer.func_78261_a(par2Str, par3 - par1FontRenderer.func_78256_a(par2Str) / 2, par4, par5);
    }

    public static void drawPlayerInventoryBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                BasicGuiHelper.drawSlotBackground(mc, xOffset + column * 18 - 1, yOffset + row * 18 - 1);
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            BasicGuiHelper.drawSlotBackground(mc, xOffset + i1 * 18 - 1, yOffset + 58 - 1);
        }
    }

    public static void drawPlayerHotbarBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int i1 = 0; i1 < 9; ++i1) {
            BasicGuiHelper.drawSlotBackground(mc, xOffset + i1 * 18 - 1, yOffset - 1);
        }
    }

    public static void drawPlayerArmorBackground(Minecraft mc, int xOffset, int yOffset) {
        for (int i1 = 0; i1 < 4; ++i1) {
            BasicGuiHelper.drawSlotBackground(mc, xOffset - 1, yOffset - 1 - i1 * 18);
        }
    }

    public static void drawSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(SLOT);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 18), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)(y + 18), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawSlotBackground(Minecraft mc, int x, int y, int color) {
        zLevel = 0.0f;
        float colorA = (float)(color >> 24 & 0xFF) / 255.0f;
        float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)colorA);
        mc.field_71446_o.func_110577_a(SLOT);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 18), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)(y + 18), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 18), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawBigSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(BIGSLOT);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 26), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 26), (double)(y + 26), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 26), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawSmallSlotBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(SMALLSLOT);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 8), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 8), (double)(y + 8), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 8), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void renderIconAt(Minecraft mc, int x, int y, float zLevel, IIcon icon) {
        if (icon == null) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(ITEMS);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        var9.func_78374_a((double)x, (double)y, (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        var9.func_78381_a();
    }

    public static void drawLockBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(LOCK_ICON);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 15), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 14), (double)(y + 15), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 14), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawLinesBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(LINES_ICON);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawStatsBackground(Minecraft mc, int x, int y) {
        zLevel = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(STATS_ICON);
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, 0.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, 1.0, 1.0);
        var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, 1.0, 0.0);
        var9.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void renderForestryBeeAt(Minecraft mc, int x, int y, float zLevel, String id) {
        GL11.glDisable((int)2896);
        mc.field_71446_o.func_110577_a(ITEMS);
        for (int i = 0; i < SimpleServiceLocator.forestryProxy.getRenderPassesForAlleleId(id); ++i) {
            IIcon icon = SimpleServiceLocator.forestryProxy.getIconIndexForAlleleId(id, i);
            if (icon == null) continue;
            int color = SimpleServiceLocator.forestryProxy.getColorForAlleleId(id, i);
            float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            Tessellator var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)x, (double)(y + 16), (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            var9.func_78374_a((double)(x + 16), (double)(y + 16), (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            var9.func_78374_a((double)(x + 16), (double)y, (double)zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            var9.func_78374_a((double)x, (double)y, (double)zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            var9.func_78381_a();
        }
        GL11.glEnable((int)2896);
    }

    public static void drawGuiBackGround(Minecraft mc, int guiLeft, int guiTop, int right, int bottom, float zLevel, boolean resetColor) {
        BasicGuiHelper.drawGuiBackGround(mc, guiLeft, guiTop, right, bottom, zLevel, resetColor, true, true, true, true);
    }

    public static void drawGuiBackGround(Minecraft mc, int guiLeft, int guiTop, int right, int bottom, float zLevel, boolean resetColor, boolean displayTop, boolean displayLeft, boolean displayBottom, boolean displayRight) {
        Tessellator var9;
        if (resetColor) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        mc.field_71446_o.func_110577_a(BACKGROUND);
        if (displayTop) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
            var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
            var9.func_78374_a((double)(right - 15), (double)guiTop, (double)zLevel, 0.66, 0.0);
            var9.func_78374_a((double)(guiLeft + 15), (double)guiTop, (double)zLevel, 0.33, 0.0);
            var9.func_78381_a();
        }
        if (displayLeft) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)guiLeft, (double)(bottom - 15), (double)zLevel, 0.0, 0.66);
            var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
            var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
            var9.func_78374_a((double)guiLeft, (double)(guiTop + 15), (double)zLevel, 0.0, 0.33);
            var9.func_78381_a();
        }
        if (displayBottom) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)(guiLeft + 15), (double)bottom, (double)zLevel, 0.33, 1.0);
            var9.func_78374_a((double)(right - 15), (double)bottom, (double)zLevel, 0.66, 1.0);
            var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
            var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
            var9.func_78381_a();
        }
        if (displayRight) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
            var9.func_78374_a((double)right, (double)(bottom - 15), (double)zLevel, 1.0, 0.66);
            var9.func_78374_a((double)right, (double)(guiTop + 15), (double)zLevel, 1.0, 0.33);
            var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
            var9.func_78381_a();
        }
        if (displayTop && displayLeft) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)guiLeft, (double)(guiTop + 15), (double)zLevel, 0.0, 0.33);
            var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
            var9.func_78374_a((double)(guiLeft + 15), (double)guiTop, (double)zLevel, 0.33, 0.0);
            var9.func_78374_a((double)guiLeft, (double)guiTop, (double)zLevel, 0.0, 0.0);
            var9.func_78381_a();
        }
        if (displayBottom && displayLeft) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)guiLeft, (double)bottom, (double)zLevel, 0.0, 1.0);
            var9.func_78374_a((double)(guiLeft + 15), (double)bottom, (double)zLevel, 0.33, 1.0);
            var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
            var9.func_78374_a((double)guiLeft, (double)(bottom - 15), (double)zLevel, 0.0, 0.66);
            var9.func_78381_a();
        }
        if (displayBottom && displayRight) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)(right - 15), (double)bottom, (double)zLevel, 0.66, 1.0);
            var9.func_78374_a((double)right, (double)bottom, (double)zLevel, 1.0, 1.0);
            var9.func_78374_a((double)right, (double)(bottom - 15), (double)zLevel, 1.0, 0.66);
            var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
            var9.func_78381_a();
        }
        if (displayTop && displayRight) {
            var9 = Tessellator.field_78398_a;
            var9.func_78382_b();
            var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
            var9.func_78374_a((double)right, (double)(guiTop + 15), (double)zLevel, 1.0, 0.33);
            var9.func_78374_a((double)right, (double)guiTop, (double)zLevel, 1.0, 0.0);
            var9.func_78374_a((double)(right - 15), (double)guiTop, (double)zLevel, 0.66, 0.0);
            var9.func_78381_a();
        }
        var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(guiLeft + 15), (double)(bottom - 15), (double)zLevel, 0.33, 0.66);
        var9.func_78374_a((double)(right - 15), (double)(bottom - 15), (double)zLevel, 0.66, 0.66);
        var9.func_78374_a((double)(right - 15), (double)(guiTop + 15), (double)zLevel, 0.66, 0.33);
        var9.func_78374_a((double)(guiLeft + 15), (double)(guiTop + 15), (double)zLevel, 0.33, 0.33);
        var9.func_78381_a();
    }

    public static void drawRect(int par0, int par1, int par2, int par3, int par4) {
        int var5;
        if (par0 < par2) {
            var5 = par0;
            par0 = par2;
            par2 = var5;
        }
        if (par1 < par3) {
            var5 = par1;
            par1 = par3;
            par3 = var5;
        }
        float var10 = (float)(par4 >> 24 & 0xFF) / 255.0f;
        float var6 = (float)(par4 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(par4 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(par4 & 0xFF) / 255.0f;
        Tessellator var9 = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var10);
        var9.func_78382_b();
        var9.func_78377_a((double)par0, (double)par3, 0.0);
        var9.func_78377_a((double)par2, (double)par3, 0.0);
        var9.func_78377_a((double)par2, (double)par1, 0.0);
        var9.func_78377_a((double)par0, (double)par1, 0.0);
        var9.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static String getStringWithSpacesFromInteger(int source) {
        String data = Integer.toString(source);
        return BasicGuiHelper.insert3rdSpace(data);
    }

    public static String getStringWithSpacesFromLong(long source) {
        String data = Long.toString(source);
        return BasicGuiHelper.insert3rdSpace(data);
    }

    private static String insert3rdSpace(String source) {
        if (source.length() < 4) {
            return source;
        }
        return BasicGuiHelper.insert3rdSpace(source.substring(0, source.length() - 3)) + " " + source.substring(source.length() - 3);
    }

    static {
        SLOT = new ResourceLocation("logisticspipes", "textures/gui/slot.png");
        BIGSLOT = new ResourceLocation("logisticspipes", "textures/gui/slot-big.png");
        SMALLSLOT = new ResourceLocation("logisticspipes", "textures/gui/slot-small.png");
        ITEMS = new ResourceLocation("textures/atlas/items.png");
        LOCK_ICON = new ResourceLocation("logisticspipes", "textures/gui/lock.png");
        LINES_ICON = new ResourceLocation("logisticspipes", "textures/gui/lines.png");
        STATS_ICON = new ResourceLocation("logisticspipes", "textures/gui/stats.png");
        BACKGROUND = new ResourceLocation("logisticspipes", "textures/gui/GuiBackground.png");
    }
}

