/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.FinalNBTTagCompound;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class FluidIdentifier {
    private static final ReadWriteLock dblock = new ReentrantReadWriteLock();
    private static final Lock rlock = dblock.readLock();
    private static final Lock wlock = dblock.writeLock();
    private static final HashMap<Integer, FluidIdentifier> _fluidIdentifierIdCache = new HashMap(256, 0.5f);
    private static final ArrayList<HashMap<FinalNBTTagCompound, FluidIdentifier>> _fluidIdentifierTagCache = new ArrayList(256);
    private static final ArrayList<FluidIdentifier> _fluidIdentifierCache = new ArrayList(256);
    public final int fluidID;
    public final String name;
    public final FinalNBTTagCompound tag;
    public final int uniqueID;
    private static boolean init = false;

    private FluidIdentifier(int fluidID, String name, FinalNBTTagCompound tag, int uniqueID) {
        this.fluidID = fluidID;
        this.name = name;
        this.tag = tag;
        this.uniqueID = uniqueID;
    }

    public static FluidIdentifier get(int fluidID, NBTTagCompound tag) {
        FinalNBTTagCompound tagwithfixedname;
        FluidIdentifier unknownFluid;
        HashMap<FinalNBTTagCompound, FluidIdentifier> fluidNBTList;
        if (tag == null) {
            FluidIdentifier unknownFluid2;
            rlock.lock();
            if (fluidID < _fluidIdentifierCache.size() && (unknownFluid2 = _fluidIdentifierCache.get(fluidID)) != null) {
                rlock.unlock();
                return unknownFluid2;
            }
            rlock.unlock();
            wlock.lock();
            if (fluidID < _fluidIdentifierCache.size() && (unknownFluid2 = _fluidIdentifierCache.get(fluidID)) != null) {
                wlock.unlock();
                return unknownFluid2;
            }
            int id = FluidIdentifier.getUnusedId();
            FluidIdentifier unknownFluid3 = new FluidIdentifier(fluidID, FluidRegistry.getFluidName((int)fluidID), null, id);
            while (_fluidIdentifierCache.size() <= fluidID) {
                _fluidIdentifierCache.add(null);
            }
            _fluidIdentifierCache.set(fluidID, unknownFluid3);
            _fluidIdentifierIdCache.put(id, unknownFluid3);
            wlock.unlock();
            return unknownFluid3;
        }
        rlock.lock();
        if (fluidID < _fluidIdentifierTagCache.size() && (fluidNBTList = _fluidIdentifierTagCache.get(fluidID)) != null && (unknownFluid = fluidNBTList.get((Object)(tagwithfixedname = new FinalNBTTagCompound(tag)))) != null) {
            rlock.unlock();
            return unknownFluid;
        }
        rlock.unlock();
        wlock.lock();
        if (fluidID < _fluidIdentifierTagCache.size() && (fluidNBTList = _fluidIdentifierTagCache.get(fluidID)) != null && (unknownFluid = fluidNBTList.get((Object)(tagwithfixedname = new FinalNBTTagCompound(tag)))) != null) {
            wlock.unlock();
            return unknownFluid;
        }
        while (_fluidIdentifierTagCache.size() <= fluidID) {
            _fluidIdentifierTagCache.add(null);
        }
        fluidNBTList = _fluidIdentifierTagCache.get(fluidID);
        if (fluidNBTList == null) {
            fluidNBTList = new HashMap(16, 0.5f);
            _fluidIdentifierTagCache.set(fluidID, fluidNBTList);
        }
        FinalNBTTagCompound finaltag = new FinalNBTTagCompound((NBTTagCompound)tag.func_74737_b());
        int id = FluidIdentifier.getUnusedId();
        FluidIdentifier unknownFluid4 = new FluidIdentifier(fluidID, FluidRegistry.getFluidName((int)fluidID), finaltag, id);
        fluidNBTList.put(finaltag, unknownFluid4);
        _fluidIdentifierIdCache.put(id, unknownFluid4);
        wlock.unlock();
        return unknownFluid4;
    }

    public static FluidIdentifier get(FluidStack stack) {
        return FluidIdentifier.get(stack.fluidID, stack.tag);
    }

    public static FluidIdentifier get(ItemIdentifier stack) {
        return FluidIdentifier.get(stack.makeStack(1));
    }

    public static FluidIdentifier get(ItemStack stack) {
        return FluidIdentifier.get(ItemIdentifierStack.getFromStack(stack));
    }

    public static FluidIdentifier get(ItemIdentifierStack stack) {
        FluidStack f = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(stack);
        if (f == null) {
            return null;
        }
        return FluidIdentifier.get(f);
    }

    private static FluidIdentifier get(Fluid fluid) {
        return FluidIdentifier.get(fluid.getID(), null);
    }

    private static int getUnusedId() {
        int id = new Random().nextInt();
        while (FluidIdentifier.isIdUsed(id)) {
            id = new Random().nextInt();
        }
        return id;
    }

    private static boolean isIdUsed(int id) {
        return _fluidIdentifierIdCache.containsKey(id);
    }

    public String getName() {
        return this.name;
    }

    public FluidStack makeFluidStack(int amount) {
        return new FluidStack(this.fluidID, amount, (NBTTagCompound)this.tag);
    }

    public int getFreeSpaceInsideTank(IFluidHandler container, ForgeDirection dir) {
        int free = 0;
        FluidTankInfo[] tanks = container.getTankInfo(dir);
        if (tanks != null && tanks.length > 0) {
            for (int i = 0; i < tanks.length; ++i) {
                free += this.getFreeSpaceInsideTank(tanks[i]);
            }
        }
        return free;
    }

    private int getFreeSpaceInsideTank(FluidTankInfo tanks) {
        if (tanks == null) {
            return 0;
        }
        FluidStack liquid = tanks.fluid;
        if (liquid == null || liquid.fluidID <= 0) {
            return tanks.capacity;
        }
        if (FluidIdentifier.get(liquid).equals(this)) {
            return tanks.capacity - liquid.amount;
        }
        return 0;
    }

    public int getFreeSpaceInsideTank(IFluidTank tank) {
        FluidStack liquid = tank.getFluid();
        if (liquid == null || liquid.fluidID <= 0) {
            return tank.getCapacity();
        }
        if (FluidIdentifier.get(liquid).equals(this)) {
            return tank.getCapacity() - liquid.amount;
        }
        return 0;
    }

    public static void initFromForge(boolean flag) {
        if (init) {
            return;
        }
        Map fluids = FluidRegistry.getRegisteredFluids();
        for (Fluid fluid : fluids.values()) {
            FluidIdentifier.get(fluid);
        }
        if (flag) {
            init = true;
        }
    }

    public String toString() {
        String t = this.tag != null ? this.tag.toString() : "null";
        return this.name + "/" + this.fluidID + ":" + t;
    }

    public FluidIdentifier next() {
        rlock.lock();
        boolean takeNext = false;
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (takeNext && i != null) {
                rlock.unlock();
                return i;
            }
            if (!this.equals(i)) continue;
            takeNext = true;
        }
        rlock.unlock();
        return null;
    }

    public FluidIdentifier prev() {
        rlock.lock();
        FluidIdentifier last = null;
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (this.equals(i)) {
                rlock.unlock();
                return last;
            }
            if (i == null) continue;
            last = i;
        }
        rlock.unlock();
        return last;
    }

    public static FluidIdentifier first() {
        rlock.lock();
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (i == null) continue;
            rlock.unlock();
            return i;
        }
        rlock.unlock();
        return null;
    }

    public static FluidIdentifier last() {
        rlock.lock();
        FluidIdentifier last = null;
        for (FluidIdentifier i : _fluidIdentifierCache) {
            if (i == null) continue;
            last = i;
        }
        rlock.unlock();
        return last;
    }

    public ItemIdentifier getItemIdentifier() {
        return SimpleServiceLocator.logisticsFluidManager.getFluidContainer(this.makeFluidStack(0)).getItem();
    }
}

