/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CraftingRequirement {
    public ItemIdentifierStack stack;
    public boolean use_od = false;
    public boolean ignore_dmg = false;
    public boolean ignore_nbt = false;
    public boolean use_category = false;

    public boolean isSameItemAndFlag(CraftingRequirement other) {
        if (!this.stack.getItem().equals(other.stack.getItem())) {
            return false;
        }
        return this.use_od == other.use_od && this.ignore_dmg == other.ignore_dmg && this.ignore_nbt == other.ignore_nbt && this.use_category == other.use_category;
    }

    public CraftingRequirement clone() {
        CraftingRequirement n = new CraftingRequirement();
        n.stack = this.stack.clone();
        n.use_od = this.use_od;
        n.ignore_dmg = this.ignore_dmg;
        n.ignore_nbt = this.ignore_nbt;
        n.use_category = this.use_category;
        return n;
    }

    public boolean isUnique() {
        return !this.use_od && !this.ignore_dmg && !this.ignore_nbt && !this.use_category;
    }

    public boolean testItem(ItemIdentifierStack other) {
        ItemStack stack_n = this.stack.makeNormalStack();
        ItemStack other_n = other.makeNormalStack();
        if (this.use_od || this.use_category) {
            String nam2;
            int id2;
            int id1 = OreDictionary.getOreID((ItemStack)stack_n);
            if (id1 == (id2 = OreDictionary.getOreID((ItemStack)other_n))) {
                return true;
            }
            String nam1 = OreDictionary.getOreName((int)id1);
            if (nam1.equals(nam2 = OreDictionary.getOreName((int)id2))) {
                return true;
            }
            if (this.use_category && (nam1 = Pattern.compile("[A-Z].*").matcher(nam1).replaceFirst("")).equals(nam2 = Pattern.compile("[A-Z].*").matcher(nam2).replaceFirst(""))) {
                return true;
            }
        }
        if (stack_n.func_77973_b() != other_n.func_77973_b()) {
            return false;
        }
        if (stack_n.func_77960_j() != other_n.func_77960_j()) {
            if (stack_n.func_77981_g()) {
                return false;
            }
            if (!this.ignore_dmg) {
                return false;
            }
        }
        if (this.ignore_nbt) {
            return true;
        }
        if (stack_n.func_77942_o() ^ other_n.func_77942_o()) {
            return false;
        }
        if (!stack_n.func_77942_o() && !other_n.func_77942_o()) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)stack_n, (ItemStack)other_n);
    }

    public ArrayList<ItemIdentifier> GetSubtitutes(IRequestItems target) {
        ArrayList<ItemIdentifier> result = new ArrayList<ItemIdentifier>();
        Map<ItemIdentifier, Integer> avail_items = SimpleServiceLocator.logisticsManager.getAvailableItems(target.getRouter().getIRoutersByCost());
        LinkedList<ItemIdentifier> craft_items = SimpleServiceLocator.logisticsManager.getCraftableItems(target.getRouter().getIRoutersByCost());
        for (Map.Entry<ItemIdentifier, Integer> entry : avail_items.entrySet()) {
            if (!this.testItem(entry.getKey().makeStack(1)) || result.contains(entry.getKey())) continue;
            result.add(entry.getKey());
        }
        for (ItemIdentifier itemIdentifier : craft_items) {
            if (!this.testItem(itemIdentifier.makeStack(1)) || result.contains(itemIdentifier)) continue;
            result.add(itemIdentifier);
        }
        return result;
    }
}

