/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import buildcraft.transport.TravelingItem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.interfaces.IBufferItems;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.ITargetSlotInformation;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.ItemBufferSyncPacket;
import logisticspipes.network.packets.pipe.PipeContentPacket;
import logisticspipes.network.packets.pipe.PipeContentRequest;
import logisticspipes.network.packets.pipe.PipePositionPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsFluidSupplier;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.LPRoutedBCTravelingItem;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.transport.LPItemList;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SyncList;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportLogistics {
    private final int _bufferTimeOut = 40;
    public final SyncList<Pair<ItemIdentifierStack, Pair<Integer, Integer>>> _itemBuffer = new SyncList();
    private Chunk chunk;
    public LPItemList items = new LPItemList(this);
    public LogisticsTileGenericPipe container;

    public void initialize() {
        if (MainProxy.isServer(this.getWorld())) {
            this.chunk = this.getWorld().func_72938_d(this.container.field_145851_c, this.container.field_145849_e);
            ItemBufferSyncPacket packet = PacketHandler.getPacket(ItemBufferSyncPacket.class);
            packet.setTilePos(this.container);
            this._itemBuffer.setPacketType(packet, MainProxy.getDimensionForWorld(this.getWorld()), this.container.field_145851_c, this.container.field_145849_e);
        }
    }

    public void markChunkModified(TileEntity tile) {
        if (tile != null && this.chunk != null && (this.container.field_145851_c >> 4 != tile.field_145851_c >> 4 || this.container.field_145849_e >> 4 != tile.field_145849_e >> 4)) {
            this.chunk.field_76643_l = true;
            if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe != null && ((LogisticsTileGenericPipe)tile).pipe.transport instanceof PipeTransportLogistics && ((LogisticsTileGenericPipe)tile).pipe.transport.chunk != null) {
                ((LogisticsTileGenericPipe)tile).pipe.transport.chunk.field_76643_l = true;
            } else {
                this.getWorld().func_72964_e((int)tile.field_145851_c, (int)tile.field_145849_e).field_76643_l = true;
            }
        }
    }

    protected CoreRoutedPipe getPipe() {
        return (CoreRoutedPipe)this.container.pipe;
    }

    public void updateEntity() {
        this.moveSolids();
        if (MainProxy.isServer(this.getWorld())) {
            if (!this._itemBuffer.isEmpty()) {
                LinkedList<LPTravelingItem.LPTravelingItemServer> toAdd = new LinkedList<LPTravelingItem.LPTravelingItemServer>();
                Iterator<Pair<ItemIdentifierStack, Pair<Integer, Integer>>> iterator = this._itemBuffer.iterator();
                while (iterator.hasNext()) {
                    Pair<ItemIdentifierStack, Pair<Integer, Integer>> next = iterator.next();
                    int n = next.getValue2().getValue1();
                    if (n > 0) {
                        next.getValue2().setValue1(n - 1);
                        continue;
                    }
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(next.getValue1());
                    item.setDoNotBuffer(true);
                    item.setBufferCounter(next.getValue2().getValue2() + 1);
                    toAdd.add(item);
                    iterator.remove();
                }
                for (LPTravelingItem lPTravelingItem : toAdd) {
                    this.injectItem(lPTravelingItem, ForgeDirection.UP);
                }
            }
            this._itemBuffer.sendUpdateToWaters();
        }
    }

    public void dropBuffer() {
        Iterator<Pair<ItemIdentifierStack, Pair<Integer, Integer>>> iterator = this._itemBuffer.iterator();
        while (iterator.hasNext()) {
            ItemIdentifierStack next = iterator.next().getValue1();
            MainProxy.dropItems(this.getWorld(), next.makeNormalStack(), this.getPipe().getX(), this.getPipe().getY(), this.getPipe().getZ());
            iterator.remove();
        }
    }

    public void injectItem(LPTravelingItem.LPTravelingItemServer item, ForgeDirection inputOrientation) {
        this.injectItem((LPTravelingItem)item, inputOrientation);
    }

    public void injectItem(LPTravelingItem item, ForgeDirection inputOrientation) {
        if (item.isCorrupted()) {
            return;
        }
        this.getPipe().triggerDebug();
        item.input = inputOrientation;
        while (item.getPosition() >= 1.0f) {
            item.setPosition(item.getPosition() - 1.0f);
        }
        if (MainProxy.isServer(this.container.func_145831_w())) {
            this.readjustSpeed((LPTravelingItem.LPTravelingItemServer)item);
            item.output = this.resolveDestination((LPTravelingItem.LPTravelingItemServer)item);
            if (item.output == null) {
                return;
            }
            this.getPipe().debug.log("Injected Item: [" + item.input + ", " + item.output + "] (" + ((LPTravelingItem.LPTravelingItemServer)item).getInfo());
        } else {
            item.output = ForgeDirection.UNKNOWN;
        }
        this.items.add(item);
        if (MainProxy.isServer(this.container.func_145831_w()) && !this.getPipe().isOpaque()) {
            this.sendItemPacket((LPTravelingItem.LPTravelingItemServer)item);
        }
    }

    public void injectItem(IRoutedItem item, ForgeDirection inputOrientation) {
        this.injectItem((LPTravelingItem)SimpleServiceLocator.routedItemHelper.getServerTravelingItem(item), inputOrientation);
    }

    protected void reverseItem(LPTravelingItem.LPTravelingItemServer item) {
        if (item.isCorrupted()) {
            return;
        }
        if (this.getPipe() instanceof IBufferItems) {
            item.getItemIdentifierStack().setStackSize(((IBufferItems)((Object)this.getPipe())).addToBuffer(item.getItemIdentifierStack(), item.getAdditionalTargetInformation()));
            if (item.getItemIdentifierStack().getStackSize() <= 0) {
                return;
            }
        }
        item.id = item.getNextId();
        if (item.getPosition() >= 1.0f) {
            item.setPosition(item.getPosition() - 1.0f);
        }
        item.input = item.output.getOpposite();
        this.readjustSpeed(item);
        item.output = this.resolveDestination(item);
        if (item.output == null) {
            return;
        }
        if (item.output == ForgeDirection.UNKNOWN) {
            this.dropItem(item);
            return;
        }
        this.items.unscheduleRemoval(item);
        if (!this.getPipe().isOpaque()) {
            this.sendItemPacket(item);
        }
    }

    public ForgeDirection resolveDestination(LPTravelingItem.LPTravelingItemServer data) {
        ForgeDirection value;
        if (data != null && data.getItemIdentifierStack() != null) {
            this.getPipe().relayedItem(data.getItemIdentifierStack().getStackSize());
        }
        ForgeDirection blocked = null;
        if (data.getDestinationUUID() == null) {
            ItemIdentifierStack stack = data.getItemIdentifierStack();
            ItemRoutingInformation result = this.getPipe().getQueuedForItemStack(stack);
            if (result != null) {
                data.setInformation(result);
                data.getInfo().setItem(stack.clone());
                blocked = data.input.getOpposite();
            }
        }
        if (this.getPipe().stillNeedReplace() || this.getPipe().initialInit()) {
            data.setDoNotBuffer(false);
            value = ForgeDirection.UNKNOWN;
        } else {
            value = this.getPipe().getRouteLayer().getOrientationForItem(data, blocked);
        }
        if (value == null && MainProxy.isClient(this.getWorld())) {
            return null;
        }
        if (value == null) {
            LogisticsPipes.log.fatal("THIS IS NOT SUPPOSED TO HAPPEN!");
            return ForgeDirection.UNKNOWN;
        }
        if (value == ForgeDirection.UNKNOWN && !data.getDoNotBuffer() && data.getBufferCounter() < 5) {
            this._itemBuffer.add(new Pair<ItemIdentifierStack, Pair<Integer, Integer>>(data.getItemIdentifierStack(), new Pair<Integer, Integer>(40, data.getBufferCounter())));
            return null;
        }
        if (value != ForgeDirection.UNKNOWN && !this.getPipe().getRouter().isRoutedExit(value) && !this.isItemExitable(data.getItemIdentifierStack())) {
            return null;
        }
        data.resetDelay();
        return value;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("travelingEntities", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            try {
                NBTTagCompound dataTag = nbttaglist.func_150305_b(j);
                LPTravelingItem.LPTravelingItemServer item = new LPTravelingItem.LPTravelingItemServer(dataTag);
                if (((LPTravelingItem)item).isCorrupted()) continue;
                this.items.scheduleLoad(item);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this._itemBuffer.clear();
        NBTTagList nbttaglist2 = nbt.func_150295_c("buffercontents", 10);
        for (int i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist2.func_150305_b(i);
            this._itemBuffer.add(new Pair<ItemIdentifierStack, Pair<Integer, Integer>>(ItemIdentifierStack.getFromStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1)), new Pair<Integer, Integer>(40, 0)));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (LPTravelingItem lPTravelingItem : this.items) {
            if (!(lPTravelingItem instanceof LPTravelingItem.LPTravelingItemServer)) continue;
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)dataTag);
            ((LPTravelingItem.LPTravelingItemServer)lPTravelingItem).writeToNBT(dataTag);
        }
        nbt.func_74782_a("travelingEntities", (NBTBase)nbttaglist);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (Pair pair : this._itemBuffer) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemIdentifierStack)pair.getValue1()).makeNormalStack().func_77955_b(nbttagcompound1);
            nbttaglist2.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("buffercontents", (NBTBase)nbttaglist2);
    }

    public void readjustSpeed(LPTravelingItem.LPTravelingItemServer item) {
        float defaultBoost = 1.0f;
        switch (item.getTransportMode()) {
            case Default: {
                defaultBoost = 20.0f;
                break;
            }
            case Passive: {
                defaultBoost = 25.0f;
                break;
            }
            case Active: {
                defaultBoost = 30.0f;
                break;
            }
            case Unknown: {
                defaultBoost = 20.0f;
                break;
            }
            default: {
                defaultBoost = 20.0f;
            }
        }
        float multiplyerSpeed = 1.0f + 0.02f * (float)this.getPipe().getUpgradeManager().getSpeedUpgradeCount();
        float multiplyerPower = 1.0f + 0.03f * (float)this.getPipe().getUpgradeManager().getSpeedUpgradeCount();
        float add = Math.max(item.getSpeed(), 0.01f * defaultBoost * multiplyerPower) - item.getSpeed();
        if (this.getPipe().useEnergy((int)((double)(add * 50.0f) + 0.5))) {
            item.setSpeed(Math.min(Math.max(item.getSpeed(), 0.01f * defaultBoost * multiplyerSpeed), 1.0f));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleTileReachedServer(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, ForgeDirection dir) {
        block25: {
            block27: {
                ForgeDirection[] dirs;
                boolean tookSome;
                block28: {
                    block24: {
                        UpgradeManager manager;
                        block26: {
                            ItemRoutingInformation info;
                            LPTravelingItem.LPTravelingItemServer routed;
                            boolean isSpecialConnectionInformationTransition;
                            block23: {
                                if (this.getPipe() instanceof PipeItemsFluidSupplier) {
                                    ((PipeItemsFluidSupplier)this.getPipe()).endReached(arrivingItem, tile);
                                    if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                                        return;
                                    }
                                }
                                this.markChunkModified(tile);
                                if (MainProxy.isServer(this.getWorld()) && arrivingItem.getInfo() != null && arrivingItem.getArrived()) {
                                    this.getPipe().notifyOfItemArival(arrivingItem.getInfo());
                                }
                                if (this.getPipe() instanceof FluidRoutedPipe && ((FluidRoutedPipe)this.getPipe()).endReached(arrivingItem, tile)) {
                                    return;
                                }
                                isSpecialConnectionInformationTransition = false;
                                if (MainProxy.isServer(this.getWorld()) && SimpleServiceLocator.specialtileconnection.needsInformationTransition(tile)) {
                                    isSpecialConnectionInformationTransition = true;
                                    SimpleServiceLocator.specialtileconnection.transmit(tile, arrivingItem);
                                }
                                if (!(tile instanceof LogisticsTileGenericPipe) && !SimpleServiceLocator.buildCraftProxy.isIPipeTile(tile)) break block23;
                                if (this.passToNextPipe(arrivingItem, tile)) {
                                    return;
                                }
                                break block24;
                            }
                            if (!(tile instanceof IInventory)) break block24;
                            if (!MainProxy.isServer(this.getWorld())) break block25;
                            if (!isSpecialConnectionInformationTransition && !this.isItemExitable(arrivingItem.getItemIdentifierStack())) {
                                return;
                            }
                            if (arrivingItem instanceof IRoutedItem && (routed = arrivingItem).getTransportMode() != IRoutedItem.TransportMode.Active && !this.getPipe().getTransportLayer().stillWantItem(routed)) {
                                this.reverseItem(arrivingItem);
                                return;
                            }
                            manager = this.getPipe().getUpgradeManager();
                            tookSome = false;
                            if (arrivingItem.getAdditionalTargetInformation() instanceof ITargetSlotInformation) {
                                IInventoryUtil util;
                                ITargetSlotInformation information = (ITargetSlotInformation)((Object)arrivingItem.getAdditionalTargetInformation());
                                IInventory inv = (IInventory)tile;
                                if (inv instanceof ISidedInventory) {
                                    inv = new SidedInventoryMinecraftAdapter((ISidedInventory)inv, ForgeDirection.UNKNOWN, false);
                                }
                                if ((util = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv)) instanceof ISpecialInsertion) {
                                    int slot = information.getTargetSlot();
                                    int amount = information.getAmount();
                                    if (util.getSizeInventory() > slot) {
                                        ItemStack content = util.getStackInSlot(slot);
                                        ItemStack toAdd = arrivingItem.getItemIdentifierStack().makeNormalStack();
                                        toAdd.field_77994_a = Math.min(toAdd.field_77994_a, Math.max(0, amount - (content != null ? content.field_77994_a : 0)));
                                        if (toAdd.field_77994_a > 0 && util.getSizeInventory() > slot) {
                                            int added = ((ISpecialInsertion)((Object)util)).addToSlot(toAdd, slot);
                                            arrivingItem.getItemIdentifierStack().lowerStackSize(added);
                                            if (added > 0) {
                                                tookSome = true;
                                            }
                                        }
                                    }
                                    if (information.isLimited()) {
                                        if (arrivingItem.getItemIdentifierStack().getStackSize() > 0) {
                                            this.reverseItem(arrivingItem);
                                        }
                                        return;
                                    }
                                }
                            }
                            if (manager.hasCombinedSneakyUpgrade()) break block26;
                            ForgeDirection insertion = arrivingItem.output.getOpposite();
                            if (manager.hasSneakyUpgrade()) {
                                insertion = manager.getSneakyOrientation();
                            }
                            ItemStack added = InventoryHelper.getTransactorFor(tile, dir.getOpposite()).add(arrivingItem.getItemIdentifierStack().makeNormalStack(), insertion, true);
                            arrivingItem.getItemIdentifierStack().lowerStackSize(added.field_77994_a);
                            if (added.field_77994_a > 0 && arrivingItem instanceof IRoutedItem) {
                                tookSome = true;
                                arrivingItem.setBufferCounter(0);
                            }
                            if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                                info = arrivingItem.getInfo();
                                info.getItem().setStackSize(added.field_77994_a);
                                this.insertedItemStack(info, tile);
                                return;
                            }
                            info = arrivingItem.getInfo().clone();
                            info.getItem().setStackSize(added.field_77994_a);
                            this.insertedItemStack(info, tile);
                            break block27;
                        }
                        dirs = manager.getCombinedSneakyOrientation();
                        break block28;
                    }
                    this.dropItem(arrivingItem);
                    return;
                }
                for (int i = 0; i < dirs.length; ++i) {
                    ForgeDirection insertion = dirs[i];
                    if (insertion == null) continue;
                    ItemStack added = InventoryHelper.getTransactorFor(tile, dir.getOpposite()).add(arrivingItem.getItemIdentifierStack().makeNormalStack(), insertion, true);
                    arrivingItem.getItemIdentifierStack().lowerStackSize(added.field_77994_a);
                    if (added.field_77994_a > 0 && arrivingItem instanceof IRoutedItem) {
                        tookSome = true;
                        arrivingItem.setBufferCounter(0);
                    }
                    if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                        ItemRoutingInformation info = arrivingItem.getInfo();
                        info.getItem().setStackSize(added.field_77994_a);
                        this.insertedItemStack(info, tile);
                        return;
                    }
                    ItemRoutingInformation info = arrivingItem.getInfo().clone();
                    info.getItem().setStackSize(added.field_77994_a);
                    this.insertedItemStack(info, tile);
                }
            }
            if (arrivingItem.getItemIdentifierStack().getStackSize() > 0) {
                this.reverseItem(arrivingItem);
            }
        }
    }

    protected void handleTileReachedClient(LPTravelingItem.LPTravelingItemClient arrivingItem, TileEntity tile) {
        if (tile instanceof LogisticsTileGenericPipe || SimpleServiceLocator.buildCraftProxy.isIPipeTile(tile)) {
            this.passToNextPipe(arrivingItem, tile);
        }
    }

    protected boolean isItemExitable(ItemIdentifierStack itemIdentifierStack) {
        if (itemIdentifierStack != null && itemIdentifierStack.makeNormalStack().func_77973_b() instanceof IItemAdvancedExistance) {
            return ((IItemAdvancedExistance)itemIdentifierStack.makeNormalStack().func_77973_b()).canExistInNormalInventory(itemIdentifierStack.makeNormalStack());
        }
        return true;
    }

    protected void insertedItemStack(ItemRoutingInformation info, TileEntity tile) {
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        ForgeDirection ori;
        if ((tile instanceof ILogisticsPowerProvider || tile instanceof ISubSystemPowerProvider) && (ori = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile)) != null && ori != ForgeDirection.UNKNOWN) {
            return !(tile instanceof LogisticsPowerJunctionTileEntity) && !(tile instanceof ISubSystemPowerProvider) || OrientationsUtil.isSide(ori);
        }
        if (SimpleServiceLocator.betterStorageProxy.isBetterStorageCrate(tile) || SimpleServiceLocator.factorizationProxy.isBarral(tile) || this.getPipe().getUpgradeManager().hasRFPowerSupplierUpgrade() && SimpleServiceLocator.cofhPowerProxy.isEnergyReceiver(tile) || this.getPipe().getUpgradeManager().getIC2PowerLevel() > 0 && SimpleServiceLocator.IC2Proxy.isEnergySink(tile)) {
            return true;
        }
        if (tile instanceof ISidedInventory) {
            int[] slots = ((ISidedInventory)tile).func_94128_d(side.getOpposite().ordinal());
            return slots != null && slots.length > 0;
        }
        return SimpleServiceLocator.pipeInformaitonManager.isPipe(tile) || tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0;
    }

    private void moveSolids() {
        this.items.flush();
        this.items.scheduleAdd();
        for (LPTravelingItem item : this.items) {
            if (item.lastTicked >= MainProxy.getGlobalTick()) continue;
            item.lastTicked = MainProxy.getGlobalTick();
            item.addAge();
            item.setPosition(item.getPosition() + item.getSpeed());
            if (!this.endReached(item)) continue;
            if (item.output == ForgeDirection.UNKNOWN) {
                if (MainProxy.isServer(this.container.func_145831_w())) {
                    this.dropItem((LPTravelingItem.LPTravelingItemServer)item);
                }
                this.items.scheduleRemoval(item);
                continue;
            }
            TileEntity tile = this.container.getTile(item.output);
            if (!this.items.scheduleRemoval(item)) continue;
            if (MainProxy.isServer(this.container.func_145831_w())) {
                this.handleTileReachedServer((LPTravelingItem.LPTravelingItemServer)item, tile, item.output);
                continue;
            }
            this.handleTileReachedClient((LPTravelingItem.LPTravelingItemClient)item, tile);
        }
        this.items.addScheduledItems();
        this.items.removeScheduledItems();
    }

    private boolean passToNextPipe(LPTravelingItem item, TileEntity tile) {
        if (tile instanceof LogisticsTileGenericPipe) {
            LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)tile;
            if (LogisticsBlockGenericPipe.isValid(pipe.pipe) && pipe.pipe.transport instanceof PipeTransportLogistics) {
                pipe.pipe.transport.injectItem(item, item.output);
                return true;
            }
        }
        return SimpleServiceLocator.buildCraftProxy.insertIntoBuildcraftPipe(tile, item);
    }

    @ModDependentMethod(modId="BuildCraft|Transport")
    public void injectItem(TravelingItem item, ForgeDirection inputOrientation) {
        if (MainProxy.isServer(this.getWorld())) {
            if (item instanceof LPRoutedBCTravelingItem) {
                ItemRoutingInformation info = ((LPRoutedBCTravelingItem)item).getRoutingInformation();
                info.setItem(ItemIdentifierStack.getFromStack(item.getItemStack()));
                LPTravelingItem.LPTravelingItemServer lpItem = new LPTravelingItem.LPTravelingItemServer(info);
                this.injectItem(lpItem, inputOrientation);
            } else {
                ItemRoutingInformation info = LPRoutedBCTravelingItem.restoreFromExtraNBTData(item);
                if (info != null) {
                    info.setItem(ItemIdentifierStack.getFromStack(item.getItemStack()));
                    LPTravelingItem.LPTravelingItemServer lpItem = new LPTravelingItem.LPTravelingItemServer(info);
                    this.injectItem(lpItem, inputOrientation);
                } else {
                    LPTravelingItem.LPTravelingItemServer lpItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(item.getItemStack());
                    lpItem.setSpeed(item.getSpeed());
                    this.injectItem(lpItem, inputOrientation);
                }
            }
        }
    }

    private void dropItem(LPTravelingItem.LPTravelingItemServer item) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        item.setSpeed(0.05f);
        item.setContainer(this.container);
        EntityItem entity = item.toEntityItem();
        if (entity != null) {
            this.container.func_145831_w().func_72838_d((Entity)entity);
        }
    }

    protected boolean endReached(LPTravelingItem item) {
        return item.getPosition() >= (item.output == ForgeDirection.UNKNOWN ? 0.75f : 1.0f);
    }

    protected void neighborChange() {
    }

    public List<ItemStack> dropContents() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (MainProxy.isServer(this.getWorld())) {
            for (LPTravelingItem item : this.items) {
                list.add(item.getItemIdentifierStack().makeNormalStack());
            }
        }
        return list;
    }

    public boolean delveIntoUnloadedChunks() {
        return true;
    }

    private void sendItemPacket(LPTravelingItem.LPTravelingItemServer item) {
        if (!LPTravelingItem.clientSideKnownIDs.get(item.getId())) {
            MainProxy.sendPacketToAllWatchingChunk(this.container.field_145851_c, this.container.field_145849_e, MainProxy.getDimensionForWorld(this.getWorld()), PacketHandler.getPacket(PipeContentPacket.class).setItem(item.getItemIdentifierStack()).setTravelId(item.getId()));
            LPTravelingItem.clientSideKnownIDs.set(item.getId());
        }
        MainProxy.sendPacketToAllWatchingChunk(this.container.field_145851_c, this.container.field_145849_e, MainProxy.getDimensionForWorld(this.getWorld()), PacketHandler.getPacket(PipePositionPacket.class).setSpeed(item.getSpeed()).setPosition(item.getPosition()).setInput(item.input).setOutput(item.output).setTravelId(item.getId()).setTilePos(this.container));
    }

    public void handleItemPositionPacket(int travelId, ForgeDirection input, ForgeDirection output, float speed, float position) {
        WeakReference<LPTravelingItem.LPTravelingItemClient> ref = LPTravelingItem.clientList.get(travelId);
        LPTravelingItem.LPTravelingItemClient item = null;
        if (ref != null) {
            item = (LPTravelingItem.LPTravelingItemClient)ref.get();
        }
        if (item == null) {
            this.sendItemContentRequest(travelId);
            item = new LPTravelingItem.LPTravelingItemClient(travelId, position, input, output);
            item.setSpeed(speed);
            LPTravelingItem.clientList.put(travelId, new WeakReference<LPTravelingItem.LPTravelingItemClient>(item));
        } else {
            if (item.getContainer() instanceof LogisticsTileGenericPipe) {
                ((LogisticsTileGenericPipe)item.getContainer()).pipe.transport.items.scheduleRemoval(item);
                ((LogisticsTileGenericPipe)item.getContainer()).pipe.transport.items.removeScheduledItems();
            }
            item.updateInformation(input, output, speed, position);
        }
        item.lastTicked = MainProxy.getGlobalTick();
        if (this.items.get(travelId) == null) {
            this.items.add(item);
        }
        this.getPipe().spawnParticle(Particles.OrangeParticle, 1);
    }

    private void sendItemContentRequest(int travelId) {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeContentRequest.class).setInteger(travelId));
    }

    public void sendItem(ItemStack stackToSend) {
        this.injectItem((LPTravelingItem)SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend), ForgeDirection.UP);
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    public void onNeighborBlockChange(int blockId) {
    }

    public void onBlockPlaced() {
    }

    public void setTile(LogisticsTileGenericPipe tile) {
        this.container = tile;
    }
}

