/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.debuggui.DebugExpandPart;
import logisticspipes.network.packets.debuggui.DebugInfoUpdate;
import logisticspipes.network.packets.debuggui.DebugPanelOpen;
import logisticspipes.network.packets.debuggui.DebugSetVarContent;
import logisticspipes.network.packets.debuggui.DebugTargetResponse;
import logisticspipes.network.packets.debuggui.DebugTypePacket;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class DebugGuiTickHandler
implements Serializable,
TreeExpansionListener,
MouseListener {
    private static final long serialVersionUID = 5889863317496153769L;
    private transient JFrame localGui;
    private transient DefaultMutableTreeNode baseNode;
    private transient JTree tree;
    private transient JScrollPane treeView;
    private transient VarType clientType;
    private transient Map<EntityPlayer, ServerGuiSetting> serverInfo = new HashMap<EntityPlayer, ServerGuiSetting>();
    private static transient DebugGuiTickHandler instance;

    public void startWatchingOf(Object object, EntityPlayer player) {
        if (object == null) {
            return;
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugPanelOpen.class).setName(object.getClass().getSimpleName()), player);
        ServerGuiSetting setting = new ServerGuiSetting();
        setting.var = this.resolveType(object, null, object.getClass().getSimpleName(), true, null);
        setting.base = object;
        this.serverInfo.put(player, setting);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugTypePacket.class).setToTransmit(setting.var), player);
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Double.class || clazz == Float.class || clazz == Long.class || clazz == UUID.class || clazz == Byte.class || clazz == String.class || clazz == ForgeDirection.class || clazz == WorldServer.class || clazz == ItemIdentifier.class || clazz == ItemIdentifierStack.class;
    }

    private VarType resolveType(Object toInstect, VarType prev, String name, boolean extended, ParentVarType parent) {
        if (toInstect == null) {
            NullVarType type = new NullVarType();
            type.name = name;
            return type;
        }
        Class<?> clazz = toInstect.getClass();
        if (clazz.isPrimitive() || this.isPrimitive(clazz)) {
            BasicVarType type = new BasicVarType();
            type.name = name;
            type.watched = toInstect.toString();
            return type;
        }
        if (clazz.isArray()) {
            ArrayVarType type = new ArrayVarType();
            type.i = 0;
            type.watched = new WeakReference<Object>(toInstect);
            type.name = name;
            type.parent = parent;
            if (prev instanceof ExtendedVarType) {
                type.i = ((ExtendedVarType)prev).i;
            }
            Object[] array = this.getArray(type.watched.get());
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                VarType tmp = null;
                if (prev instanceof ArrayVarType) {
                    tmp = ((ArrayVarType)prev).objectType.get(i);
                }
                VarType subType = this.resolveType(o, tmp, i + ": ", false, type);
                subType.i = i;
                type.objectType.put(i, subType);
            }
            return type;
        }
        ExtendedVarType type = new ExtendedVarType();
        type.i = 0;
        type.watched = new WeakReference<Object>(toInstect);
        type.name = name;
        type.extended = extended;
        type.typeName = clazz.getSimpleName();
        type.parent = parent;
        if (prev instanceof ExtendedVarType) {
            type.extended = ((ExtendedVarType)prev).extended;
            type.i = ((ExtendedVarType)prev).i;
        }
        if (type.extended) {
            int field = 0;
            int method = 0;
            while (!clazz.equals(Object.class)) {
                int i;
                try {
                    Field[] fields = clazz.getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        Field f = fields[i];
                        try {
                            FieldPart part;
                            f.setAccessible(true);
                            Object content = f.get(toInstect);
                            VarType tmp = null;
                            if (prev instanceof ExtendedVarType && (part = ((ExtendedVarType)prev).objectType.get(i)) != null) {
                                tmp = part.type;
                            }
                            VarType subType = this.resolveType(content, tmp, f.getName(), false, type);
                            FieldPart fieldPart = new FieldPart();
                            fieldPart.field = f;
                            fieldPart.name = f.getName();
                            fieldPart.type = subType;
                            subType.i = field;
                            type.objectType.put(field++, fieldPart);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                }
                try {
                    Method[] methods = clazz.getDeclaredMethods();
                    for (i = 0; i < methods.length; ++i) {
                        Method m = methods[i];
                        try {
                            m.setAccessible(true);
                            MethodPart methodPart = new MethodPart();
                            methodPart.method = m;
                            methodPart.name = m.getName();
                            methodPart.i = method;
                            ArrayList<String> params = new ArrayList<String>();
                            for (Class<?> par : m.getParameterTypes()) {
                                params.add(par.getSimpleName());
                            }
                            methodPart.param = params.toArray(new String[0]);
                            type.methodType.put(method++, methodPart);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                }
                clazz = clazz.getSuperclass();
            }
        }
        return type;
    }

    private Object[] getArray(Object val) {
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        int arrlength = Array.getLength(val);
        if (arrlength > 10000) {
            arrlength = 10000;
        }
        Object[] outputArray = new Object[arrlength];
        for (int i = 0; i < arrlength; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    private void setArray(Object val, Integer pos, Object casted) {
        if (val instanceof Object[]) {
            ((Object[])val)[pos.intValue()] = casted;
        } else {
            Array.set(val, pos, casted);
        }
    }

    public void createNewDebugGui(String ObjectClass) {
        if (this.localGui != null) {
            this.localGui.setVisible(false);
        }
        this.baseNode = new DefaultMutableTreeNode(ObjectClass);
        this.tree = new JTree(this.baseNode);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(this);
        this.treeView = new JScrollPane(this.tree);
        this.localGui = new JFrame("Object Information");
        this.localGui.getContentPane().add((Component)this.treeView, "Center");
        this.localGui.setLocationRelativeTo(null);
        this.localGui.pack();
        this.localGui.setVisible(true);
    }

    public void handleServerGuiSetting(VarType setting, Integer[] pos) {
        if (pos.length == 0 || pos.length == 1) {
            this.clientType = setting;
            for (int i = 0; i < this.baseNode.getChildCount(); ++i) {
                this.baseNode.remove(i);
            }
            this.addParts(this.baseNode, setting);
            ((DefaultTreeModel)this.tree.getModel()).reload(this.baseNode);
        } else {
            ExtendedDefaultMutableTreeNode node = this.getNodeForPathAndVarType(this.clientType, pos, setting);
            if (node == null) {
                return;
            }
            while (node.getChildCount() > 0) {
                node.remove(0);
            }
            DefaultMutableTreeNode superNode = new DefaultMutableTreeNode("Super");
            this.addParts(superNode, setting);
            while (superNode.getChildAt(0).getChildCount() > 0) {
                node.add((MutableTreeNode)superNode.getChildAt(0).getChildAt(0));
            }
            node.setUserObject(((DefaultMutableTreeNode)superNode.getChildAt(0)).getUserObject());
            if (node instanceof ExtendedDefaultMutableTreeNode) {
                node.loaded = true;
                if (superNode.getChildAt(0) instanceof ExtendedDefaultMutableTreeNode) {
                    node.type = ((ExtendedDefaultMutableTreeNode)superNode.getChildAt((int)0)).type;
                }
            }
            ((DefaultTreeModel)this.tree.getModel()).reload(node);
        }
    }

    private ExtendedDefaultMutableTreeNode getNodeForPathAndVarType(VarType var, Integer[] pos, VarType toRefresh) {
        VarType varPos = var;
        block0: for (int i = 1; i < pos.length; ++i) {
            int j;
            if (varPos instanceof ExtendedVarType) {
                ExtendedVarType eType = (ExtendedVarType)varPos;
                for (j = 0; j < eType.objectType.size(); ++j) {
                    if (!eType.objectType.get((Object)Integer.valueOf((int)j)).type.i.equals(pos[i])) continue;
                    if (i + 1 == pos.length && toRefresh != null) {
                        varPos = eType.objectType.get((Object)Integer.valueOf((int)j)).type;
                        toRefresh.node = varPos.node;
                        eType.objectType.get((Object)Integer.valueOf((int)j)).type = toRefresh;
                        continue block0;
                    }
                    varPos = eType.objectType.get((Object)Integer.valueOf((int)j)).type;
                    continue block0;
                }
                return null;
            }
            ArrayVarType aType = (ArrayVarType)varPos;
            for (j = 0; j < aType.objectType.size(); ++j) {
                if (!aType.objectType.get((Object)Integer.valueOf((int)j)).i.equals(pos[i])) continue;
                if (i + 1 == pos.length && toRefresh != null) {
                    varPos = aType.objectType.get(j);
                    toRefresh.node = varPos.node;
                    aType.objectType.put(j, toRefresh);
                    continue block0;
                }
                varPos = aType.objectType.get(j);
                continue block0;
            }
            return null;
        }
        return varPos.node;
    }

    private void addParts(DefaultMutableTreeNode node, VarType type) {
        block13: {
            try {
                if (type instanceof BasicVarType) {
                    ExtendedDefaultMutableTreeNode var;
                    type.node = var = new ExtendedDefaultMutableTreeNode(type.name + ": " + ((BasicVarType)type).watched, type);
                    node.add(var);
                    break block13;
                }
                if (type instanceof NullVarType) {
                    ExtendedDefaultMutableTreeNode var;
                    type.node = var = new ExtendedDefaultMutableTreeNode(type.name + ": null", type);
                    node.add(var);
                    break block13;
                }
                if (type instanceof ExtendedVarType) {
                    ExtendedVarType eType = (ExtendedVarType)type;
                    if (eType.extended) {
                        ExtendedDefaultMutableTreeNode extendableNode = new ExtendedDefaultMutableTreeNode(eType.name + ": (" + eType.typeName + ")", eType);
                        ExtendedDefaultMutableTreeNode fieldNode = new ExtendedDefaultMutableTreeNode("Fields:", null);
                        ExtendedDefaultMutableTreeNode methodsNode = new ExtendedDefaultMutableTreeNode("Methods:", null);
                        for (int i = 0; i < eType.objectType.size(); ++i) {
                            this.addParts(fieldNode, eType.objectType.get((Object)Integer.valueOf((int)i)).type);
                        }
                        for (Integer i : eType.methodType.keySet()) {
                            MethodPart mPart = eType.methodType.get(i);
                            StringBuilder builder = new StringBuilder();
                            for (String param : mPart.param) {
                                if (builder.length() != 0) {
                                    builder.append(", ");
                                }
                                builder.append(param);
                            }
                            MethodDefaultMutableTreeNode methodNode = new MethodDefaultMutableTreeNode(mPart.name + ": (" + builder + ")", mPart);
                            methodsNode.add(methodNode);
                        }
                        extendableNode.loaded = true;
                        extendableNode.add(fieldNode);
                        extendableNode.add(methodsNode);
                        type.node = extendableNode;
                        node.add(extendableNode);
                    } else {
                        ExtendedDefaultMutableTreeNode extendableNode = new ExtendedDefaultMutableTreeNode(eType.name + ": (" + eType.typeName + ")", eType);
                        extendableNode.add(new DefaultMutableTreeNode("Loading..."));
                        type.node = extendableNode;
                        node.add(extendableNode);
                    }
                    break block13;
                }
                if (type instanceof ArrayVarType) {
                    ArrayVarType aType = (ArrayVarType)type;
                    ExtendedDefaultMutableTreeNode extendableNode = new ExtendedDefaultMutableTreeNode(aType.name + ": ", aType);
                    for (int i = 0; i < aType.objectType.size(); ++i) {
                        this.addParts(extendableNode, aType.objectType.get(i));
                    }
                    extendableNode.loaded = true;
                    type.node = extendableNode;
                    node.add(extendableNode);
                    break block13;
                }
                throw new UnsupportedOperationException(type == null ? "null" : type.getClass().getSimpleName());
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    public void expandGuiAt(Integer[] tree, EntityPlayer player) {
        ServerGuiSetting info = this.serverInfo.get(player);
        if (info == null) {
            return;
        }
        VarType pos = info.var;
        VarType prevPos = null;
        for (int i = 1; i < tree.length; ++i) {
            prevPos = pos;
            if (pos instanceof ExtendedVarType) {
                pos = ((ExtendedVarType)pos).objectType.get((Object)tree[i]).type;
                continue;
            }
            if (pos instanceof ArrayVarType) {
                pos = ((ArrayVarType)pos).objectType.get(tree[i]);
                continue;
            }
            new Exception("List unsorted for some reason. Accessing " + pos.name + ". Closing gui. (" + Arrays.toString((Object[])tree) + ")").printStackTrace();
            return;
        }
        if (pos instanceof ExtendedVarType) {
            ((ExtendedVarType)pos).extended = true;
            pos = this.resolveType(((ExtendedVarType)pos).watched.get(), pos, ((ExtendedVarType)pos).name, true, (ParentVarType)prevPos);
            if (prevPos != null) {
                if (prevPos instanceof ExtendedVarType) {
                    ((ExtendedVarType)prevPos).objectType.get((Object)tree[tree.length - 1]).type = pos;
                } else if (prevPos instanceof ArrayVarType) {
                    ((ArrayVarType)prevPos).objectType.put(tree[tree.length - 1], pos);
                }
            } else {
                info.var = pos;
            }
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugTypePacket.class).setToTransmit(pos).setPos(tree), player);
    }

    public void closeWatchingFrom(EntityPlayer sender) {
        this.serverInfo.remove(sender);
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        Iterator<Map.Entry<EntityPlayer, ServerGuiSetting>> iterator = this.serverInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityPlayer, ServerGuiSetting> entry = iterator.next();
            EntityPlayer player = entry.getKey();
            boolean remove = false;
            if (player.field_70128_L) {
                remove = true;
            } else if (player instanceof EntityPlayerMP && !((EntityPlayerMP)player).field_71135_a.field_147371_a.func_150724_d()) {
                remove = true;
            }
            if (!remove) {
                try {
                    ServerGuiSetting setting = entry.getValue();
                    LinkedList<Integer> l = new LinkedList<Integer>();
                    l.add(0);
                    setting.var = this.handleUpdate(setting.var, player, l, setting.base, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            iterator.remove();
        }
    }

    private VarType handleUpdate(VarType type, EntityPlayer player, LinkedList<Integer> path, Object newObject, ParentVarType parent) {
        boolean isModified = false;
        if (type instanceof BasicVarType) {
            BasicVarType bType = (BasicVarType)type;
            if (bType.watched != null) {
                if (!bType.watched.equals(newObject.toString())) {
                    isModified = true;
                }
            } else if (newObject == null) {
                isModified = true;
            }
            if (isModified) {
                type = this.resolveType(newObject, type, type.name, true, parent);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugInfoUpdate.class).setPath(path.toArray(new Integer[0])).setInformation(type), player);
            }
            return bType;
        }
        if (type instanceof NullVarType) {
            if (newObject != null) {
                type = this.resolveType(newObject, type, type.name, true, parent);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugTypePacket.class).setToTransmit(type).setPos(path.toArray(new Integer[0])), player);
            }
            return type;
        }
        if (type instanceof ArrayVarType) {
            ArrayVarType aType = (ArrayVarType)type;
            if (aType.watched.get() != null) {
                if (!aType.watched.get().equals(newObject)) {
                    isModified = true;
                }
            } else if (newObject != null) {
                isModified = true;
            }
            if (!isModified) {
                for (int i = 0; i < aType.objectType.size(); ++i) {
                    path.addLast(i);
                    aType.objectType.put(i, this.handleUpdate(aType.objectType.get(i), player, path, this.getArray(aType.watched.get())[i], aType));
                    path.removeLast();
                }
            } else {
                type = this.resolveType(newObject, type, type.name, true, parent);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugTypePacket.class).setToTransmit(type).setPos(path.toArray(new Integer[0])), player);
            }
            return type;
        }
        if (type instanceof ExtendedVarType) {
            ExtendedVarType eType = (ExtendedVarType)type;
            if (eType.watched != null && eType.watched.get() != null && !eType.watched.get().equals(newObject)) {
                isModified = true;
            }
            if (newObject != null && !isModified) {
                for (int i = 0; i < eType.objectType.size(); ++i) {
                    FieldPart part = eType.objectType.get(i);
                    Object content = null;
                    try {
                        content = part.field.get(newObject);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        isModified = true;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        isModified = true;
                    }
                    path.addLast(i);
                    part.type = this.handleUpdate(part.type, player, path, content, eType);
                    path.removeLast();
                }
            } else {
                type = this.resolveType(newObject, type, type.name, true, parent);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(DebugTypePacket.class).setToTransmit(type).setPos(path.toArray(new Integer[0])), player);
            }
            return type;
        }
        System.out.println("Unknown Type");
        return null;
    }

    public void handleContentUpdatePacket(Integer[] pos, VarType setting) {
        if (pos.length == 0 || pos.length == 1) {
            for (int i = 0; i < this.baseNode.getChildCount(); ++i) {
                this.baseNode.remove(i);
            }
            this.addParts(this.baseNode, setting);
            ((DefaultTreeModel)this.tree.getModel()).reload(this.baseNode);
        } else {
            ExtendedDefaultMutableTreeNode node = this.getNodeForPathAndVarType(this.clientType, pos, null);
            if (node == null) {
                return;
            }
            if (setting instanceof BasicVarType) {
                node.setUserObject(setting.name + ": " + ((BasicVarType)setting).watched);
            } else if (setting instanceof NullVarType) {
                node.setUserObject(setting.name + ": null");
            } else {
                System.out.println("Can't directly Update this type.");
            }
            ((DefaultTreeModel)this.tree.getModel()).reload(node);
        }
    }

    public void handleVarChangePacket(Integer[] path, String content, EntityPlayer player) {
        ServerGuiSetting info = this.serverInfo.get(player);
        VarType pos = info.var;
        for (int i = 1; i < path.length - 1; ++i) {
            if (pos instanceof ExtendedVarType) {
                pos = ((ExtendedVarType)pos).objectType.get((Object)path[i]).type;
                continue;
            }
            if (pos instanceof ArrayVarType) {
                pos = ((ArrayVarType)pos).objectType.get(path[i]);
                continue;
            }
            new Exception("List unsorted for some reason. Accessing " + pos.name + ". Closing gui. (" + Arrays.toString((Object[])path) + ")").printStackTrace();
            return;
        }
        if (pos instanceof ExtendedVarType) {
            FieldPart f = ((ExtendedVarType)pos).objectType.get(path[path.length - 1]);
            try {
                f.field.set(((ExtendedVarType)pos).watched.get(), this.getCasted(f.field.getType(), content));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (pos instanceof ArrayVarType) {
            try {
                this.setArray(((ArrayVarType)pos).watched.get(), path[path.length - 1], this.getCasted(((ArrayVarType)pos).watched.get().getClass().getComponentType(), content));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object getCasted(Class<?> clazz, String content) {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.valueOf(content);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.valueOf(content);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.valueOf(content);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.valueOf(content);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(content);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.valueOf(content);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf(content.charAt(0));
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Boolean.valueOf(content);
        }
        if (clazz == UUID.class) {
            return UUID.fromString(content);
        }
        System.out.println("What type is that: " + clazz.getSimpleName() + "?");
        return content;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTargetRequest() {
        MovingObjectPosition box = FMLClientHandler.instance().getClient().field_71476_x;
        if (box == null) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(DebugTargetResponse.class).setMode(DebugTargetResponse.TargetMode.None));
        } else if (box.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(DebugTargetResponse.class).setMode(DebugTargetResponse.TargetMode.Block).setAdditions(new Object[]{box.field_72311_b, box.field_72312_c, box.field_72309_d}));
        } else if (box.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(DebugTargetResponse.class).setMode(DebugTargetResponse.TargetMode.Entity).setAdditions(new Object[]{box.field_72308_g.func_145782_y()}));
        }
    }

    public void targetResponse(DebugTargetResponse.TargetMode mode, final EntityPlayer player, Object[] additions) {
        if (mode == DebugTargetResponse.TargetMode.None) {
            player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.RED) + "No Target Found"));
        } else if (mode == DebugTargetResponse.TargetMode.Block) {
            int x = (Integer)additions[0];
            int y = (Integer)additions[1];
            int z = (Integer)additions[2];
            player.func_146105_b((IChatComponent)new ChatComponentText("Checking Block at: x:" + x + " y:" + y + " z:" + z));
            Block id = player.field_70170_p.func_147439_a(x, y, z);
            player.func_146105_b((IChatComponent)new ChatComponentText("Found Block with Id: " + id.getClass()));
            final TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
            if (tile == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.RED) + "No TileEntity found"));
            } else {
                LPChatListener.addTask(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.GREEN) + "Starting debuging of TileEntity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + tile.getClass().getSimpleName()));
                        DebugGuiTickHandler.this.startWatchingOf(tile, player);
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                        return true;
                    }
                }, (ICommandSender)player);
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Start debuging of TileEntity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + tile.getClass().getSimpleName() + (Object)((Object)ChatColor.AQUA) + "? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        } else if (mode == DebugTargetResponse.TargetMode.Entity) {
            int entityId = (Integer)additions[0];
            final Entity entitiy = player.field_70170_p.func_73045_a(entityId);
            if (entitiy == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.RED) + "No Entity found"));
            } else {
                LPChatListener.addTask(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.GREEN) + "Starting debuging of Entity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + entitiy.getClass().getSimpleName()));
                        DebugGuiTickHandler.this.startWatchingOf(entitiy, player);
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                        return true;
                    }
                }, (ICommandSender)player);
                player.func_146105_b((IChatComponent)new ChatComponentText((Object)((Object)ChatColor.AQUA) + "Start debuging of Entity: " + (Object)((Object)ChatColor.BLUE) + (Object)((Object)ChatColor.UNDERLINE) + entitiy.getClass().getSimpleName() + (Object)((Object)ChatColor.AQUA) + "? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeexpansionevent) {
        if (treeexpansionevent.getPath().getLastPathComponent() instanceof ExtendedDefaultMutableTreeNode && ((ExtendedDefaultMutableTreeNode)treeexpansionevent.getPath().getLastPathComponent()).type != null) {
            ExtendedDefaultMutableTreeNode node = (ExtendedDefaultMutableTreeNode)treeexpansionevent.getPath().getLastPathComponent();
            if (node.loaded) {
                return;
            }
            LinkedList<Integer> path = new LinkedList<Integer>();
            ParentVarType type = node.type;
            while (type != null) {
                path.addFirst(type.i);
                type = type.parent;
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(DebugExpandPart.class).setTree(path.toArray(new Integer[0])));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getButton() == 3) {
            if (this.tree.getLastSelectedPathComponent() instanceof ExtendedDefaultMutableTreeNode) {
                final ExtendedDefaultMutableTreeNode node = (ExtendedDefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                if (node.getUserObject().equals("Fields:") || node.getUserObject().equals("Methods:") || node.getChildCount() > 0 || !(node.base instanceof BasicVarType) && !(node.base instanceof NullVarType)) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                popup.setInvoker(this.tree);
                JMenuItem edit = new JMenuItem("Edit");
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String old = "null";
                        if (node.base instanceof BasicVarType) {
                            old = ((BasicVarType)node.base).watched;
                        }
                        String s = (String)JOptionPane.showInputDialog(null, "Please enter the new content for " + node.base.name + ":", "Change Variable", -1, null, null, old);
                        LinkedList<Integer> path = new LinkedList<Integer>();
                        path.add(node.base.i);
                        ParentVarType type = node.type;
                        if (type == null) {
                            type = ((ExtendedDefaultMutableTreeNode)node.getParent()).type;
                        }
                        if (type == null) {
                            type = ((ExtendedDefaultMutableTreeNode)node.getParent().getParent()).type;
                        }
                        while (type != null) {
                            path.addFirst(type.i);
                            type = type.parent;
                        }
                        MainProxy.sendPacketToServer(PacketHandler.getPacket(DebugSetVarContent.class).setPath(path.toArray(new Integer[0])).setContent(s));
                    }
                });
                popup.add(edit);
                popup.setLocation(event.getLocationOnScreen());
                popup.setVisible(true);
            }
        } else if (event.getButton() == 1 && event.getClickCount() == 2 && this.tree.getLastSelectedPathComponent() instanceof MethodDefaultMutableTreeNode) {
            MethodDefaultMutableTreeNode node = (MethodDefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            String[] args = new String[node.type.param.length];
            for (int i = 0; i < node.type.param.length; ++i) {
                Object[] proposal = null;
                if (node.type.param[i].equals("boolean")) {
                    proposal = new Object[]{true, false};
                }
                args[i] = JOptionPane.showInputDialog(null, "Please enter the argument " + i + " of type " + node.type.param[i] + ":", "Enter Paramenter", -1, null, proposal, null);
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeexpansionevent) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private DebugGuiTickHandler() {
    }

    public static DebugGuiTickHandler instance() {
        if (instance == null) {
            instance = new DebugGuiTickHandler();
        }
        return instance;
    }

    public class MethodDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 5318719768321332693L;
        public final transient MethodPart type;

        public MethodDefaultMutableTreeNode(String string, MethodPart type) {
            super(string);
            this.type = type;
        }
    }

    public class ExtendedDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 5318719768321332693L;
        public transient ParentVarType type;
        public transient VarType base;
        public boolean loaded;

        public ExtendedDefaultMutableTreeNode(String string, VarType type) {
            super(string);
            this.type = type instanceof ParentVarType ? (ParentVarType)type : null;
            this.base = type;
        }
    }

    public class MethodPart
    implements Serializable {
        private static final long serialVersionUID = -5704715096482038636L;
        String[] param;
        transient Method method;
        String name;
        Integer i;

        public String[] getParam() {
            return this.param;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getName() {
            return this.name;
        }

        public Integer getI() {
            return this.i;
        }

        public void setParam(String[] param) {
            this.param = param;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodPart)) {
                return false;
            }
            MethodPart other = (MethodPart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getParam(), other.getParam())) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$i = this.getI();
            Integer other$i = other.getI();
            return !(this$i == null ? other$i != null : !((Object)this$i).equals(other$i));
        }

        public boolean canEqual(Object other) {
            return other instanceof MethodPart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getParam());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 0 : $name.hashCode());
            Integer $i = this.getI();
            result = result * 59 + ($i == null ? 0 : ((Object)$i).hashCode());
            return result;
        }

        public String toString() {
            return "DebugGuiTickHandler.MethodPart(param=" + Arrays.deepToString(this.getParam()) + ", method=" + this.getMethod() + ", name=" + this.getName() + ", i=" + this.getI() + ")";
        }
    }

    public class FieldPart
    implements Serializable {
        private static final long serialVersionUID = 3891140976403054537L;
        VarType type;
        transient Field field;
        String name;

        public VarType getType() {
            return this.type;
        }

        public Field getField() {
            return this.field;
        }

        public String getName() {
            return this.name;
        }

        public void setType(VarType type) {
            this.type = type;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldPart)) {
                return false;
            }
            FieldPart other = (FieldPart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VarType this$type = this.getType();
            VarType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public boolean canEqual(Object other) {
            return other instanceof FieldPart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VarType $type = this.getType();
            result = result * 59 + ($type == null ? 0 : ((Object)$type).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 0 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "DebugGuiTickHandler.FieldPart(type=" + this.getType() + ", field=" + this.getField() + ", name=" + this.getName() + ")";
        }
    }

    public class ArrayVarType
    extends ParentVarType {
        private static final long serialVersionUID = -6335674162049738144L;
        Map<Integer, VarType> objectType;
        transient WeakReference<Object> watched;

        public ArrayVarType() {
            this.objectType = new HashMap<Integer, VarType>();
        }

        public Map<Integer, VarType> getObjectType() {
            return this.objectType;
        }

        public WeakReference<Object> getWatched() {
            return this.watched;
        }

        public void setObjectType(Map<Integer, VarType> objectType) {
            this.objectType = objectType;
        }

        public void setWatched(WeakReference<Object> watched) {
            this.watched = watched;
        }

        @Override
        public String toString() {
            return "DebugGuiTickHandler.ArrayVarType(objectType=" + this.getObjectType() + ", watched=" + this.getWatched() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayVarType)) {
                return false;
            }
            ArrayVarType other = (ArrayVarType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<Integer, VarType> this$objectType = this.getObjectType();
            Map<Integer, VarType> other$objectType = other.getObjectType();
            return !(this$objectType == null ? other$objectType != null : !((Object)this$objectType).equals(other$objectType));
        }

        @Override
        public boolean canEqual(Object other) {
            return other instanceof ArrayVarType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Map<Integer, VarType> $objectType = this.getObjectType();
            result = result * 59 + ($objectType == null ? 0 : ((Object)$objectType).hashCode());
            return result;
        }
    }

    public class ExtendedVarType
    extends ParentVarType {
        private static final long serialVersionUID = -5243734594523844526L;
        Map<Integer, FieldPart> objectType;
        Map<Integer, MethodPart> methodType;
        transient WeakReference<Object> watched;
        boolean extended;
        String typeName;

        public ExtendedVarType() {
            this.objectType = new HashMap<Integer, FieldPart>();
            this.methodType = new HashMap<Integer, MethodPart>();
        }

        public Map<Integer, FieldPart> getObjectType() {
            return this.objectType;
        }

        public Map<Integer, MethodPart> getMethodType() {
            return this.methodType;
        }

        public WeakReference<Object> getWatched() {
            return this.watched;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setObjectType(Map<Integer, FieldPart> objectType) {
            this.objectType = objectType;
        }

        public void setMethodType(Map<Integer, MethodPart> methodType) {
            this.methodType = methodType;
        }

        public void setWatched(WeakReference<Object> watched) {
            this.watched = watched;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public String toString() {
            return "DebugGuiTickHandler.ExtendedVarType(objectType=" + this.getObjectType() + ", methodType=" + this.getMethodType() + ", watched=" + this.getWatched() + ", extended=" + this.isExtended() + ", typeName=" + this.getTypeName() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtendedVarType)) {
                return false;
            }
            ExtendedVarType other = (ExtendedVarType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<Integer, FieldPart> this$objectType = this.getObjectType();
            Map<Integer, FieldPart> other$objectType = other.getObjectType();
            if (this$objectType == null ? other$objectType != null : !((Object)this$objectType).equals(other$objectType)) {
                return false;
            }
            Map<Integer, MethodPart> this$methodType = this.getMethodType();
            Map<Integer, MethodPart> other$methodType = other.getMethodType();
            if (this$methodType == null ? other$methodType != null : !((Object)this$methodType).equals(other$methodType)) {
                return false;
            }
            if (this.isExtended() != other.isExtended()) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
        }

        @Override
        public boolean canEqual(Object other) {
            return other instanceof ExtendedVarType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            Map<Integer, FieldPart> $objectType = this.getObjectType();
            result = result * 59 + ($objectType == null ? 0 : ((Object)$objectType).hashCode());
            Map<Integer, MethodPart> $methodType = this.getMethodType();
            result = result * 59 + ($methodType == null ? 0 : ((Object)$methodType).hashCode());
            result = result * 59 + (this.isExtended() ? 79 : 97);
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 0 : $typeName.hashCode());
            return result;
        }
    }

    public abstract class ParentVarType
    extends VarType {
        private static final long serialVersionUID = -2225627128169181250L;
        ParentVarType parent;

        public ParentVarType getParent() {
            return this.parent;
        }

        public void setParent(ParentVarType parent) {
            this.parent = parent;
        }

        @Override
        public String toString() {
            return "DebugGuiTickHandler.ParentVarType()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParentVarType)) {
                return false;
            }
            ParentVarType other = (ParentVarType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public boolean canEqual(Object other) {
            return other instanceof ParentVarType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }
    }

    public class NullVarType
    extends VarType {
        private static final long serialVersionUID = -3673576543767748173L;

        @Override
        public String toString() {
            return "DebugGuiTickHandler.NullVarType()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NullVarType)) {
                return false;
            }
            NullVarType other = (NullVarType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public boolean canEqual(Object other) {
            return other instanceof NullVarType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }
    }

    public class BasicVarType
    extends VarType {
        private static final long serialVersionUID = 4416098847612633006L;
        String watched;

        public String getWatched() {
            return this.watched;
        }

        public void setWatched(String watched) {
            this.watched = watched;
        }

        @Override
        public String toString() {
            return "DebugGuiTickHandler.BasicVarType(watched=" + this.getWatched() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BasicVarType)) {
                return false;
            }
            BasicVarType other = (BasicVarType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$watched = this.getWatched();
            String other$watched = other.getWatched();
            return !(this$watched == null ? other$watched != null : !this$watched.equals(other$watched));
        }

        @Override
        public boolean canEqual(Object other) {
            return other instanceof BasicVarType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            String $watched = this.getWatched();
            result = result * 59 + ($watched == null ? 0 : $watched.hashCode());
            return result;
        }
    }

    public abstract class VarType
    implements Serializable {
        private static final long serialVersionUID = -8013762524305750292L;
        String name;
        Integer i;
        transient ExtendedDefaultMutableTreeNode node;

        public String getName() {
            return this.name;
        }

        public Integer getI() {
            return this.i;
        }

        public ExtendedDefaultMutableTreeNode getNode() {
            return this.node;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public void setNode(ExtendedDefaultMutableTreeNode node) {
            this.node = node;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VarType)) {
                return false;
            }
            VarType other = (VarType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$i = this.getI();
            Integer other$i = other.getI();
            return !(this$i == null ? other$i != null : !((Object)this$i).equals(other$i));
        }

        public boolean canEqual(Object other) {
            return other instanceof VarType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 0 : $name.hashCode());
            Integer $i = this.getI();
            result = result * 59 + ($i == null ? 0 : ((Object)$i).hashCode());
            return result;
        }

        public String toString() {
            return "DebugGuiTickHandler.VarType(name=" + this.getName() + ", i=" + this.getI() + ", node=" + this.getNode() + ")";
        }
    }

    public class ServerGuiSetting
    implements Serializable {
        private static final long serialVersionUID = 8676326523187792057L;
        VarType var;
        public transient Object base;

        public VarType getVar() {
            return this.var;
        }

        public Object getBase() {
            return this.base;
        }

        public void setVar(VarType var) {
            this.var = var;
        }

        public void setBase(Object base) {
            this.base = base;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerGuiSetting)) {
                return false;
            }
            ServerGuiSetting other = (ServerGuiSetting)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VarType this$var = this.getVar();
            VarType other$var = other.getVar();
            return !(this$var == null ? other$var != null : !((Object)this$var).equals(other$var));
        }

        public boolean canEqual(Object other) {
            return other instanceof ServerGuiSetting;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VarType $var = this.getVar();
            result = result * 59 + ($var == null ? 0 : ((Object)$var).hashCode());
            return result;
        }

        public String toString() {
            return "DebugGuiTickHandler.ServerGuiSetting(var=" + this.getVar() + ", base=" + this.getBase() + ")";
        }
    }
}

