/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.order.DistanceTracker;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.world.World;

public class LogisticsOrderManager
implements Iterable<LogisticsOrder> {
    private LinkedList<LogisticsOrder> _orders = new LinkedList();
    private IChangeListener listener = null;

    public LogisticsOrderManager() {
    }

    public LogisticsOrderManager(IChangeListener listener) {
        this.listener = listener;
    }

    private void listen() {
        if (this.listener != null) {
            this.listener.listenedChanged();
        }
    }

    public LinkedList<ItemIdentifierStack> getContentList(World world) {
        if (MainProxy.isClient(world) || this._orders.size() == 0) {
            return new LinkedList<ItemIdentifierStack>();
        }
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (LogisticsOrder request : this._orders) {
            LogisticsOrderManager.addToList(request.getItem(), list);
        }
        return list;
    }

    private static void addToList(ItemIdentifierStack stack, LinkedList<ItemIdentifierStack> list) {
        for (ItemIdentifierStack ident : list) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        list.addLast(stack.clone());
    }

    public boolean hasOrders(IOrderInfoProvider.RequestType type) {
        return this.peekAtTopRequest(type) != null;
    }

    public LogisticsOrder peekAtTopRequest(IOrderInfoProvider.RequestType type) {
        if (this._orders.size() == 0) {
            return null;
        }
        LogisticsOrder top = this._orders.getFirst().setInProgress(true);
        int loopCount = 0;
        while (top.getType() != type) {
            if (++loopCount > this._orders.size()) {
                return null;
            }
            this.deferSend();
            top = this._orders.getFirst();
        }
        return top;
    }

    public void sendSuccessfull(int number, boolean defersend, IRoutedItem item) {
        this._orders.getFirst().getItem().setStackSize(this._orders.getFirst().getItem().getStackSize() - number);
        if (this._orders.getFirst().isWatched()) {
            DistanceTracker tracker = new DistanceTracker();
            item.setDistanceTracker(tracker);
            this._orders.getFirst().addDistanceTracker(tracker);
        }
        if (this._orders.getFirst().getItem().getStackSize() <= 0) {
            LogisticsOrder order = this._orders.removeFirst();
            order.setFinished(true);
            order.setInProgress(false);
        } else if (defersend) {
            this._orders.add(this._orders.removeFirst().setInProgress(false));
            this._orders.getFirst().setInProgress(true);
        }
        this.listen();
    }

    public void sendFailed() {
        this._orders.getFirst().getDestination().itemCouldNotBeSend(this._orders.getFirst().getItem(), this._orders.getFirst().getInformation());
        if (!this._orders.isEmpty()) {
            LogisticsOrder order = this._orders.removeFirst();
            order.setFinished(true);
            order.setInProgress(false);
        }
        if (!this._orders.isEmpty()) {
            this._orders.getFirst().setInProgress(true);
        }
        this.listen();
    }

    public void deferSend() {
        this._orders.add(this._orders.removeFirst().setInProgress(false));
        this._orders.getFirst().setInProgress(true);
        this.listen();
    }

    public LogisticsOrder addOrder(ItemIdentifierStack stack, IRequestItems requester, IOrderInfoProvider.RequestType type, IAdditionalTargetInformation info) {
        LogisticsOrder order = new LogisticsOrder(stack, requester, type, info);
        this._orders.addLast(order);
        this.listen();
        return order;
    }

    public int totalItemsCountInOrders(ItemIdentifier item) {
        int itemCount = 0;
        for (LogisticsOrder request : this._orders) {
            if (!request.getItem().getItem().equals(item)) continue;
            itemCount += request.getItem().getStackSize();
        }
        return itemCount;
    }

    public int totalItemsCountInAllOrders() {
        int itemCount = 0;
        for (LogisticsOrder request : this._orders) {
            itemCount += request.getItem().getStackSize();
        }
        return itemCount;
    }

    public void setMachineProgress(byte progress) {
        if (this._orders.isEmpty()) {
            return;
        }
        this._orders.getFirst().setMachineProgress(progress);
    }

    public boolean isFirstOrderWatched() {
        if (this._orders.isEmpty()) {
            return false;
        }
        return this._orders.getFirst().isWatched();
    }

    @Override
    public Iterator<LogisticsOrder> iterator() {
        return Collections.unmodifiableList(this._orders).iterator();
    }
}

