/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.routing.order.IDistanceTracker;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.item.ItemIdentifierStack;

public class LogisticsOrder
implements IOrderInfoProvider {
    private static final int MIN_DISTANCE_TO_DISPLAY = 4;
    private final ItemIdentifierStack item;
    private final IRequestItems destination;
    private final IAdditionalTargetInformation information;
    private boolean isFinished = false;
    private final IOrderInfoProvider.RequestType type;
    private boolean inProgress;
    private boolean isWatched = false;
    private byte machineProgress = 0;
    private List<IDistanceTracker> trackers = new ArrayList<IDistanceTracker>();

    public LogisticsOrder(ItemIdentifierStack item, IRequestItems destination, IOrderInfoProvider.RequestType type, IAdditionalTargetInformation info) {
        if (destination == null && type != IOrderInfoProvider.RequestType.EXTRA) {
            throw new NullPointerException();
        }
        this.item = item;
        this.destination = destination;
        this.type = type;
        this.information = info;
    }

    @Override
    public int getRouterId() {
        return this.destination.getRouter().getSimpleID();
    }

    @Override
    public void setWatched() {
        this.isWatched = true;
    }

    public void addDistanceTracker(IDistanceTracker tracker) {
        this.trackers.add(tracker);
    }

    @Override
    public List<Float> getProgresses() {
        ArrayList<Float> progresses = new ArrayList<Float>();
        for (IDistanceTracker tracker : this.trackers) {
            float f;
            if (tracker.hasReachedDestination() || tracker.isTimeout() || progresses.contains(Float.valueOf(f = tracker.getInitialDistanceToTarget() != 0 ? (float)tracker.getCurrentDistanceToTarget() / (float)tracker.getInitialDistanceToTarget() : 1.0f)) || tracker.getInitialDistanceToTarget() <= 4 && tracker.getInitialDistanceToTarget() != 0) continue;
            progresses.add(Float.valueOf(f));
        }
        return progresses;
    }

    @Override
    public ItemIdentifierStack getItem() {
        return this.item;
    }

    public IRequestItems getDestination() {
        return this.destination;
    }

    public IAdditionalTargetInformation getInformation() {
        return this.information;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    public LogisticsOrder setFinished(boolean isFinished) {
        this.isFinished = isFinished;
        return this;
    }

    @Override
    public IOrderInfoProvider.RequestType getType() {
        return this.type;
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    public LogisticsOrder setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
        return this;
    }

    @Override
    public boolean isWatched() {
        return this.isWatched;
    }

    @Override
    public byte getMachineProgress() {
        return this.machineProgress;
    }

    public LogisticsOrder setMachineProgress(byte machineProgress) {
        this.machineProgress = machineProgress;
        return this;
    }
}

