/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.tuples.Triplet;

public class LogisticsFluidOrderManager {
    private LinkedList<Triplet<FluidIdentifier, Integer, IRequestFluid>> queue = new LinkedList();

    public void add(FluidLogisticsPromise promise, IRequestFluid destination) {
        if (promise.amount < 0) {
            throw new RuntimeException("The amount can't be less than zero");
        }
        this.queue.addLast(new Triplet<FluidIdentifier, Integer, IRequestFluid>(promise.liquid, promise.amount, destination));
    }

    public boolean hasOrders() {
        return !this.queue.isEmpty();
    }

    public Triplet<FluidIdentifier, Integer, IRequestFluid> getFirst() {
        return this.queue.getFirst();
    }

    public void sendAmount(int amount) {
        if (!this.hasOrders()) {
            return;
        }
        int result = (Integer)this.queue.getFirst().getValue2() - amount;
        if (result <= 0) {
            this.queue.removeFirst();
        } else {
            this.queue.getFirst().setValue2((Integer)this.queue.getFirst().getValue2() - amount);
        }
    }

    public void sendFailed() {
        if (!this.hasOrders()) {
            return;
        }
        this.queue.getFirst().getValue3().sendFailed((FluidIdentifier)this.queue.getFirst().getValue1(), (Integer)this.queue.getFirst().getValue2());
        this.queue.removeFirst();
    }

    public List<Triplet<FluidIdentifier, Integer, IRequestFluid>> getAll() {
        return Collections.unmodifiableList(this.queue);
    }
}

