/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.debug;

import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.routingdebug.RoutingUpdateUntrace;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.ClientViewController;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class HUDRoutingTableGeneralInfo
extends BasicHUDGui
implements IHeadUpDisplayRenderer {
    private final ClientViewController.DebugInformation route;
    private boolean isQuestion = false;
    private boolean display = true;
    private int line;

    HUDRoutingTableGeneralInfo(ClientViewController.DebugInformation route) {
        this.route = route;
        if (route.isNew) {
            this.addUntraceButtons(route.newIndex);
        }
    }

    private void addUntraceButtons(final int index) {
        this.addButton(new BasicHUDButton("Untrack", -25, -75, 50, 10){

            @Override
            public boolean shouldRenderButton() {
                return !HUDRoutingTableGeneralInfo.this.isQuestion && HUDRoutingTableGeneralInfo.this.display;
            }

            @Override
            public void clicked() {
                HUDRoutingTableGeneralInfo.this.isQuestion = true;
            }

            @Override
            public boolean buttonEnabled() {
                return !HUDRoutingTableGeneralInfo.this.isQuestion && HUDRoutingTableGeneralInfo.this.display;
            }
        });
        this.addButton(new BasicHUDButton("Yes", -45, -75, 30, 10){

            @Override
            public boolean shouldRenderButton() {
                return HUDRoutingTableGeneralInfo.this.isQuestion && HUDRoutingTableGeneralInfo.this.display;
            }

            @Override
            public void clicked() {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RoutingUpdateUntrace.class).setInteger(index));
                HUDRoutingTableGeneralInfo.this.display = false;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDRoutingTableGeneralInfo.this.isQuestion && HUDRoutingTableGeneralInfo.this.display;
            }
        });
        this.addButton(new BasicHUDButton("No", 15, -75, 30, 10){

            @Override
            public boolean shouldRenderButton() {
                return HUDRoutingTableGeneralInfo.this.isQuestion && HUDRoutingTableGeneralInfo.this.display;
            }

            @Override
            public void clicked() {
                HUDRoutingTableGeneralInfo.this.isQuestion = false;
            }

            @Override
            public boolean buttonEnabled() {
                return HUDRoutingTableGeneralInfo.this.isQuestion && HUDRoutingTableGeneralInfo.this.display;
            }
        });
    }

    @Override
    public void renderHeadUpDisplay(double distance, boolean day, Minecraft mc, IHUDConfig config) {
        this.line = this.route.isNew ? -65 : -75;
        GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
        BasicGuiHelper.drawGuiBackGround(mc, -70, -80, 70, 80, 0.0f, false);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-4f);
        super.renderHeadUpDisplay(distance, day, mc, config);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-4f);
        this.write("Routing Update in: ", mc);
        this.write(this.route.positions.toString(), mc);
        if (this.route.closedSet != null) {
            int left = -55;
            for (PipeRoutingConnectionType flag : PipeRoutingConnectionType.values) {
                if (this.route.closedSet.contains((Object)flag)) {
                    mc.field_71466_p.func_78276_b("+", left, this.line, this.getColorForFlag(flag));
                    left += mc.field_71466_p.func_78256_a("+");
                    continue;
                }
                mc.field_71466_p.func_78276_b("-", left, this.line, this.getColorForFlag(flag));
                left += mc.field_71466_p.func_78256_a("-");
            }
            this.line += 10;
        }
        if (this.route.routes != null) {
            for (ExitRoute exit : this.route.routes) {
                mc.field_71466_p.func_78276_b("Possible: ", -55, this.line, 0xFFFFFF);
                int left = -55 + mc.field_71466_p.func_78256_a("Possible: ");
                for (PipeRoutingConnectionType flag : PipeRoutingConnectionType.values) {
                    if (exit.containsFlag(flag)) {
                        mc.field_71466_p.func_78276_b("+", left, this.line, this.getColorForFlag(flag));
                        left += mc.field_71466_p.func_78256_a("+");
                        continue;
                    }
                    mc.field_71466_p.func_78276_b("-", left, this.line, this.getColorForFlag(flag));
                    left += mc.field_71466_p.func_78256_a("-");
                }
                this.line += 10;
                this.write("  " + exit.debug.filterPosition, mc);
            }
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.001f);
    }

    private int getColorForFlag(PipeRoutingConnectionType type) {
        switch (type) {
            case canRouteTo: {
                return 0xFF0000;
            }
            case canRequestFrom: {
                return 65280;
            }
            case canPowerFrom: {
                return 65535;
            }
            case canPowerSubSystemFrom: {
                return 255;
            }
        }
        return 0;
    }

    private void write(String data, Minecraft mc) {
        mc.field_71466_p.func_78276_b(data, -55, this.line, 0xFFFFFF);
        this.line += 10;
    }

    @Override
    public boolean display(IHUDConfig config) {
        return true;
    }

    @Override
    public boolean cursorOnWindow(int x, int y) {
        return -70 < x && x < 70 && -80 < y && y < 80;
    }
}

