/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.CraftingTemplate;
import logisticspipes.request.FluidRequestTreeNode;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.SubRequestGroup;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.CraftingRequirement;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;

public class RequestTreeNode {
    private final IRequestItems target;
    private final IAdditionalTargetInformation info;
    private final ItemIdentifierStack request;
    private final RequestTreeNode parentNode;
    protected final RequestTree root;
    private List<RequestTreeNode> subRequests = new ArrayList<RequestTreeNode>();
    List<FluidRequestTreeNode> liquidSubRequests = new ArrayList<FluidRequestTreeNode>();
    private List<LogisticsPromise> promises = new ArrayList<LogisticsPromise>();
    private List<LogisticsExtraPromise> extrapromises = new ArrayList<LogisticsExtraPromise>();
    private List<LogisticsExtraPromise> byproducts = new ArrayList<LogisticsExtraPromise>();
    private SortedSet<CraftingTemplate> usedCrafters = new TreeSet<CraftingTemplate>();
    private CraftingTemplate lastCrafterTried = null;
    private int promiseItemCount = 0;

    protected RequestTreeNode(ItemIdentifierStack item, IRequestItems requester, RequestTreeNode parentNode, EnumSet<RequestTree.ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        this(null, item, requester, parentNode, requestFlags, info);
    }

    private RequestTreeNode(CraftingTemplate template, ItemIdentifierStack item, IRequestItems requester, RequestTreeNode parentNode, EnumSet<RequestTree.ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        this.request = item;
        this.target = requester;
        this.info = info;
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.subRequests.add(this);
            this.root = parentNode.root;
        } else {
            this.root = (RequestTree)this;
        }
        if (template != null) {
            this.declareCrafterUsed(template);
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Provide) && this.checkProvider()) {
            return;
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Craft) && this.checkExtras()) {
            return;
        }
        if (requestFlags.contains((Object)RequestTree.ActiveRequestType.Craft) && this.checkCrafting()) {
            return;
        }
    }

    private boolean isCrafterUsed(CraftingTemplate test) {
        if (!this.usedCrafters.isEmpty() && this.usedCrafters.contains(test)) {
            return true;
        }
        if (this.parentNode == null) {
            return false;
        }
        return this.parentNode.isCrafterUsed(test);
    }

    private boolean declareCrafterUsed(CraftingTemplate test) {
        if (this.isCrafterUsed(test)) {
            return false;
        }
        this.usedCrafters.add(test);
        return true;
    }

    public int getPromiseItemCount() {
        return this.promiseItemCount;
    }

    public int getMissingItemCount() {
        return this.request.getStackSize() - this.promiseItemCount;
    }

    public void addPromise(LogisticsPromise promise) {
        if (!promise.item.equals(this.request.getItem())) {
            throw new IllegalArgumentException("wrong item");
        }
        if (this.getMissingItemCount() == 0) {
            throw new IllegalArgumentException("zero count needed, promises not needed.");
        }
        if (promise.numberOfItems > this.getMissingItemCount()) {
            int more = promise.numberOfItems - this.getMissingItemCount();
            promise.numberOfItems = this.getMissingItemCount();
            LogisticsExtraPromise extra = new LogisticsExtraPromise(promise.item, more, promise.sender, false);
            this.extrapromises.add(extra);
        }
        if (promise.numberOfItems <= 0) {
            throw new IllegalArgumentException("zero count ... again");
        }
        this.promises.add(promise);
        this.promiseItemCount += promise.numberOfItems;
        this.root.promiseAdded(promise);
    }

    public boolean isDone() {
        return this.getMissingItemCount() <= 0;
    }

    public boolean isAllDone() {
        boolean result = this.getMissingItemCount() <= 0;
        for (RequestTreeNode node : this.subRequests) {
            result &= node.isAllDone();
        }
        return result;
    }

    public ItemIdentifier getStackItem() {
        return this.request.getItem();
    }

    protected void remove(RequestTreeNode subNode) {
        this.subRequests.remove(subNode);
        subNode.removeSubPromisses();
    }

    protected void remove(FluidRequestTreeNode subNode) {
        this.liquidSubRequests.remove(subNode);
        subNode.removeSubPromisses();
    }

    protected void removeSubPromisses() {
        for (LogisticsPromise promise : this.promises) {
            this.root.promiseRemoved(promise);
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeSubPromisses();
        }
    }

    protected void checkForExtras(ItemIdentifier item, HashMap<IProvideItems, List<LogisticsExtraPromise>> extraMap) {
        for (LogisticsExtraPromise extra : this.extrapromises) {
            if (!extra.item.equals(item)) continue;
            List<LogisticsExtraPromise> extras = extraMap.get(extra.sender);
            if (extras == null) {
                extras = new LinkedList<LogisticsExtraPromise>();
                extraMap.put(extra.sender, extras);
            }
            extras.add(extra.copy());
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.checkForExtras(item, extraMap);
        }
    }

    protected void removeUsedExtras(ItemIdentifier item, HashMap<IProvideItems, List<LogisticsExtraPromise>> extraMap) {
        block0: for (LogisticsPromise promise : this.promises) {
            if (!promise.item.equals(item) || !(promise instanceof LogisticsExtraPromise)) continue;
            LogisticsExtraPromise epromise = (LogisticsExtraPromise)promise;
            if (epromise.provided) continue;
            int usedcount = epromise.numberOfItems;
            List<LogisticsExtraPromise> extras = extraMap.get(epromise.sender);
            if (extras == null) continue;
            Iterator<LogisticsExtraPromise> it = extras.iterator();
            while (it.hasNext()) {
                LogisticsExtraPromise extra = it.next();
                if (extra.numberOfItems >= usedcount) {
                    extra.numberOfItems -= usedcount;
                    usedcount = 0;
                    continue block0;
                }
                usedcount -= extra.numberOfItems;
                it.remove();
            }
        }
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.removeUsedExtras(item, extraMap);
        }
    }

    protected LinkedLogisticsOrderList fullFill() {
        LinkedLogisticsOrderList list = new LinkedLogisticsOrderList();
        for (RequestTreeNode requestTreeNode : this.subRequests) {
            list.getSubOrders().add(requestTreeNode.fullFill());
        }
        for (LogisticsPromise logisticsPromise : this.promises) {
            LogisticsOrder result = logisticsPromise.sender.fullFill(logisticsPromise, this.target, this.info);
            if (result == null) continue;
            list.add(result);
        }
        for (LogisticsPromise logisticsPromise : this.extrapromises) {
            if (!(logisticsPromise.sender instanceof ICraftItems)) continue;
            ((ICraftItems)logisticsPromise.sender).registerExtras(logisticsPromise);
        }
        for (LogisticsPromise logisticsPromise : this.byproducts) {
            if (!(logisticsPromise.sender instanceof ICraftItems)) continue;
            ((ICraftItems)logisticsPromise.sender).registerExtras(logisticsPromise);
        }
        for (FluidRequestTreeNode fluidRequestTreeNode : this.liquidSubRequests) {
            fluidRequestTreeNode.fullFill();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    protected void buildMissingMap(Map<ItemIdentifier, Integer> missing) {
        if (this.getMissingItemCount() != 0) {
            void var3_5;
            ItemIdentifier item = this.request.getItem();
            Integer n = missing.get(item);
            if (n == null) {
                Integer n2 = 0;
            }
            Integer n3 = var3_5.intValue() + this.getMissingItemCount();
            missing.put(item, n3);
        }
        for (RequestTreeNode requestTreeNode : this.subRequests) {
            requestTreeNode.buildMissingMap(missing);
        }
        for (FluidRequestTreeNode fluidRequestTreeNode : this.liquidSubRequests) {
            fluidRequestTreeNode.buildMissingMap(missing);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildUsedMap(Map<ItemIdentifier, Integer> used, Map<ItemIdentifier, Integer> missing) {
        ItemIdentifier item;
        int usedcount = 0;
        for (LogisticsPromise logisticsPromise : this.promises) {
            if (logisticsPromise.type != LogisticsPromise.PromiseType.PROVIDER) continue;
            usedcount += logisticsPromise.numberOfItems;
        }
        if (usedcount != 0) {
            void var5_8;
            item = this.request.getItem();
            Integer n = used.get(item);
            if (n == null) {
                Integer n2 = 0;
            }
            Integer n3 = var5_8.intValue() + usedcount;
            used.put(item, n3);
        }
        if (this.getMissingItemCount() != 0) {
            void var5_13;
            item = this.request.getItem();
            Integer n = missing.get(item);
            if (n == null) {
                Integer n4 = 0;
            }
            Integer n5 = var5_13.intValue() + this.getMissingItemCount();
            missing.put(item, n5);
        }
        for (RequestTreeNode requestTreeNode : this.subRequests) {
            requestTreeNode.buildUsedMap(used, missing);
        }
        for (FluidRequestTreeNode fluidRequestTreeNode : this.liquidSubRequests) {
            fluidRequestTreeNode.buildUsedMap(used, missing);
        }
    }

    private boolean checkProvider() {
        CoreRoutedPipe thisPipe = this.target.getRouter().getCachedPipe();
        if (thisPipe == null) {
            return false;
        }
        for (Pair<IProvideItems, List<IFilter>> provider : RequestTreeNode.getProviders(this.target.getRouter(), this.getStackItem())) {
            if (this.isDone()) break;
            if (provider.getValue1() == null || provider.getValue1().getRouter() == null || provider.getValue1().getRouter().getPipe() == null || thisPipe.sharesInventoryWith(provider.getValue1().getRouter().getPipe())) continue;
            provider.getValue1().canProvide(this, this.root.getAllPromissesFor(provider.getValue1(), this.getStackItem()), provider.getValue2());
        }
        return this.isDone();
    }

    private static List<Pair<IProvideItems, List<IFilter>>> getProviders(IRouter destination, ItemIdentifier item) {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(item);
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            List<ExitRoute> e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.isValidCache() && (e = destination.getDistanceTo(r)) != null) {
                validSources.addAll(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validSources, new RequestTree.workWeightedSorter(1.0));
        LinkedList<Pair<IProvideItems, List<IFilter>>> providers = new LinkedList<Pair<IProvideItems, List<IFilter>>>();
        for (ExitRoute r : validSources) {
            CoreRoutedPipe pipe;
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !((pipe = r.destination.getPipe()) instanceof IProvideItems)) continue;
            LinkedList<IFilter> list = new LinkedList<IFilter>();
            list.addAll(r.filters);
            providers.add(new Pair((IProvideItems)((Object)pipe), list));
        }
        return providers;
    }

    private boolean checkExtras() {
        LinkedList<LogisticsExtraPromise> map = this.root.getExtrasFor(this.getStackItem());
        for (LogisticsExtraPromise extraPromise : map) {
            if (this.isDone()) break;
            if (extraPromise.numberOfItems == 0) continue;
            boolean valid = false;
            List<ExitRoute> sources = extraPromise.sender.getRouter().getRouteTable().get(this.target.getRouter().getSimpleID());
            block1: for (ExitRoute source : sources) {
                if (source == null || !source.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
                for (ExitRoute node : this.target.getRouter().getIRoutersByCost()) {
                    if (node.destination != extraPromise.sender.getRouter() || !node.containsFlag(PipeRoutingConnectionType.canRequestFrom)) continue;
                    valid = true;
                    break block1;
                }
            }
            if (!valid) continue;
            extraPromise.numberOfItems = Math.min(extraPromise.numberOfItems, this.getMissingItemCount());
            this.addPromise(extraPromise);
        }
        return this.isDone();
    }

    private boolean checkCrafting() {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(this.getStackItem());
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            List<ExitRoute> e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.isValidCache() && (e = this.target.getRouter().getDistanceTo(r)) != null) {
                validSources.addAll(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        RequestTree.workWeightedSorter wSorter = new RequestTree.workWeightedSorter(0.0);
        Collections.sort(validSources, wSorter);
        List<Pair<CraftingTemplate, List<IFilter>>> allCraftersForItem = RequestTreeNode.getCrafters(this.getStackItem(), validSources);
        Iterator<Pair<CraftingTemplate, List<IFilter>>> iterAllCrafters = allCraftersForItem.iterator();
        PriorityQueue<CraftingSorterNode> craftersSamePriority = new PriorityQueue<CraftingSorterNode>(5);
        ArrayList craftersToBalance = new ArrayList();
        boolean done = false;
        Pair<CraftingTemplate, List<IFilter>> lastCrafter = null;
        int currentPriority = 0;
        block1: while (!done) {
            if (iterAllCrafters.hasNext()) {
                if (lastCrafter == null) {
                    lastCrafter = iterAllCrafters.next();
                }
            } else if (lastCrafter == null) {
                done = true;
            }
            int itemsNeeded = this.getMissingItemCount();
            if (lastCrafter != null && (craftersSamePriority.isEmpty() || currentPriority == lastCrafter.getValue1().getPriority())) {
                currentPriority = lastCrafter.getValue1().getPriority();
                Pair<CraftingTemplate, List<IFilter>> crafter = lastCrafter;
                lastCrafter = null;
                CraftingTemplate template = crafter.getValue1();
                if (this.isCrafterUsed(template) || !template.canCraft(this.getStackItem())) continue;
                for (IFilter filter : crafter.getValue2()) {
                    if (filter.isBlocked() != filter.isFilteredItem(template.getResultItem().getUndamaged()) && !filter.blockCrafting()) continue;
                    continue block1;
                }
                CraftingSorterNode cn = new CraftingSorterNode(crafter, itemsNeeded, this.root, this);
                craftersSamePriority.add(cn);
                continue;
            }
            if (craftersToBalance.isEmpty() && (craftersSamePriority == null || craftersSamePriority.isEmpty())) continue;
            if (craftersSamePriority.size() == 1) {
                craftersToBalance.add(craftersSamePriority.poll());
                ((CraftingSorterNode)craftersToBalance.get(0)).addToWorkRequest(itemsNeeded);
            } else {
                if (!craftersSamePriority.isEmpty()) {
                    craftersToBalance.add(craftersSamePriority.poll());
                }
                while (!craftersToBalance.isEmpty() && itemsNeeded > 0) {
                    while (!craftersSamePriority.isEmpty() && ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() <= ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo()) {
                        craftersToBalance.add(craftersSamePriority.poll());
                    }
                    int cap = !craftersSamePriority.isEmpty() ? ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() : Integer.MAX_VALUE;
                    int floor = ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo();
                    cap = Math.min(cap, floor + (itemsNeeded + craftersToBalance.size() - 1) / craftersToBalance.size());
                    for (CraftingSorterNode crafter : craftersToBalance) {
                        int request = Math.min(itemsNeeded, cap - floor);
                        if (request <= 0) continue;
                        int craftingDone = crafter.addToWorkRequest(request);
                        itemsNeeded -= craftingDone;
                    }
                }
            }
            Iterator iter = craftersToBalance.iterator();
            while (iter.hasNext()) {
                CraftingSorterNode c = (CraftingSorterNode)iter.next();
                if (c.stacksOfWorkRequested <= 0 || c.addWorkPromisesToTree()) continue;
                iter.remove();
            }
            itemsNeeded = this.getMissingItemCount();
            if (itemsNeeded <= 0) break;
            if (craftersToBalance.isEmpty()) continue;
            done = false;
        }
        return this.isDone();
    }

    private static List<Pair<CraftingTemplate, List<IFilter>>> getCrafters(ItemIdentifier itemToCraft, List<ExitRoute> validDestinations) {
        ArrayList<Pair<CraftingTemplate, List<IFilter>>> crafters = new ArrayList<Pair<CraftingTemplate, List<IFilter>>>(validDestinations.size());
        for (ExitRoute r : validDestinations) {
            CraftingTemplate craftable;
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(pipe instanceof ICraftItems) || (craftable = ((ICraftItems)((Object)pipe)).addCrafting(itemToCraft)) == null) continue;
            for (IFilter filter : r.filters) {
                if (filter.isBlocked() != filter.isFilteredItem(craftable.getResultItem().getUndamaged()) && !filter.blockCrafting()) continue;
            }
            LinkedList<IFilter> list = new LinkedList<IFilter>();
            list.addAll(r.filters);
            crafters.add(new Pair(craftable, list));
        }
        return crafters;
    }

    private int getSubRequests(int nCraftingSets, CraftingTemplate template) {
        boolean failed = false;
        List<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>> stacks = template.getComponentItems(nCraftingSets);
        int workSetsAvailable = nCraftingSets;
        ArrayList<SubRequestGroup> lastNodes = new ArrayList<SubRequestGroup>(stacks.size());
        for (Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation> stack : stacks) {
            if (((CraftingRequirement)stack.getValue1()).isUnique()) {
                RequestTreeNode node = new RequestTreeNode(template, ((CraftingRequirement)stack.getValue1()).stack, (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags, stack.getValue3());
                SubRequestGroup grp = new SubRequestGroup();
                grp.addNode(node);
                lastNodes.add(grp);
                if (node.isDone()) continue;
                failed = true;
                continue;
            }
            ArrayList<ItemIdentifier> subtitutes = ((CraftingRequirement)stack.getValue1()).GetSubtitutes(this.target);
            int req = ((CraftingRequirement)stack.getValue1()).stack.getStackSize();
            SubRequestGroup grp = new SubRequestGroup();
            for (ItemIdentifier i : subtitutes) {
                if (req <= 0) break;
                RequestTreeNode node = new RequestTreeNode(template, new ItemIdentifierStack(i, req), (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags, stack.getValue3());
                req -= node.getPromiseItemCount();
                grp.addNode(node);
            }
            if (req > 0) {
                failed = true;
            }
            lastNodes.add(grp);
        }
        List<Triplet<FluidIdentifier, Integer, IRequestFluid>> liquids = template.getComponentFluid(nCraftingSets);
        ArrayList<FluidRequestTreeNode> lastFluidNode = new ArrayList<FluidRequestTreeNode>(liquids.size());
        for (Triplet<FluidIdentifier, Integer, IRequestFluid> liquid : liquids) {
            FluidRequestTreeNode node = new FluidRequestTreeNode((FluidIdentifier)liquid.getValue1(), (Integer)liquid.getValue2(), liquid.getValue3(), this);
            lastFluidNode.add(node);
            if (node.isDone()) continue;
            failed = true;
        }
        if (failed) {
            int i;
            for (SubRequestGroup g : lastNodes) {
                for (RequestTreeNode n : g.getNodes()) {
                    n.destroy();
                }
            }
            for (FluidRequestTreeNode n : lastFluidNode) {
                n.destroy();
            }
            this.lastCrafterTried = template;
            for (i = 0; i < stacks.size(); ++i) {
                workSetsAvailable = Math.min(workSetsAvailable, ((SubRequestGroup)lastNodes.get(i)).getTotalPromiseItemCount() / (((CraftingRequirement)stacks.get((int)i).getValue1()).stack.getStackSize() / nCraftingSets));
            }
            for (i = 0; i < liquids.size(); ++i) {
                workSetsAvailable = Math.min(workSetsAvailable, ((FluidRequestTreeNode)lastFluidNode.get(i)).getPromiseFluidAmount() / ((Integer)liquids.get(i).getValue2() / nCraftingSets));
            }
            return this.generateRequestTreeFor(workSetsAvailable, template);
        }
        for (ItemIdentifierStack stack : template.getByproduct()) {
            LogisticsExtraPromise extra = new LogisticsExtraPromise(stack.getItem(), stack.getStackSize() * workSetsAvailable, (IProvideItems)template.getCrafter(), false);
            this.byproducts.add(extra);
        }
        return workSetsAvailable;
    }

    private int generateRequestTreeFor(int workSets, CraftingTemplate template) {
        ArrayList<RequestTreeNode> newChildren = new ArrayList<RequestTreeNode>();
        ArrayList<FluidRequestTreeNode> newFluidChildren = new ArrayList<FluidRequestTreeNode>();
        if (workSets > 0) {
            List<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>> stacks = template.getComponentItems(workSets);
            boolean failed = false;
            for (Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation> stack : stacks) {
                if (((CraftingRequirement)stack.getValue1()).isUnique()) {
                    RequestTreeNode node = new RequestTreeNode(template, ((CraftingRequirement)stack.getValue1()).stack, (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags, stack.getValue3());
                    newChildren.add(node);
                    if (node.isDone()) continue;
                    failed = true;
                    continue;
                }
                ArrayList<ItemIdentifier> subtitutes = ((CraftingRequirement)stack.getValue1()).GetSubtitutes(this.target);
                int req = ((CraftingRequirement)stack.getValue1()).stack.getStackSize();
                for (ItemIdentifier i : subtitutes) {
                    if (req <= 0) break;
                    RequestTreeNode node = new RequestTreeNode(template, new ItemIdentifierStack(i, req), (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags, stack.getValue3());
                    req -= node.getPromiseItemCount();
                    newChildren.add(node);
                }
                if (req <= 0) continue;
                failed = true;
            }
            List<Triplet<FluidIdentifier, Integer, IRequestFluid>> liquids = template.getComponentFluid(workSets);
            for (Triplet<FluidIdentifier, Integer, IRequestFluid> liquid : liquids) {
                FluidRequestTreeNode node = new FluidRequestTreeNode((FluidIdentifier)liquid.getValue1(), (Integer)liquid.getValue2(), liquid.getValue3(), this);
                newFluidChildren.add(node);
                if (node.isDone()) continue;
                failed = true;
            }
            if (failed) {
                for (RequestTreeNode c : newChildren) {
                    c.destroy();
                }
                for (FluidRequestTreeNode n : newFluidChildren) {
                    n.destroy();
                }
                return 0;
            }
        }
        for (ItemIdentifierStack stack : template.getByproduct()) {
            LogisticsExtraPromise extra = new LogisticsExtraPromise(stack.getItem(), stack.getStackSize() * workSets, (IProvideItems)template.getCrafter(), false);
            this.byproducts.add(extra);
        }
        return workSets;
    }

    void recurseFailedRequestTree() {
        if (this.isDone()) {
            return;
        }
        if (this.lastCrafterTried == null) {
            return;
        }
        CraftingTemplate template = this.lastCrafterTried;
        int nCraftingSetsNeeded = (this.getMissingItemCount() + template.getResultStackSize() - 1) / template.getResultStackSize();
        List<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>> stacks = template.getComponentItems(nCraftingSetsNeeded);
        for (Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation> stack : stacks) {
            new RequestTreeNode(template, ((CraftingRequirement)stack.getValue1()).stack, (IRequestItems)stack.getValue2(), this, RequestTree.defaultRequestFlags, stack.getValue3());
        }
        List<Triplet<FluidIdentifier, Integer, IRequestFluid>> liquids = template.getComponentFluid(nCraftingSetsNeeded);
        for (Triplet<FluidIdentifier, Integer, IRequestFluid> liquid : liquids) {
            new FluidRequestTreeNode((FluidIdentifier)liquid.getValue1(), (Integer)liquid.getValue2(), liquid.getValue3(), this);
        }
        this.addPromise(template.generatePromise(nCraftingSetsNeeded));
        for (RequestTreeNode subNode : this.subRequests) {
            subNode.recurseFailedRequestTree();
        }
    }

    protected void logFailedRequestTree(RequestLog log) {
        HashMap<ItemIdentifier, Integer> missing = new HashMap<ItemIdentifier, Integer>();
        for (RequestTreeNode node : this.subRequests) {
            if (!(node instanceof RequestTree) || node.isDone()) continue;
            node.recurseFailedRequestTree();
            node.buildMissingMap(missing);
        }
        log.handleMissingItems(missing);
    }

    private void destroy() {
        this.parentNode.remove(this);
    }

    private class CraftingSorterNode
    implements Comparable<CraftingSorterNode> {
        private int stacksOfWorkRequested;
        private final int setSize;
        private final int maxWorkSetsAvailable;
        private final RequestTreeNode treeNode;
        public final Pair<CraftingTemplate, List<IFilter>> crafter;
        public final int originalToDo;

        CraftingSorterNode(Pair<CraftingTemplate, List<IFilter>> crafter, int maxCount, RequestTree tree, RequestTreeNode treeNode) {
            this.crafter = crafter;
            this.treeNode = treeNode;
            this.originalToDo = crafter.getValue1().getCrafter().getTodo();
            this.stacksOfWorkRequested = 0;
            this.setSize = crafter.getValue1().getResultStackSize();
            this.maxWorkSetsAvailable = (treeNode.getMissingItemCount() + this.setSize - 1) / this.setSize;
        }

        int calculateMaxWork(int maxSetsToCraft) {
            int nCraftingSetsNeeded = maxSetsToCraft == 0 ? (this.treeNode.getMissingItemCount() + this.setSize - 1) / this.setSize : maxSetsToCraft;
            if (nCraftingSetsNeeded == 0) {
                return 0;
            }
            CraftingTemplate template = this.crafter.getValue1();
            int stacks = RequestTreeNode.this.getSubRequests(nCraftingSetsNeeded, template);
            return stacks;
        }

        int addToWorkRequest(int extraWork) {
            int stacksRequested = (extraWork + this.setSize - 1) / this.setSize;
            this.stacksOfWorkRequested += stacksRequested;
            return stacksRequested * this.setSize;
        }

        boolean addWorkPromisesToTree() {
            CraftingTemplate template = this.crafter.getValue1();
            int setsToCraft = Math.min(this.stacksOfWorkRequested, this.maxWorkSetsAvailable);
            int setsAbleToCraft = this.calculateMaxWork(setsToCraft);
            if (setsAbleToCraft > 0) {
                LogisticsPromise job = template.generatePromise(setsAbleToCraft);
                if (job.numberOfItems != setsAbleToCraft * this.setSize) {
                    throw new IllegalStateException("generatePromises not creating the promisesPromised; this is goign to end badly.");
                }
                this.treeNode.addPromise(job);
            }
            boolean isDone = setsToCraft == setsAbleToCraft;
            this.stacksOfWorkRequested = 0;
            return isDone;
        }

        @Override
        public int compareTo(CraftingSorterNode o) {
            return this.currentToDo() - o.currentToDo();
        }

        public int currentToDo() {
            return this.originalToDo + this.stacksOfWorkRequested * this.setSize;
        }
    }
}

