/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFluidProvider;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.FluidRequestTreeNode;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.FinalPair;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;

public class RequestTree
extends RequestTreeNode {
    public static final EnumSet<ActiveRequestType> defaultRequestFlags = EnumSet.of(ActiveRequestType.Provide, ActiveRequestType.Craft);
    private HashMap<FinalPair<IProvideItems, ItemIdentifier>, Integer> _promisetotals;
    private HashMap<FinalPair<IFluidProvider, FluidIdentifier>, Integer> _promisetotalsliquid;

    public RequestTree(ItemIdentifierStack item, IRequestItems requester, RequestTree parent, EnumSet<ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        super(item, requester, parent, requestFlags, info);
    }

    private int getExistingPromisesFor(FinalPair<IProvideItems, ItemIdentifier> key) {
        Integer n;
        if (this._promisetotals == null) {
            this._promisetotals = new HashMap();
        }
        if ((n = this._promisetotals.get(key)) == null) {
            return 0;
        }
        return n;
    }

    private int getExistingFluidPromisesFor(FinalPair<IFluidProvider, FluidIdentifier> key) {
        Integer n;
        if (this._promisetotalsliquid == null) {
            this._promisetotalsliquid = new HashMap();
        }
        if ((n = this._promisetotalsliquid.get(key)) == null) {
            return 0;
        }
        return n;
    }

    protected int getAllPromissesFor(IProvideItems provider, ItemIdentifier item) {
        FinalPair<IProvideItems, ItemIdentifier> key = new FinalPair<IProvideItems, ItemIdentifier>(provider, item);
        return this.getExistingPromisesFor(key);
    }

    protected int getAllPromissesFor(IFluidProvider provider, FluidIdentifier liquid) {
        FinalPair<IFluidProvider, FluidIdentifier> key = new FinalPair<IFluidProvider, FluidIdentifier>(provider, liquid);
        return this.getExistingFluidPromisesFor(key);
    }

    protected LinkedList<LogisticsExtraPromise> getExtrasFor(ItemIdentifier item) {
        HashMap<IProvideItems, List<LogisticsExtraPromise>> extraMap = new HashMap<IProvideItems, List<LogisticsExtraPromise>>();
        this.checkForExtras(item, extraMap);
        this.removeUsedExtras(item, extraMap);
        LinkedList<LogisticsExtraPromise> extras = new LinkedList<LogisticsExtraPromise>();
        for (List<LogisticsExtraPromise> sublist : extraMap.values()) {
            extras.addAll(sublist);
        }
        return extras;
    }

    protected LinkedLogisticsOrderList fullFillAll() {
        return this.fullFill();
    }

    public void sendMissingMessage(RequestLog log) {
        HashMap<ItemIdentifier, Integer> missing = new HashMap<ItemIdentifier, Integer>();
        this.buildMissingMap(missing);
        log.handleMissingItems(missing);
    }

    public void sendUsedMessage(RequestLog log) {
        HashMap<ItemIdentifier, Integer> used = new HashMap<ItemIdentifier, Integer>();
        HashMap<ItemIdentifier, Integer> missing = new HashMap<ItemIdentifier, Integer>();
        this.buildUsedMap(used, missing);
        log.handleSucessfullRequestOfList(used, new LinkedLogisticsOrderList());
        log.handleMissingItems(missing);
    }

    protected void promiseAdded(LogisticsPromise promise) {
        FinalPair<IProvideItems, ItemIdentifier> key = new FinalPair<IProvideItems, ItemIdentifier>(promise.sender, promise.item);
        if (this._promisetotals == null) {
            this._promisetotals = new HashMap();
        }
        this._promisetotals.put(key, this.getExistingPromisesFor(key) + promise.numberOfItems);
    }

    protected void promiseRemoved(LogisticsPromise promise) {
        FinalPair<IProvideItems, ItemIdentifier> key = new FinalPair<IProvideItems, ItemIdentifier>(promise.sender, promise.item);
        int r = this.getExistingPromisesFor(key) - promise.numberOfItems;
        if (r == 0) {
            this._promisetotals.remove(key);
        } else {
            this._promisetotals.put(key, r);
        }
    }

    protected void promiseAdded(FluidLogisticsPromise promise) {
        FinalPair<IFluidProvider, FluidIdentifier> key = new FinalPair<IFluidProvider, FluidIdentifier>(promise.sender, promise.liquid);
        this._promisetotalsliquid.put(key, this.getExistingFluidPromisesFor(key) + promise.amount);
    }

    protected void promiseRemoved(FluidLogisticsPromise promise) {
        FinalPair<IFluidProvider, FluidIdentifier> key = new FinalPair<IFluidProvider, FluidIdentifier>(promise.sender, promise.liquid);
        int r = this.getExistingFluidPromisesFor(key) - promise.amount;
        if (r == 0) {
            this._promisetotalsliquid.remove(key);
        } else {
            this._promisetotalsliquid.put(key, r);
        }
    }

    public static boolean request(List<ItemIdentifierStack> items, IRequestItems requester, RequestLog log, EnumSet<ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        HashMap<ItemIdentifier, Integer> messages = new HashMap<ItemIdentifier, Integer>();
        RequestTree tree = new RequestTree(new ItemIdentifierStack(ItemIdentifier.get(Item.func_150898_a((Block)Blocks.field_150348_b), 0, null), 0), requester, null, requestFlags, info);
        boolean isDone = true;
        for (ItemIdentifierStack stack : items) {
            ItemIdentifier item = stack.getItem();
            Integer count = (Integer)messages.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + stack.getStackSize();
            messages.put(item, count);
            RequestTree node = new RequestTree(stack, requester, tree, requestFlags, info);
            isDone = isDone && node.isDone();
        }
        if (isDone) {
            LinkedLogisticsOrderList list = tree.fullFillAll();
            if (log != null) {
                log.handleSucessfullRequestOfList(messages, list);
            }
            return true;
        }
        if (log != null) {
            tree.logFailedRequestTree(log);
        }
        return false;
    }

    public static int request(ItemIdentifierStack item, IRequestItems requester, RequestLog log, boolean acceptPartial, boolean simulateOnly, boolean logMissing, boolean logUsed, EnumSet<ActiveRequestType> requestFlags, IAdditionalTargetInformation info) {
        RequestTree tree = new RequestTree(item, requester, null, requestFlags, info);
        if (!simulateOnly && (tree.isDone() || tree.getPromiseItemCount() > 0 && acceptPartial)) {
            LinkedLogisticsOrderList list = tree.fullFillAll();
            if (log != null) {
                log.handleSucessfullRequestOf(item.getItem(), item.getStackSize(), list);
            }
            return tree.getPromiseItemCount();
        }
        if (log != null) {
            if (!tree.isDone()) {
                tree.recurseFailedRequestTree();
            }
            if (logMissing) {
                tree.sendMissingMessage(log);
            }
            if (logUsed) {
                tree.sendUsedMessage(log);
            }
        }
        return tree.getPromiseItemCount();
    }

    public static boolean request(ItemIdentifierStack item, IRequestItems requester, RequestLog log, IAdditionalTargetInformation info) {
        return RequestTree.request(item, requester, log, false, false, true, false, defaultRequestFlags, info) == item.getStackSize();
    }

    public static int requestPartial(ItemIdentifierStack item, IRequestItems requester, IAdditionalTargetInformation info) {
        return RequestTree.request(item, requester, null, true, false, true, false, defaultRequestFlags, info);
    }

    public static int simulate(ItemIdentifierStack item, IRequestItems requester, RequestLog log) {
        return RequestTree.request(item, requester, log, true, true, false, true, defaultRequestFlags, null);
    }

    public static int requestFluidPartial(FluidIdentifier liquid, int amount, IRequestFluid pipe, RequestLog log) {
        return RequestTree.requestFluid(liquid, amount, pipe, log, true);
    }

    public static boolean requestFluid(FluidIdentifier liquid, int amount, IRequestFluid pipe, RequestLog log) {
        return RequestTree.requestFluid(liquid, amount, pipe, log, false) == amount;
    }

    private static int requestFluid(FluidIdentifier liquid, int amount, IRequestFluid pipe, RequestLog log, boolean acceptPartial) {
        FluidRequestTreeNode request = new FluidRequestTreeNode(liquid, amount, pipe, null);
        if (request.isDone() || acceptPartial) {
            request.fullFill();
            if (log != null) {
                log.handleSucessfullRequestOf(request.getFluid().getItemIdentifier(), request.getAmount(), null);
            }
            return request.getPromiseFluidAmount();
        }
        if (log != null) {
            request.sendMissingMessage(log);
        }
        return request.getPromiseFluidAmount();
    }

    public static class workWeightedSorter
    implements Comparator<ExitRoute> {
        public final double distanceWeight;

        public workWeightedSorter(double distanceWeight) {
            this.distanceWeight = distanceWeight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ExitRoute o1, ExitRoute o2) {
            int c = 0;
            if (o1.destination.getPipe() instanceof IHavePriority) {
                if (!(o2.destination.getPipe() instanceof IHavePriority)) return -1;
                c = ((IHavePriority)((Object)o2.destination.getCachedPipe())).getPriority() - ((IHavePriority)((Object)o1.destination.getCachedPipe())).getPriority();
                if (c != 0) {
                    return c;
                }
            } else if (o2.destination.getPipe() instanceof IHavePriority) {
                return 1;
            }
            c = (int)Math.floor(o1.destination.getCachedPipe().getLoadFactor() * 64.0) - (int)Math.floor(o2.destination.getCachedPipe().getLoadFactor() * 64.0);
            if (this.distanceWeight == 0.0) return c;
            return (int)((double)c + (double)((int)(Math.floor(o1.distanceToDestination * 64) - (double)((int)Math.floor(o2.distanceToDestination * 64)))) * this.distanceWeight);
        }
    }

    public static enum ActiveRequestType {
        Provide,
        Craft,
        AcceptPartial,
        SimulateOnly,
        LogMissing,
        LogUsed;

    }
}

