/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.routing.IFluidProvider;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;

public class FluidRequestTreeNode {
    protected final FluidIdentifier liquid;
    protected final int amount;
    protected List<FluidLogisticsPromise> promises = new ArrayList<FluidLogisticsPromise>();
    private int promiseFluidAmount = 0;
    protected final RequestTree root;
    protected final IRequestFluid target;
    private final RequestTreeNode parentNode;

    public FluidRequestTreeNode(FluidIdentifier liquid, int amount, IRequestFluid target, RequestTreeNode parentNode) {
        this.liquid = liquid;
        this.amount = amount;
        this.target = target;
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.liquidSubRequests.add(this);
            this.root = parentNode.root;
        } else {
            this.root = null;
        }
        this.checkFluidProvider();
    }

    public void addPromise(FluidLogisticsPromise promise) {
        this.promises.add(promise);
        this.promiseFluidAmount += promise.amount;
        if (this.root != null) {
            this.root.promiseAdded(promise);
        }
    }

    protected void buildMissingMap(Map<ItemIdentifier, Integer> missing) {
        if (this.amountLeft() != 0) {
            ItemIdentifier item = this.liquid.getItemIdentifier();
            Integer count = missing.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + this.amountLeft();
            missing.put(item, count);
        }
    }

    protected void buildUsedMap(Map<ItemIdentifier, Integer> used, Map<ItemIdentifier, Integer> missing) {
        Integer count;
        ItemIdentifier item;
        int usedcount = this.promiseFluidAmount;
        if (usedcount != 0) {
            item = this.liquid.getItemIdentifier();
            count = used.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + usedcount;
            used.put(item, count);
        }
        if (this.amountLeft() != 0) {
            item = this.liquid.getItemIdentifier();
            count = missing.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + this.amountLeft();
            missing.put(item, count);
        }
    }

    public void fullFill() {
        for (FluidLogisticsPromise promise : this.promises) {
            promise.sender.fullFill(promise, this.target);
        }
    }

    public IRequestFluid getTarget() {
        return this.target;
    }

    void destroy() {
        if (this.parentNode != null) {
            this.parentNode.remove(this);
        }
    }

    protected void removeSubPromisses() {
        for (FluidLogisticsPromise promise : this.promises) {
            if (this.root == null) continue;
            this.root.promiseRemoved(promise);
        }
    }

    private boolean checkFluidProvider() {
        boolean done = true;
        FluidRoutedPipe thisPipe = (FluidRoutedPipe)((Object)this.target);
        List<IFluidProvider> providers = this.getFluidProviders();
        for (IFluidProvider provider : providers) {
            if (thisPipe.sharesTankWith((FluidRoutedPipe)((Object)provider))) continue;
            int alreadyRequested = 0;
            if (this.root != null) {
                alreadyRequested = this.root.getAllPromissesFor(provider, this.getFluid());
            }
            provider.canProvide(this, alreadyRequested);
        }
        if (!this.isDone()) {
            done = false;
        }
        return done;
    }

    private List<IFluidProvider> getFluidProviders() {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(this.liquid.getItemIdentifier());
        LinkedList<IFluidProvider> providers = new LinkedList<IFluidProvider>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            List<ExitRoute> e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.getPipe() instanceof IFluidProvider && (e = this.target.getRouter().getDistanceTo(r)) != null) {
                for (ExitRoute route : e) {
                    CoreRoutedPipe pipe;
                    if (!route.filters.isEmpty() || !((pipe = route.destination.getPipe()) instanceof IFluidProvider)) continue;
                    providers.add((IFluidProvider)((Object)pipe));
                }
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        return providers;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidIdentifier getFluid() {
        return this.liquid;
    }

    public ItemIdentifierStack getStack() {
        return this.liquid.getItemIdentifier().makeStack(this.amount);
    }

    public int amountLeft() {
        return this.amount - this.promiseFluidAmount;
    }

    public boolean isDone() {
        return this.amountLeft() <= 0;
    }

    public void sendMissingMessage(RequestLog log) {
        HashMap<ItemIdentifier, Integer> missing = new HashMap<ItemIdentifier, Integer>();
        missing.put(this.liquid.getItemIdentifier(), this.amountLeft());
        log.handleMissingItems(missing);
    }

    public int getPromiseFluidAmount() {
        return this.promiseFluidAmount;
    }
}

