/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.CraftingRequirement;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;

public class CraftingTemplate
implements Comparable<CraftingTemplate> {
    protected ItemIdentifierStack _result;
    protected ICraftItems _crafter;
    protected ArrayList<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>> _required = new ArrayList(9);
    protected ArrayList<Triplet<FluidIdentifier, Integer, IRequestFluid>> _requiredFluid = new ArrayList();
    protected ArrayList<ItemIdentifierStack> _byproduct = new ArrayList(9);
    private final int priority;

    public CraftingTemplate(ItemIdentifierStack result, ICraftItems crafter, int priority) {
        this._result = result;
        this._crafter = crafter;
        this.priority = priority;
    }

    public void addRequirement(CraftingRequirement requirement, IRequestItems crafter, IAdditionalTargetInformation info) {
        for (Pair pair : this._required) {
            if (!((CraftingRequirement)pair.getValue1()).isSameItemAndFlag(requirement) || pair.getValue2() != crafter) continue;
            ((CraftingRequirement)pair.getValue1()).stack.setStackSize(((CraftingRequirement)pair.getValue1()).stack.getStackSize() + requirement.stack.getStackSize());
            return;
        }
        this._required.add(new Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>(requirement, crafter, info));
    }

    public void addRequirement(FluidIdentifier liquid, Integer amount, IRequestFluid crafter) {
        for (Triplet<FluidIdentifier, Integer, IRequestFluid> i : this._requiredFluid) {
            if (!((FluidIdentifier)i.getValue1()).equals(liquid) || i.getValue3() != crafter) continue;
            i.setValue2((Integer)i.getValue2() + amount);
            return;
        }
        this._requiredFluid.add(new Triplet<FluidIdentifier, Integer, IRequestFluid>(liquid, amount, crafter));
    }

    public void addByproduct(ItemIdentifierStack stack) {
        for (ItemIdentifierStack i : this._byproduct) {
            if (!i.getItem().equals(stack.getItem())) continue;
            i.setStackSize(i.getStackSize() + stack.getStackSize());
            return;
        }
        this._byproduct.add(stack);
    }

    public LogisticsPromise generatePromise(int nResultSets) {
        return new LogisticsPromise(this._result.getItem(), this._result.getStackSize() * nResultSets, this._crafter, LogisticsPromise.PromiseType.CRAFTING);
    }

    public ICraftItems getCrafter() {
        return this._crafter;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(CraftingTemplate o) {
        int c = this.priority - o.priority;
        if (c == 0) {
            c = this._result.compareTo(o._result);
        }
        if (c == 0) {
            c = this._crafter.compareTo(o._crafter);
        }
        return c;
    }

    public boolean canCraft(ItemIdentifier item) {
        return item.equals(this._result.getItem());
    }

    public int getResultStackSize() {
        return this._result.getStackSize();
    }

    ItemIdentifier getResultItem() {
        return this._result.getItem();
    }

    public List<ItemIdentifierStack> getByproduct() {
        return this._byproduct;
    }

    protected List<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>> getComponentItems(int nCraftingSetsNeeded) {
        ArrayList<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>> stacks = new ArrayList<Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation>>(this._required.size());
        for (Triplet<CraftingRequirement, IRequestItems, IAdditionalTargetInformation> stack : this._required) {
            Triplet pair = new Triplet(((CraftingRequirement)stack.getValue1()).clone(), stack.getValue2(), stack.getValue3());
            ((CraftingRequirement)pair.getValue1()).stack.setStackSize(((CraftingRequirement)pair.getValue1()).stack.getStackSize() * nCraftingSetsNeeded);
            stacks.add(pair);
        }
        return stacks;
    }

    protected List<Triplet<FluidIdentifier, Integer, IRequestFluid>> getComponentFluid(int nCraftingSetsNeeded) {
        ArrayList<Triplet<FluidIdentifier, Integer, IRequestFluid>> stacks = new ArrayList<Triplet<FluidIdentifier, Integer, IRequestFluid>>(this._requiredFluid.size());
        for (Triplet<FluidIdentifier, Integer, IRequestFluid> stack : this._requiredFluid) {
            stacks.add(new Triplet(stack.getValue1(), (Integer)stack.getValue2() * nCraftingSetsNeeded, stack.getValue3()));
        }
        return stacks;
    }
}

