/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.state;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import net.minecraftforge.common.util.ForgeDirection;

public class TextureMatrix {
    private final int[] iconIndexes = new int[7];
    private boolean dirty = false;

    public int getTextureIndex(ForgeDirection direction) {
        return this.iconIndexes[direction.ordinal()];
    }

    public void setIconIndex(ForgeDirection direction, int value) {
        if (this.iconIndexes[direction.ordinal()] != value) {
            this.iconIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(LPDataOutputStream data) throws IOException {
        for (int iconIndexe : this.iconIndexes) {
            data.writeByte(iconIndexe);
        }
    }

    public void readData(LPDataInputStream data) throws IOException {
        for (int i = 0; i < this.iconIndexes.length; ++i) {
            byte icon = data.readByte();
            if (this.iconIndexes[i] == icon) continue;
            this.iconIndexes[i] = icon;
            this.dirty = true;
        }
    }
}

