/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.state;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import logisticspipes.interfaces.IClientState;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.proxy.buildcraft.subproxies.IBCRenderState;
import logisticspipes.proxy.buildcraft.subproxies.IBCTilePart;
import logisticspipes.renderer.state.ConnectionMatrix;
import logisticspipes.renderer.state.TextureMatrix;
import net.minecraft.util.IIcon;

public class PipeRenderState
implements IClientState {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final IBCRenderState bcRenderState;
    @SideOnly(value=Side.CLIENT)
    public IIcon currentTexture;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] textureArray;
    private boolean dirty = true;

    public PipeRenderState(IBCTilePart tilePart) {
        this.bcRenderState = tilePart.getBCRenderState();
    }

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.bcRenderState.clean();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.bcRenderState.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.bcRenderState.needsRenderUpdate();
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.bcRenderState.writeData_LP(data);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.bcRenderState.readData_LP(data);
    }
}

