/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCRenderTESR;
import logisticspipes.renderer.CustomBlockRenderer;
import logisticspipes.renderer.FluidRenderer;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelSign;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LogisticsRenderPipe
extends TileEntitySpecialRenderer {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private HashMap<Integer, DisplayFluidList> displayFluidLists = new HashMap();
    private ModelSign modelSign = new ModelSign();
    private RenderBlocks renderBlocks = new RenderBlocks();
    private IBCRenderTESR bcRenderer = SimpleServiceLocator.buildCraftProxy.getBCRenderTESR();
    private static final ResourceLocation SIGN = new ResourceLocation("textures/entity/sign.png");
    private static final ResourceLocation BLOCKS = new ResourceLocation("textures/atlas/blocks.png");
    private static final ResourceLocation ITEMS = new ResourceLocation("textures/atlas/items.png");

    public LogisticsRenderPipe() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
        this.dummyEntityItem.field_70292_b = 0;
        this.dummyEntityItem.field_70290_d = 0.0f;
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        if (!(tileentity instanceof LogisticsTileGenericPipe)) {
            return;
        }
        LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        this.bcRenderer.renderWires(pipe, x, y, z);
        this.bcRenderer.renderGates(pipe, x, y, z);
        if (!pipe.isOpaque()) {
            if (pipe.pipe.transport instanceof PipeFluidTransportLogistics) {
                this.renderFluids(pipe.pipe, x, y, z);
            }
            if (pipe.pipe.transport instanceof PipeTransportLogistics) {
                this.renderSolids(pipe.pipe, x, y, z, f);
            }
        }
        if (pipe.pipe instanceof CoreRoutedPipe) {
            this.renderPipeSigns((CoreRoutedPipe)pipe.pipe, x, y, z);
        }
    }

    private void renderSolids(CoreUnroutedPipe pipe, double x, double y, double z, float f) {
        ItemStack itemstack;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float light = pipe.container.func_145831_w().func_72801_o(pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e);
        int count = 0;
        for (LPTravelingItem item : pipe.transport.items) {
            if (count >= 10) break;
            LPPosition pos = new LPPosition(0.5, 0.5, 0.5);
            if (item.getPosition() > 1.0f || item.getPosition() < 0.0f) continue;
            float fPos = item.getPosition() + item.getSpeed() * f;
            if ((double)fPos < 0.5) {
                if (item.input == ForgeDirection.UNKNOWN || !pipe.container.renderState.pipeConnectionMatrix.isConnected(item.input.getOpposite())) continue;
                pos.moveForward(item.input.getOpposite(), 0.5f - fPos);
            } else {
                if (item.output == ForgeDirection.UNKNOWN || !pipe.container.renderState.pipeConnectionMatrix.isConnected(item.output)) continue;
                pos.moveForward(item.output, fPos - 0.5f);
            }
            if (item == null || item.getItemIdentifierStack() == null || item.getContainer().field_145851_c != pipe.container.field_145851_c || item.getContainer().field_145848_d != pipe.container.field_145848_d || item.getContainer().field_145849_e != pipe.container.field_145849_e) continue;
            itemstack = item.getItemIdentifierStack().makeNormalStack();
            this.doRenderItem(itemstack, x + pos.getXD(), y + pos.getYD(), z + pos.getZD(), light, item.getAge(), item.getHoverStart(), 0.7f);
            ++count;
        }
        count = 0;
        float dist = 0.135f;
        LPPosition pos = new LPPosition(0.5, 0.5, 0.5);
        pos.moveForward(ForgeDirection.SOUTH, dist);
        pos.moveForward(ForgeDirection.EAST, dist);
        pos.moveForward(ForgeDirection.UP, dist);
        for (Pair<ItemIdentifierStack, Pair<Integer, Integer>> item : pipe.transport._itemBuffer) {
            if (item == null || item.getValue1() == null) continue;
            itemstack = item.getValue1().makeNormalStack();
            this.doRenderItem(itemstack, x + pos.getXD(), y + pos.getYD(), z + pos.getZD(), light, 0, 0.0f, 0.25f);
            if (++count >= 27) break;
            if (count % 9 == 0) {
                pos.moveForward(ForgeDirection.SOUTH, dist * 2.0f);
                pos.moveForward(ForgeDirection.EAST, dist * 2.0f);
                pos.moveForward(ForgeDirection.DOWN, dist);
                continue;
            }
            if (count % 3 == 0) {
                pos.moveForward(ForgeDirection.SOUTH, dist * 2.0f);
                pos.moveForward(ForgeDirection.WEST, dist);
                continue;
            }
            pos.moveForward(ForgeDirection.NORTH, dist);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void doRenderItem(ItemStack itemstack, double x, double y, double z, float light, int age, float hoverStart, float renderScale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(itemstack);
        this.dummyEntityItem.field_70292_b = age;
        this.dummyEntityItem.field_70290_d = hoverStart;
        this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.dummyEntityItem.field_70292_b = 0;
        this.dummyEntityItem.field_70290_d = 0.0f;
        GL11.glPopMatrix();
    }

    private boolean needDistance(List<Pair<ForgeDirection, IPipeSign>> list) {
        boolean result;
        ArrayList<Pair<ForgeDirection, IPipeSign>> copy = new ArrayList<Pair<ForgeDirection, IPipeSign>>(list);
        Iterator iter = copy.iterator();
        boolean north = false;
        boolean south = false;
        boolean east = false;
        boolean west = false;
        while (iter.hasNext()) {
            Pair pair = (Pair)iter.next();
            if (pair.getValue1() == ForgeDirection.UP || pair.getValue1() == ForgeDirection.DOWN || pair.getValue1() == ForgeDirection.UNKNOWN) {
                iter.remove();
            }
            if (pair.getValue1() == ForgeDirection.NORTH) {
                north = true;
            }
            if (pair.getValue1() == ForgeDirection.SOUTH) {
                south = true;
            }
            if (pair.getValue1() == ForgeDirection.EAST) {
                east = true;
            }
            if (pair.getValue1() != ForgeDirection.WEST) continue;
            west = true;
        }
        boolean bl = result = copy.size() > 1;
        if (copy.size() == 2) {
            if (north && south) {
                result = false;
            }
            if (east && west) {
                result = false;
            }
        }
        return result;
    }

    private void renderPipeSigns(CoreRoutedPipe pipe, double x, double y, double z) {
        if (!pipe.getPipeSigns().isEmpty()) {
            List<Pair<ForgeDirection, IPipeSign>> list = pipe.getPipeSigns();
            for (Pair<ForgeDirection, IPipeSign> pair : list) {
                if (pipe.container.renderState.pipeConnectionMatrix.isConnected(pair.getValue1())) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                switch (pair.getValue1()) {
                    case UP: {
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case DOWN: {
                        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case NORTH: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case SOUTH: {
                        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case EAST: {
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case WEST: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                }
                this.renderSign(pipe, pair.getValue2());
                GL11.glPopMatrix();
            }
        }
    }

    private void renderSign(CoreRoutedPipe pipe, IPipeSign type) {
        float var10 = 0.6666667f;
        GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.31f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.modelSign.field_78165_b.field_78806_j = false;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SIGN);
        GL11.glPushMatrix();
        GL11.glScalef((float)var10, (float)(-var10), (float)(-var10));
        this.modelSign.func_78164_a();
        GL11.glPopMatrix();
        GL11.glTranslatef((float)-0.32f, (float)(0.5f * var10 + 0.08f), (float)(0.07f * var10));
        GL11.glPushAttrib((int)1048575);
        this.renderSignLabel(pipe, type);
        GL11.glPopAttrib();
    }

    private void renderSignLabel(CoreRoutedPipe pipe, IPipeSign type) {
        type.render(pipe, this);
    }

    public void renderItemStackOnSign(ItemStack itemstack) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return;
        }
        Item item = itemstack.func_77973_b();
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(itemstack.func_94608_d() == 0 ? BLOCKS : ITEMS);
        GL11.glPushMatrix();
        if (customRenderer != null) {
            if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, itemstack, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK)) {
                GL11.glScalef((float)0.2f, (float)-0.2f, (float)-0.01f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)16384);
                GL11.glDisable((int)16385);
                GL11.glDisable((int)2903);
                customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, itemstack, new Object[]{this.renderBlocks});
                GL11.glEnable((int)2896);
                GL11.glEnable((int)16384);
                GL11.glEnable((int)16385);
                GL11.glEnable((int)2903);
            } else {
                GL11.glScalef((float)0.018f, (float)-0.018f, (float)-0.01f);
                GL11.glTranslatef((float)-7.0f, (float)-8.0f, (float)0.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)16384);
                GL11.glDisable((int)16385);
                GL11.glDisable((int)2903);
                customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, itemstack, new Object[]{this.renderBlocks});
                GL11.glEnable((int)2896);
                GL11.glEnable((int)16384);
                GL11.glEnable((int)16385);
                GL11.glEnable((int)2903);
            }
        } else if (item instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item).func_149645_b())) {
            GL11.glScalef((float)0.2f, (float)-0.2f, (float)-0.01f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.field_147844_c = false;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glDisable((int)2903);
            this.renderBlocks.func_147800_a(Block.func_149634_a((Item)item), itemstack.func_77960_j(), 1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)16385);
            GL11.glEnable((int)2903);
        } else {
            GL11.glScalef((float)0.02f, (float)-0.02f, (float)-0.01f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glDisable((int)2903);
            GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)0.0f);
            if (item.func_77623_v()) {
                for (int var14 = 0; var14 < item.getRenderPasses(itemstack.func_77960_j()); ++var14) {
                    IIcon var15 = item.func_77618_c(itemstack.func_77960_j(), var14);
                    this.renderItem(var15);
                }
            } else {
                this.renderItem(item.func_77650_f(itemstack));
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)16385);
            GL11.glEnable((int)2903);
        }
        GL11.glPopMatrix();
    }

    private void renderItem(IIcon par3Icon) {
        if (par3Icon == null) {
            return;
        }
        int par1 = 0;
        int par2 = 0;
        int par4 = 16;
        int par5 = 16;
        double zLevel = 0.0;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), zLevel, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), zLevel, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), zLevel, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), zLevel, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public String cut(String name, FontRenderer renderer) {
        if (renderer.func_78256_a(name) < 90) {
            return name;
        }
        StringBuilder sum = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (renderer.func_78256_a(sum.toString() + name.charAt(i) + "...") >= 90) {
                return sum.toString() + "...";
            }
            sum.append(name.charAt(i));
        }
        return sum.toString();
    }

    private void renderFluids(CoreUnroutedPipe pipe, double x, double y, double z) {
        DisplayFluidList d;
        PipeFluidTransportLogistics trans = (PipeFluidTransportLogistics)pipe.transport;
        boolean needsRender = false;
        for (int i = 0; i < 7; ++i) {
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayFluidList d2;
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0 || (d2 = this.getListFromBuffer(fluidStack, pipe.container.func_145831_w())) == null) continue;
            int stage = (int)((float)fluidStack.amount / (float)trans.getSideCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_147499_a(TextureMap.field_110575_b);
            FluidRenderer.setColorForFluidStack(fluidStack);
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        FluidStack fluidStack = trans.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (fluidStack != null && fluidStack.amount > 0 && (d = this.getListFromBuffer(fluidStack, pipe.container.func_145831_w())) != null) {
            int stage = (int)((float)fluidStack.amount / (float)trans.getInnerCapacity() * 39.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            FluidRenderer.setColorForFluidStack(fluidStack);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayFluidList getListFromBuffer(FluidStack stack, World world) {
        int liquidId = stack.fluidID;
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayFluidLists(liquidId, world);
    }

    private DisplayFluidList getDisplayFluidLists(int liquidId, World world) {
        if (this.displayFluidLists.containsKey(liquidId)) {
            return this.displayFluidLists.get(liquidId);
        }
        DisplayFluidList d = new DisplayFluidList();
        this.displayFluidLists.put(liquidId, d);
        CustomBlockRenderer.RenderInfo block = new CustomBlockRenderer.RenderInfo();
        Fluid fluid = FluidRegistry.getFluid((int)liquidId);
        block.baseBlock = fluid.getBlock();
        block.texture = fluid.getStillIcon();
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    private class DisplayFluidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayFluidList() {
        }
    }
}

