/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import java.lang.reflect.Field;
import logisticspipes.LPConstants;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.SlotFinderNumberPacket;
import logisticspipes.proxy.MainProxy;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Slot;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LogisticsGuiOverrenderer {
    private static LogisticsGuiOverrenderer instance = new LogisticsGuiOverrenderer();
    private int oldX;
    private int oldY;
    private boolean hasBeenSaved;
    private boolean clicked;
    private Field fX;
    private Field fY;
    private int targetPosX;
    private int targetPosY;
    private int targetPosZ;
    private int pipePosX;
    private int pipePosY;
    private int pipePosZ;
    private LogisticsModule.ModulePositionType positionType;
    private int positionInt;
    private int slot;
    private boolean isOverlaySlotActive;

    private LogisticsGuiOverrenderer() {
        block2: {
            try {
                this.fX = Mouse.class.getDeclaredField("x");
                this.fY = Mouse.class.getDeclaredField("y");
                this.fX.setAccessible(true);
                this.fY.setAccessible(true);
            }
            catch (Exception e) {
                if (!LPConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public boolean isCompatibleGui() {
        if (FMLClientHandler.instance() == null) {
            return false;
        }
        if (FMLClientHandler.instance().getClient() == null) {
            return false;
        }
        return FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer;
    }

    public void preRender() {
        if (this.isOverlaySlotActive) {
            block4: {
                this.oldX = Mouse.getX();
                this.oldY = Mouse.getY();
                try {
                    this.fX.set(null, 0);
                    this.fY.set(null, 0);
                    this.hasBeenSaved = true;
                }
                catch (Exception e) {
                    if (!LPConstants.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            while (Mouse.next()) {
                if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState()) continue;
                this.clicked = true;
            }
        }
    }

    public void renderOverGui() {
        block5: {
            if (this.hasBeenSaved) {
                this.hasBeenSaved = false;
                try {
                    this.fX.set(null, this.oldX);
                    this.fY.set(null, this.oldY);
                }
                catch (Exception e) {
                    if (!LPConstants.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        if (this.isOverlaySlotActive) {
            GuiContainer gui = (GuiContainer)FMLClientHandler.instance().getClient().field_71462_r;
            int guiTop = gui.field_147009_r;
            int guiLeft = gui.field_147003_i;
            int x = this.oldX * gui.field_146294_l / FMLClientHandler.instance().getClient().field_71443_c;
            int y = gui.field_146295_m - this.oldY * gui.field_146295_m / FMLClientHandler.instance().getClient().field_71440_d - 1;
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                if (!this.isMouseOverSlot(gui, slot, x, y)) continue;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glTranslated((double)guiLeft, (double)guiTop, (double)0.0);
                int k1 = slot.field_75223_e;
                int i1 = slot.field_75221_f;
                this.drawGradientRect(k1, i1, k1 + 16, i1 + 16, -1593901056, -1593901056);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                if (!this.clicked) break;
                MainProxy.sendPacketToServer(PacketHandler.getPacket(SlotFinderNumberPacket.class).setInventorySlot(slot.field_75222_d).setSlot(this.slot).setPipePosX(this.pipePosX).setPipePosY(this.pipePosY).setPipePosZ(this.pipePosZ).setType(this.positionType).setPositionInt(this.positionInt).setPosX(this.targetPosX).setPosY(this.targetPosY).setPosZ(this.targetPosZ));
                this.clicked = false;
                FMLClientHandler.instance().getClient().field_71439_g.func_71053_j();
                this.isOverlaySlotActive = false;
                break;
            }
            this.clicked = false;
        }
    }

    protected void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)par3, (double)par2, 0.0);
        tessellator.func_78377_a((double)par1, (double)par2, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)par1, (double)par4, 0.0);
        tessellator.func_78377_a((double)par3, (double)par4, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private boolean isMouseOverSlot(GuiContainer gui, Slot par1Slot, int par2, int par3) {
        return this.isPointInRegion(gui, par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, par2, par3);
    }

    private boolean isPointInRegion(GuiContainer gui, int par1, int par2, int par3, int par4, int par5, int par6) {
        int k1 = gui.field_147003_i;
        int l1 = gui.field_147009_r;
        return (par5 -= k1) >= par1 - 1 && par5 < par1 + par3 + 1 && (par6 -= l1) >= par2 - 1 && par6 < par2 + par4 + 1;
    }

    public static LogisticsGuiOverrenderer getInstance() {
        return instance;
    }

    public void setTargetPosX(int targetPosX) {
        this.targetPosX = targetPosX;
    }

    public void setTargetPosY(int targetPosY) {
        this.targetPosY = targetPosY;
    }

    public void setTargetPosZ(int targetPosZ) {
        this.targetPosZ = targetPosZ;
    }

    public void setPipePosX(int pipePosX) {
        this.pipePosX = pipePosX;
    }

    public void setPipePosY(int pipePosY) {
        this.pipePosY = pipePosY;
    }

    public void setPipePosZ(int pipePosZ) {
        this.pipePosZ = pipePosZ;
    }

    public void setPositionType(LogisticsModule.ModulePositionType positionType) {
        this.positionType = positionType;
    }

    public void setPositionInt(int positionInt) {
        this.positionInt = positionInt;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setOverlaySlotActive(boolean isOverlaySlotActive) {
        this.isOverlaySlotActive = isOverlaySlotActive;
    }
}

