/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.thaumcraft;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.ICraftingParts;
import logisticspipes.proxy.interfaces.IThaumCraftProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ScanManager;

public class ThaumCraftProxy
implements IThaumCraftProxy {
    private Item itemShard;

    public ThaumCraftProxy() throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Class<?> tcConfig = Class.forName("thaumcraft.common.config.ConfigItems");
        this.itemShard = (Item)tcConfig.getField("itemShard").get(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAspectsDown(ItemStack item, int x, int y, GuiScreen gui) {
        GL11.glPushMatrix();
        AspectList tags = this.getTagsForStack(item);
        tags = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)item, (AspectList)tags);
        if (tags != null) {
            int index = 0;
            for (Aspect tag : tags.getAspectsSortedAmount()) {
                if (tag == null) continue;
                int yPos = y + index * 18;
                this.renderAspectAt(tag, x, yPos, gui, tags.getAmount(tag), true);
                ++index;
            }
        }
        GL11.glPopMatrix();
    }

    private AspectList getTagsForStack(ItemStack stack) {
        if (stack == null) {
            return new AspectList();
        }
        AspectList ot = ThaumcraftApiHelper.getObjectAspects((ItemStack)stack);
        ot = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)stack, (AspectList)ot);
        return ot;
    }

    private void renderAspectAt(Aspect tag, int x, int y, GuiScreen gui, int amount, boolean drawBackground) {
        if (!(tag instanceof Aspect)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (drawBackground) {
            UtilsFX.bindTexture((String)"textures/aspects/_back.png");
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslated((double)(x - 2), (double)(y - 2), (double)0.0);
            GL11.glScaled((double)1.25, (double)1.25, (double)0.0);
            UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)gui.field_73735_i);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(mc.field_71439_g.getDisplayName(), tag)) {
            UtilsFX.drawTag((int)x, (int)y, (Aspect)tag, (float)amount, (int)0, (double)gui.field_73735_i);
        } else {
            UtilsFX.bindTexture((String)"textures/aspects/_unknown.png");
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslated((double)x, (double)y, (double)0.0);
            UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)gui.field_73735_i);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAspectsInGrid(List<String> etagIDs, int x, int y, int legnth, int width, GuiScreen gui) {
        if (etagIDs.size() == 0) {
            return;
        }
        int xshift = x;
        int yshift = y;
        int currentListIndex = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < legnth; ++j) {
                this.renderAspectAt(Aspect.getAspect((String)etagIDs.get(currentListIndex)), xshift, yshift, gui, 0, false);
                if (++currentListIndex == etagIDs.size()) {
                    return;
                }
                xshift += 18;
            }
            xshift = x;
            yshift += 18;
        }
    }

    @Override
    public List<String> getListOfTagsForStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        AspectList tags = this.getTagsForStack(stack);
        Aspect[] tagArray = tags.getAspectsSorted();
        if (tagArray.length == 0 || tagArray == null) {
            return null;
        }
        for (int i = 0; i < tagArray.length; ++i) {
            if (tagArray[i] == null) continue;
            list.add(tagArray[i].getTag());
        }
        return list;
    }

    @Override
    public void addCraftingRecipes(ICraftingParts parts) {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 30), new Object[]{"wGe", "rBr", "fra", Character.valueOf('w'), new ItemStack(this.itemShard, 1, 2), Character.valueOf('e'), new ItemStack(this.itemShard, 1, 3), Character.valueOf('f'), new ItemStack(this.itemShard, 1, 1), Character.valueOf('a'), new ItemStack(this.itemShard, 1, 0), Character.valueOf('G'), parts.getChipTear1(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
    }

    @Override
    public boolean isScannedObject(ItemStack stack, String playerName) {
        int h = ScanManager.generateItemHash((Item)stack.func_77973_b(), (int)stack.func_77960_j());
        List list = (List)Thaumcraft.proxy.getScannedObjects().get(playerName);
        return list != null && (list.contains("@" + h) || list.contains("#" + h));
    }
}

