/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialtankhandler;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.FluidIdentifier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class AETankHandler
implements ISpecialTankAccessHandler {
    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof ITileStorageMonitorable && tile instanceof IGridHost;
    }

    @Override
    public List<TileEntity> getBaseTilesFor(TileEntity tile) {
        TileEntity base;
        IGridHost host;
        IGridNode node;
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>(1);
        if (tile instanceof IGridHost && (node = (host = (IGridHost)tile).getGridNode(ForgeDirection.UNKNOWN)) != null && (base = this.getBaseTileEntity(node)) != null) {
            tiles.add(base);
            return tiles;
        }
        tiles.add(tile);
        return tiles;
    }

    @Override
    public Map<FluidIdentifier, Long> getAvailableLiquid(TileEntity tile) {
        HashMap<FluidIdentifier, Long> map = new HashMap<FluidIdentifier, Long>();
        if (tile instanceof ITileStorageMonitorable) {
            ITileStorageMonitorable mon = (ITileStorageMonitorable)tile;
            if (mon == null) {
                return map;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                MachineSource source = new MachineSource((IActionHost)new LPActionHost(((IGridHost)tile).getGridNode(dir)));
                IStorageMonitorable monitor = mon.getMonitorable(dir, (BaseActionSource)source);
                if (monitor == null || monitor.getFluidInventory() == null) continue;
                IMEMonitor fluids = monitor.getFluidInventory();
                for (IAEFluidStack stack : fluids.getStorageList()) {
                    if (!SimpleServiceLocator.extraCellsProxy.canSeeFluidInNetwork(stack.getFluid())) continue;
                    map.put(FluidIdentifier.get(stack.getFluid().getID(), stack.getTagCompound() != null ? stack.getTagCompound().getNBTTagCompoundCopy() : null), stack.getStackSize());
                }
                return map;
            }
        }
        return map;
    }

    @Override
    public FluidStack drainFrom(TileEntity tile, FluidIdentifier ident, Integer amount, boolean drain) {
        if (tile instanceof ITileStorageMonitorable) {
            ITileStorageMonitorable mon = (ITileStorageMonitorable)tile;
            if (mon == null) {
                return null;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IAEFluidStack s;
                MachineSource source = new MachineSource((IActionHost)new LPActionHost(((IGridHost)tile).getGridNode(dir)));
                IStorageMonitorable monitor = mon.getMonitorable(dir, (BaseActionSource)source);
                if (monitor == null || monitor.getFluidInventory() == null) continue;
                IMEMonitor fluids = monitor.getFluidInventory();
                IAEFluidStack extracted = (IAEFluidStack)fluids.extractItems((IAEStack)(s = AEApi.instance().storage().createFluidStack(ident.makeFluidStack(amount))), drain ? Actionable.MODULATE : Actionable.SIMULATE, (BaseActionSource)source);
                if (extracted == null) {
                    return null;
                }
                return extracted.getFluidStack();
            }
        }
        return null;
    }

    private TileEntity getBaseTileEntity(IGridNode node) {
        IGrid grid = node.getGrid();
        if (grid == null) {
            return null;
        }
        IGridNode pivot = grid.getPivot();
        if (pivot == null) {
            return null;
        }
        IGridBlock block = pivot.getGridBlock();
        if (block == null) {
            return null;
        }
        DimensionalCoord coord = block.getLocation();
        if (coord == null) {
            return null;
        }
        World world = coord.getWorld();
        if (world == null) {
            return null;
        }
        return world.func_147438_o(coord.x, coord.y, coord.z);
    }

    private class LPActionHost
    implements IActionHost {
        public IGridNode node;

        public LPActionHost(IGridNode node) {
            this.node = node;
        }

        public void securityBreak() {
        }

        public IGridNode getGridNode(ForgeDirection paramForgeDirection) {
            return null;
        }

        public AECableType getCableConnectionType(ForgeDirection paramForgeDirection) {
            return null;
        }

        public IGridNode getActionableNode() {
            return this.node;
        }
    }
}

