/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.opencomputers;

import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.interfaces.IOpenComputersProxy;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class OpenComputersProxy
implements IOpenComputersProxy {
    @Override
    public void initLogisticsTileGenericPipe(LogisticsTileGenericPipe tile) {
        tile.node = Network.newNode((Environment)tile, (Visibility)Visibility.Neighbors).withComponent("logisticspipe", Visibility.Neighbors).create();
    }

    @Override
    public void addToNetwork(LogisticsTileGenericPipe tile) {
        Network.joinOrCreateNetwork((TileEntity)tile);
    }

    @Override
    public void handleLPInvalidate(LogisticsTileGenericPipe tile) {
        if (tile.node != null) {
            tile.node.remove();
        }
    }

    @Override
    public void handleLPChunkUnload(LogisticsTileGenericPipe tile) {
        if (tile.node != null) {
            tile.node.remove();
        }
    }

    @Override
    public void handleLPReadFromNBT(LogisticsTileGenericPipe tile, NBTTagCompound nbt) {
        if (tile.node != null && tile.node.host() == tile) {
            tile.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    @Override
    public void handleLPWriteToNBT(LogisticsTileGenericPipe tile, NBTTagCompound nbt) {
        if (tile.node != null && tile.node.host() == tile) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            tile.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }
}

