/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.Recipes;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.interfaces.ICraftingParts;
import logisticspipes.proxy.interfaces.IIC2Proxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class IC2Proxy
implements IIC2Proxy {
    @Override
    public boolean isElectricItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IElectricItem;
    }

    @Override
    public boolean isSimilarElectricItem(ItemStack stack, ItemStack template) {
        if (stack == null || template == null || !this.isElectricItem(template)) {
            return false;
        }
        if (((IElectricItem)template.func_77973_b()).getEmptyItem(stack) == stack.func_77973_b()) {
            return true;
        }
        return ((IElectricItem)template.func_77973_b()).getChargedItem(stack) == stack.func_77973_b();
    }

    private double getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof IElectricItem && stack.func_77942_o()) {
            return stack.func_77978_p().func_74769_h("charge");
        }
        return 0.0;
    }

    private double getMaxCharge(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IElectricItem)) {
            return 0.0;
        }
        return ((IElectricItem)stack.func_77973_b()).getMaxCharge(stack);
    }

    @Override
    public boolean isFullyCharged(ItemStack stack) {
        double maxCharge;
        if (!this.isElectricItem(stack)) {
            return false;
        }
        if (((IElectricItem)stack.func_77973_b()).getChargedItem(stack) != stack.func_77973_b()) {
            return false;
        }
        double charge = this.getCharge(stack);
        return charge == (maxCharge = this.getMaxCharge(stack));
    }

    @Override
    public boolean isFullyDischarged(ItemStack stack) {
        if (!this.isElectricItem(stack)) {
            return false;
        }
        if (((IElectricItem)stack.func_77973_b()).getEmptyItem(stack) != stack.func_77973_b()) {
            return false;
        }
        double charge = this.getCharge(stack);
        return charge == 0.0;
    }

    @Override
    public boolean isPartiallyCharged(ItemStack stack) {
        double maxCharge;
        if (!this.isElectricItem(stack)) {
            return false;
        }
        if (((IElectricItem)stack.func_77973_b()).getChargedItem(stack) != stack.func_77973_b()) {
            return false;
        }
        double charge = this.getCharge(stack);
        return charge != (maxCharge = this.getMaxCharge(stack));
    }

    @Override
    public void addCraftingRecipes(ICraftingParts parts) {
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 301), new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('G'), parts.getGearTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 301), new Object[]{" G ", "rBr", "CrC", Character.valueOf('C'), IC2Items.getItem((String)"advancedCircuit"), Character.valueOf('G'), parts.getChipTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 300), new Object[]{"CGD", "rBr", "DrC", Character.valueOf('C'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"reBattery"), Character.valueOf('G'), parts.getGearTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 300), new Object[]{"CGD", "rBr", "DrC", Character.valueOf('C'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"chargedReBattery"), Character.valueOf('G'), parts.getGearTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 300), new Object[]{"CGc", "rBr", "DrC", Character.valueOf('C'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('c'), IC2Items.getItem((String)"reBattery"), Character.valueOf('D'), IC2Items.getItem((String)"chargedReBattery"), Character.valueOf('G'), parts.getGearTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 300), new Object[]{"CGc", "rBr", "DrC", Character.valueOf('C'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('c'), IC2Items.getItem((String)"chargedReBattery"), Character.valueOf('D'), IC2Items.getItem((String)"reBattery"), Character.valueOf('G'), parts.getGearTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 300), new Object[]{" G ", "rBr", "DrC", Character.valueOf('C'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"reBattery"), Character.valueOf('G'), parts.getChipTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 300), new Object[]{" G ", "rBr", "DrC", Character.valueOf('C'), IC2Items.getItem((String)"electronicCircuit"), Character.valueOf('D'), IC2Items.getItem((String)"chargedReBattery"), Character.valueOf('G'), parts.getChipTear2(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.ModuleItem, 1, 0)});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 33), new Object[]{"PSP", "OBO", "PTP", Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 30), Character.valueOf('S'), IC2Items.getItem((String)"energyStorageUpgrade"), Character.valueOf('O'), IC2Items.getItem((String)"overclockerUpgrade"), Character.valueOf('T'), IC2Items.getItem((String)"transformerUpgrade"), Character.valueOf('P'), Items.field_151121_aF});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 34), new Object[]{"PSP", "OBO", "PTP", Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 33), Character.valueOf('S'), IC2Items.getItem((String)"energyStorageUpgrade"), Character.valueOf('O'), IC2Items.getItem((String)"overclockerUpgrade"), Character.valueOf('T'), IC2Items.getItem((String)"transformerUpgrade"), Character.valueOf('P'), Items.field_151121_aF});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 35), new Object[]{"PSP", "OBO", "PTP", Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 34), Character.valueOf('S'), IC2Items.getItem((String)"energyStorageUpgrade"), Character.valueOf('O'), IC2Items.getItem((String)"overclockerUpgrade"), Character.valueOf('T'), IC2Items.getItem((String)"transformerUpgrade"), Character.valueOf('P'), Items.field_151121_aF});
        Recipes.advRecipes.addRecipe(new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 36), new Object[]{"PSP", "OBO", "PTP", Character.valueOf('B'), new ItemStack((Item)LogisticsPipes.UpgradeItem, 1, 35), Character.valueOf('S'), IC2Items.getItem((String)"energyStorageUpgrade"), Character.valueOf('O'), IC2Items.getItem((String)"overclockerUpgrade"), Character.valueOf('T'), IC2Items.getItem((String)"transformerUpgrade"), Character.valueOf('P'), Items.field_151121_aF});
        Recipes.advRecipes.addRecipe(new ItemStack(LogisticsPipes.LogisticsSolidBlock, 1, 12), new Object[]{"PSP", "OBO", "PTP", Character.valueOf('B'), Blocks.field_150451_bX, Character.valueOf('S'), IC2Items.getItem((String)"energyStorageUpgrade"), Character.valueOf('O'), IC2Items.getItem((String)"overclockerUpgrade"), Character.valueOf('T'), IC2Items.getItem((String)"transformerUpgrade"), Character.valueOf('P'), Items.field_151121_aF});
    }

    @Override
    public void registerToEneryNet(TileEntity tile) {
        if (MainProxy.isServer(tile.func_145831_w())) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)tile));
        }
    }

    @Override
    public void unregisterToEneryNet(TileEntity tile) {
        if (MainProxy.isServer(tile.func_145831_w())) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)tile));
        }
    }

    @Override
    public boolean hasIC2() {
        return true;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity energy, TileEntity tile, ForgeDirection opposite) {
        return ((IEnergySink)energy).acceptsEnergyFrom(tile, opposite);
    }

    @Override
    public boolean isEnergySink(TileEntity tile) {
        return tile instanceof IEnergySink;
    }

    @Override
    public double demandedEnergyUnits(TileEntity tile) {
        return ((IEnergySink)tile).getDemandedEnergy();
    }

    @Override
    public double injectEnergyUnits(TileEntity tile, ForgeDirection opposite, double d) {
        return ((IEnergySink)tile).injectEnergy(opposite, d, 1.0);
    }
}

