/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft.subproxies;

import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.render.FakeBlock;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePart;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePluggable;
import logisticspipes.proxy.buildcraft.subproxies.IBCPluggableState;
import logisticspipes.proxy.buildcraft.subproxies.IBCRenderState;
import logisticspipes.proxy.buildcraft.subproxies.IBCTilePart;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPipe;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPipeRenderState;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPluggableState;
import logisticspipes.utils.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPBCTileGenericPipe
extends TileGenericPipe
implements IBCTilePart {
    private final LPBCPipe bcPipe;
    private final LPBCPluggableState bcPlugState;
    private final LPBCPipeRenderState bcRenderState;
    private final LogisticsTileGenericPipe lpPipe;
    private boolean blockPluggableAccess = false;

    public LPBCTileGenericPipe(LPBCPipe pipe, LogisticsTileGenericPipe lpPipe) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.bcPipe = pipe;
        this.pipe = this.bcPipe;
        this.bcPipe.setTile((TileEntity)this);
        this.lpPipe = lpPipe;
        this.bcPlugState = new LPBCPluggableState();
        this.bcRenderState = new LPBCPipeRenderState();
        ReflectionHelper.setFinalField(TileGenericPipe.class, "pluggableState", this, this.bcPlugState);
        ReflectionHelper.setFinalField(TileGenericPipe.class, "renderState", this, this.bcRenderState);
    }

    @Override
    public void writeToNBT_LP(NBTTagCompound nbt) {
        NBTTagCompound bcNBT = new NBTTagCompound();
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            bcNBT.func_74774_a(key, (byte)this.redstoneInputSide[i]);
        }
        this.pipe.writeToNBT(bcNBT);
        this.sideProperties.writeToNBT(bcNBT);
        nbt.func_74782_a("BC_Pipe_NBT", (NBTBase)bcNBT);
    }

    @Override
    public void readFromNBT_LP(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("BC_Pipe_NBT")) {
            this.redstoneInput = 0;
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                String key = "redstoneInputSide[" + i + "]";
                if (nbt.func_74764_b(key)) {
                    this.redstoneInputSide[i] = nbt.func_74771_c(key);
                    if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                    this.redstoneInput = this.redstoneInputSide[i];
                    continue;
                }
                this.redstoneInputSide[i] = 0;
            }
            this.pipe.readFromNBT(nbt);
            this.pipeBound = true;
            this.sideProperties.readFromNBT(nbt);
            this.attachPluggables = true;
            return;
        }
        NBTTagCompound bcNBT = nbt.func_74775_l("BC_Pipe_NBT");
        this.redstoneInput = 0;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (bcNBT.func_74764_b(key)) {
                this.redstoneInputSide[i] = bcNBT.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
        this.pipeBound = true;
        this.pipe.readFromNBT(bcNBT);
        this.sideProperties.readFromNBT(bcNBT);
        this.attachPluggables = true;
    }

    @Override
    public void invalidate_LP() {
        this.func_145843_s();
    }

    @Override
    public void validate_LP() {
        this.func_145829_t();
    }

    @Override
    public void updateEntity_LP() {
        this.field_145851_c = this.lpPipe.field_145851_c;
        this.field_145848_d = this.lpPipe.field_145848_d;
        this.field_145849_e = this.lpPipe.field_145849_e;
        if (this.attachPluggables) {
            this.attachPluggables = false;
            PipePluggable[] pluggables = ReflectionHelper.getPrivateField(PipePluggable[].class, TileGenericPipe.SideProperties.class, "pluggables", this.sideProperties);
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                if (pluggables[i] == null) continue;
                this.pipe.eventBus.registerHandler((Object)pluggables[i]);
                pluggables[i].onAttachedPipe((IPipeTile)this, ForgeDirection.getOrientation((int)i));
            }
            this.notifyBlockChanged();
        }
        if (!BlockGenericPipe.isValid((Pipe)this.pipe)) {
            return;
        }
        this.pipe.updateEntity();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            PipePluggable p = this.getPipePluggable(direction);
            if (p == null) continue;
            p.update((IPipeTile)this, direction);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.resyncGateExpansions) {
                ReflectionHelper.invokePrivateMethod(Object.class, TileGenericPipe.class, this, "syncGateExpansions", new Class[0], new Object[0]);
            }
            return;
        }
        if (this.blockNeighborChange) {
            ReflectionHelper.invokePrivateMethod(Object.class, TileGenericPipe.class, this, "computeConnections", new Class[0], new Object[0]);
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
    }

    @Override
    public IBCRenderState getBCRenderState() {
        return this.bcRenderState;
    }

    @Override
    public IBCPipePart getBCPipePart() {
        return this.bcPipe;
    }

    @Override
    public IBCPluggableState getBCPlugableState() {
        return this.bcPlugState;
    }

    @Override
    public void readOldRedStone(NBTTagCompound nbt) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (nbt.func_74764_b(key)) {
                this.redstoneInputSide[i] = nbt.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
    }

    @Override
    public IBCPipePluggable getBCPipePluggable(final ForgeDirection sideHit) {
        final PipePluggable plug = this.getPipePluggable(sideHit);
        if (plug == null) {
            return null;
        }
        return new IBCPipePluggable(){

            @Override
            public ItemStack[] getDropItems(LogisticsTileGenericPipe container) {
                return plug.getDropItems((IPipeTile)container);
            }

            @Override
            public boolean isBlocking() {
                return plug.isBlocking((IPipeTile)LPBCTileGenericPipe.this.pipe.container, sideHit);
            }

            @Override
            public Object getOriginal() {
                return plug;
            }

            @Override
            public void renderPluggable(RenderBlocks renderblocks, ForgeDirection dir, int renderPass, int x, int y, int z) {
                if (plug.getRenderer() == null) {
                    return;
                }
                plug.getRenderer().renderPluggable(renderblocks, (IPipe)LPBCTileGenericPipe.this.bcPipe, dir, plug, (ITextureStates)FakeBlock.INSTANCE, renderPass, x, y, z);
            }
        };
    }

    public PipePluggable getPipePluggable(ForgeDirection side) {
        StackTraceElement[] trace;
        if (this.blockPluggableAccess && (trace = Thread.currentThread().getStackTrace()).length > 2 && (trace[2].getMethodName().equals("onBlockActivated") || trace[2].getMethodName().equals("func_149727_a")) && trace[2].getClassName().equals("buildcraft.transport.BlockGenericPipe") && trace[2].getLineNumber() > 680) {
            return null;
        }
        return super.getPipePluggable(side);
    }

    @Override
    public void disablePluggableAccess() {
        this.blockPluggableAccess = true;
    }

    @Override
    public void reenablePluggableAccess() {
        this.blockPluggableAccess = false;
    }

    @Override
    public void afterStateUpdated() {
        if (this.field_145850_b == null) {
            this.field_145850_b = this.lpPipe.func_145831_w();
        }
        this.afterStateUpdated((byte)2);
    }

    @Override
    public Object getOriginal() {
        return this;
    }

    public Block getBlock(ForgeDirection to) {
        return this.lpPipe.getBlock(to);
    }

    public TileEntity getTile(ForgeDirection to) {
        return this.lpPipe.getTile(to);
    }

    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        this.lpPipe.sendUpdateToClient();
    }

    @Override
    public void setWorldObj_LP(World world) {
        this.func_145834_a(world);
        this.field_145851_c = this.lpPipe.field_145851_c;
        this.field_145848_d = this.lpPipe.field_145848_d;
        this.field_145849_e = this.lpPipe.field_145849_e;
    }

    public IPipeTile.PipeType getPipeType() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length > 2 && trace[2].getClassName().equals("buildcraft.transport.pluggable.ItemLens") && trace[2].getMethodName().equals("createPipePluggable")) {
            return IPipeTile.PipeType.ITEM;
        }
        return IPipeTile.PipeType.STRUCTURE;
    }

    public boolean isPipeConnected(ForgeDirection with) {
        return this.lpPipe.isPipeConnected(with);
    }
}

