/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft;

import buildcraft.BuildCraftSilicon;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.Version;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.render.FacadeRenderHelper;
import buildcraft.transport.render.FakeBlock;
import buildcraft.transport.render.PipeRendererTESR;
import buildcraft.transport.render.PipeRendererWorld;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import logisticspipes.LogisticsPipes;
import logisticspipes.pipes.PipeItemsFluidSupplier;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.VersionNotSupportedException;
import logisticspipes.proxy.buildcraft.BCPipeInformationProvider;
import logisticspipes.proxy.buildcraft.LPRoutedBCTravelingItem;
import logisticspipes.proxy.buildcraft.gates.ActionDisableLogistics;
import logisticspipes.proxy.buildcraft.gates.LogisticsTriggerProvider;
import logisticspipes.proxy.buildcraft.gates.TriggerCrafting;
import logisticspipes.proxy.buildcraft.gates.TriggerHasDestination;
import logisticspipes.proxy.buildcraft.gates.TriggerNeedsPower;
import logisticspipes.proxy.buildcraft.gates.TriggerSupplierFailed;
import logisticspipes.proxy.buildcraft.recipeprovider.AssemblyTable;
import logisticspipes.proxy.buildcraft.subproxies.IBCClickResult;
import logisticspipes.proxy.buildcraft.subproxies.IBCRenderTESR;
import logisticspipes.proxy.buildcraft.subproxies.IBCTilePart;
import logisticspipes.proxy.buildcraft.subproxies.IConnectionOverrideResult;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPipe;
import logisticspipes.proxy.buildcraft.subproxies.LPBCPipeTransportsItems;
import logisticspipes.proxy.buildcraft.subproxies.LPBCTileGenericPipe;
import logisticspipes.proxy.interfaces.IBCProxy;
import logisticspipes.proxy.interfaces.ICraftingParts;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.ReflectionHelper;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BuildCraftProxy
implements IBCProxy {
    public static ITriggerInternal LogisticsFailedTrigger;
    public static ITriggerInternal LogisticsCraftingTrigger;
    public static ITriggerExternal LogisticsNeedPowerTrigger;
    public static ITriggerInternal LogisticsHasDestinationTrigger;
    public static IActionInternal LogisticsDisableAction;
    private Method canPipeConnect;
    public IPipeTile.PipeType logisticsPipeType;

    public BuildCraftProxy() {
        String BCVersion = null;
        try {
            Field versionField = Version.class.getDeclaredField("VERSION");
            BCVersion = (String)versionField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (BCVersion != null && !BCVersion.equals("@VERSION@")) {
            if (!BCVersion.contains("6.3") || BCVersion.contains("6.3.0") || BCVersion.contains("6.3.1")) {
                throw new VersionNotSupportedException("BC", BCVersion, "6.3.2", "");
            }
            if (!BCVersion.contains("6.3.2")) {
                LogisticsPipes.log.error("The BC version you are using is untested with this LP version. It may work but it could also destroy your world. Use at your own risk. Recommanded BC version for this LP version is BC 6.2.0");
            }
        } else {
            LogisticsPipes.log.info("Couldn't check the BC Version.");
        }
    }

    @Override
    public void resetItemRotation() {
        try {
            Object renderer = TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(TileGenericPipe.class);
            Field f = PipeRendererTESR.class.getDeclaredField("dummyEntityItem");
            f.setAccessible(true);
            EntityItem item = (EntityItem)f.get(renderer);
            item.field_70290_d = 0.0f;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean insertIntoBuildcraftPipe(TileEntity tile, LPTravelingItem item) {
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (BlockGenericPipe.isValid((Pipe)pipe.pipe) && pipe.pipe.transport instanceof PipeTransportItems) {
                LPRoutedBCTravelingItem bcItem = null;
                if (!(item instanceof LPTravelingItem.LPTravelingItemServer)) {
                    return true;
                }
                LPRoutedBCTravelingItem lpBCItem = new LPRoutedBCTravelingItem();
                lpBCItem.setRoutingInformation(((LPTravelingItem.LPTravelingItemServer)item).getInfo());
                lpBCItem.saveToExtraNBTData();
                bcItem = lpBCItem;
                LPPosition p = new LPPosition((float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.25f, (float)tile.field_145849_e + 0.5f);
                if (item.output.getOpposite() == ForgeDirection.DOWN) {
                    p.moveForward(item.output.getOpposite(), 0.24f);
                } else if (item.output.getOpposite() == ForgeDirection.UP) {
                    p.moveForward(item.output.getOpposite(), 0.74f);
                } else {
                    p.moveForward(item.output.getOpposite(), 0.49f);
                }
                bcItem.setPosition(p.getXD(), p.getYD(), p.getZD());
                bcItem.setSpeed(item.getSpeed());
                if (item.getItemIdentifierStack() != null) {
                    bcItem.setItemStack(item.getItemIdentifierStack().makeNormalStack());
                }
                ((PipeTransportItems)pipe.pipe.transport).injectItem((TravelingItem)bcItem, item.output);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIPipeTile(TileEntity tile) {
        return tile instanceof IPipeTile;
    }

    @Override
    public void registerPipeInformationProvider() {
        SimpleServiceLocator.pipeInformaitonManager.registerProvider(TileGenericPipe.class, BCPipeInformationProvider.class);
    }

    @Override
    public void initProxy() {
        try {
            this.canPipeConnect = TileGenericPipe.class.getDeclaredMethod("canPipeConnect", TileEntity.class, ForgeDirection.class);
            this.canPipeConnect.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkForPipeConnection(TileEntity with, ForgeDirection side, LogisticsTileGenericPipe pipe) {
        if (with instanceof TileGenericPipe) {
            if (ReflectionHelper.invokePrivateMethodCatched(Boolean.class, TileGenericPipe.class, with, "hasBlockingPluggable", new Class[]{ForgeDirection.class}, new Object[]{side.getOpposite()}).booleanValue()) {
                return false;
            }
            Pipe otherPipe = ((TileGenericPipe)with).pipe;
            if (!BlockGenericPipe.isValid((Pipe)otherPipe)) {
                return false;
            }
            if (!(otherPipe.transport instanceof PipeTransportItems)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public IConnectionOverrideResult checkConnectionOverride(TileEntity with, ForgeDirection side, LogisticsTileGenericPipe pipe) {
        if (with instanceof IPipeConnection) {
            IPipeConnection.ConnectOverride override = ((IPipeConnection)with).overridePipeConnection(IPipeTile.PipeType.ITEM, side.getOpposite());
            if (override == IPipeConnection.ConnectOverride.DISCONNECT) {
                if (pipe.pipe.transport instanceof PipeFluidTransportLogistics || pipe.pipe instanceof PipeItemsFluidSupplier) {
                    override = ((IPipeConnection)with).overridePipeConnection(IPipeTile.PipeType.FLUID, side.getOpposite());
                }
                if (override == IPipeConnection.ConnectOverride.DISCONNECT && pipe.getCPipe().getUpgradeManager().hasRFPowerSupplierUpgrade()) {
                    override = ((IPipeConnection)with).overridePipeConnection(IPipeTile.PipeType.POWER, side.getOpposite());
                }
            }
            if (override == IPipeConnection.ConnectOverride.DISCONNECT) {
                return new IConnectionOverrideResult(){

                    @Override
                    public boolean forceConnect() {
                        return false;
                    }

                    @Override
                    public boolean forceDisconnect() {
                        return true;
                    }
                };
            }
            if (override == IPipeConnection.ConnectOverride.CONNECT) {
                return new IConnectionOverrideResult(){

                    @Override
                    public boolean forceConnect() {
                        return true;
                    }

                    @Override
                    public boolean forceDisconnect() {
                        return false;
                    }
                };
            }
        }
        return new IConnectionOverrideResult(){

            @Override
            public boolean forceConnect() {
                return false;
            }

            @Override
            public boolean forceDisconnect() {
                return false;
            }
        };
    }

    @Override
    public boolean canPipeConnect(TileEntity pipe, TileEntity with, ForgeDirection side) {
        if (this.canPipeConnect == null) {
            this.initProxy();
        }
        if (!(pipe instanceof TileGenericPipe)) {
            throw new IllegalArgumentException();
        }
        try {
            return (Boolean)this.canPipeConnect.invoke((Object)pipe, with, side);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public Object getLPPipeType() {
        if (this.logisticsPipeType == null) {
            this.logisticsPipeType = (IPipeTile.PipeType)EnumHelper.addEnum(IPipeTile.PipeType.class, (String)"LOGISTICS", (Class[])new Class[0], (Object[])new Object[0]);
        }
        return this.logisticsPipeType;
    }

    @Override
    public void registerTrigger() {
        StatementManager.registerTriggerProvider((ITriggerProvider)new LogisticsTriggerProvider());
        LogisticsFailedTrigger = new TriggerSupplierFailed();
        LogisticsNeedPowerTrigger = new TriggerNeedsPower();
        LogisticsCraftingTrigger = new TriggerCrafting();
        LogisticsHasDestinationTrigger = new TriggerHasDestination();
        LogisticsDisableAction = new ActionDisableLogistics();
    }

    @Override
    public ICraftingParts getRecipeParts() {
        return new ICraftingParts(){

            @Override
            public ItemStack getChipTear1() {
                return new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 1);
            }

            @Override
            public ItemStack getChipTear2() {
                return new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 2);
            }

            @Override
            public ItemStack getChipTear3() {
                return new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 3);
            }

            @Override
            public Object getGearTear1() {
                return "gearIron";
            }

            @Override
            public Object getGearTear2() {
                return "gearGold";
            }

            @Override
            public Object getGearTear3() {
                return "gearDiamond";
            }

            @Override
            public Object getSortingLogic() {
                return BuildCraftTransport.pipeItemsDiamond;
            }

            @Override
            public Object getBasicTransport() {
                return BuildCraftTransport.pipeItemsCobblestone;
            }

            @Override
            public Object getWaterProof() {
                return BuildCraftTransport.pipeWaterproof;
            }

            @Override
            public Object getExtractorItem() {
                return BuildCraftTransport.pipeItemsWood;
            }

            @Override
            public Object getExtractorFluid() {
                return BuildCraftTransport.pipeFluidsWood;
            }
        };
    }

    @Override
    public void addCraftingRecipes(ICraftingParts parts) {
    }

    @Override
    public Class<? extends ICraftingRecipeProvider> getAssemblyTableProviderClass() {
        return AssemblyTable.class;
    }

    @Override
    public void notifyOfChange(LogisticsTileGenericPipe pipe, TileEntity tile, ForgeDirection o) {
        if (tile instanceof ITileBufferHolder) {
            ((ITileBufferHolder)tile).blockCreated(o, (Block)BuildCraftTransport.genericPipeBlock, (TileEntity)pipe);
        }
        if (tile instanceof TileGenericPipe) {
            ((TileGenericPipe)tile).scheduleNeighborChange();
        }
    }

    @Override
    public IBCTilePart getBCTilePart(LogisticsTileGenericPipe pipe) {
        return new LPBCTileGenericPipe(new LPBCPipe(new LPBCPipeTransportsItems(pipe), pipe), pipe);
    }

    @Override
    public IBCClickResult handleBCClickOnPipe(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset, CoreUnroutedPipe pipe) {
        ItemStack currentItem;
        Enum hitPart;
        BlockGenericPipe.RaytraceResult trace = BuildCraftTransport.genericPipeBlock.doRayTrace(world, x, y, z, player);
        String type = "null";
        if (trace != null && (hitPart = ReflectionHelper.getPrivateField(Enum.class, trace.getClass(), "hitPart", trace)) != null) {
            type = hitPart.name();
        }
        if ("Pluggable".equals(type)) {
            pipe.container.tilePart.disablePluggableAccess();
        }
        final boolean result = BuildCraftTransport.genericPipeBlock.func_149727_a(world, x, y, z, player, side, xOffset, yOffset, zOffset);
        if ("Pluggable".equals(type)) {
            pipe.container.tilePart.reenablePluggableAccess();
        }
        boolean block = false;
        if (!result && (currentItem = player.func_71045_bC()) != null) {
            if (currentItem.func_77973_b() == Items.field_151155_ap) {
                block = true;
            } else if (currentItem.func_77973_b() instanceof ItemPipe) {
                block = true;
            } else if (currentItem.func_77973_b() instanceof ItemGateCopier) {
                block = true;
            } else if (currentItem.func_77973_b() instanceof ItemMapLocation) {
                block = true;
            }
        }
        final boolean fBlock = block;
        return new IBCClickResult(){

            @Override
            public boolean handled() {
                return result;
            }

            @Override
            public boolean blocked() {
                return fBlock;
            }
        };
    }

    @Override
    public void callBCNeighborBlockChange(World world, int x, int y, int z, Block block) {
        BuildCraftTransport.genericPipeBlock.func_149695_a(world, x, y, z, block);
    }

    @Override
    public void callBCRemovePipe(World world, int x, int y, int z) {
        BlockGenericPipe.removePipe((Pipe)BlockGenericPipe.getPipe((IBlockAccess)world, (int)x, (int)y, (int)z));
    }

    @Override
    public void logWarning(String format) {
        BCLog.logger.warn(format);
    }

    @Override
    public IBCRenderTESR getBCRenderTESR() {
        final PipeRendererTESR renderer = new PipeRendererTESR();
        renderer.func_147497_a(TileEntityRendererDispatcher.field_147556_a);
        return new IBCRenderTESR(){

            @Override
            public void renderWires(LogisticsTileGenericPipe pipe, double x, double y, double z) {
                TileGenericPipe tgPipe = (TileGenericPipe)pipe.tilePart.getOriginal();
                ReflectionHelper.invokePrivateMethod(Object.class, PipeRendererTESR.class, renderer, "renderGatesWires", new Class[]{TileGenericPipe.class, Double.TYPE, Double.TYPE, Double.TYPE}, new Object[]{tgPipe, x, y, z});
            }

            @Override
            public void renderGates(LogisticsTileGenericPipe pipe, double x, double y, double z) {
                TileGenericPipe tgPipe = (TileGenericPipe)pipe.tilePart.getOriginal();
                ReflectionHelper.invokePrivateMethod(Object.class, PipeRendererTESR.class, renderer, "renderGates", new Class[]{TileGenericPipe.class, Double.TYPE, Double.TYPE, Double.TYPE}, new Object[]{tgPipe, x, y, z});
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void pipeFacadeRenderer(RenderBlocks renderblocks, LogisticsBlockGenericPipe block, LogisticsTileGenericPipe pipe, int x, int y, int z, int renderPass) {
        TileGenericPipe tile = (TileGenericPipe)pipe.tilePart.getOriginal();
        PipeRendererWorld.renderPass = renderPass;
        FacadeRenderHelper.pipeFacadeRenderer((RenderBlocks)renderblocks, (ITextureStates)FakeBlock.INSTANCE, (TileGenericPipe)tile, (PipeRenderState)tile.renderState, (int)x, (int)y, (int)z);
    }
}

