/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILPPipe;
import logisticspipes.interfaces.IClientState;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePart;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.transport.PipeTransportLogistics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class CoreUnroutedPipe
implements IClientState,
ILPPipe,
ILPCCTypeHolder {
    private Object ccType;
    public LogisticsTileGenericPipe container;
    public final PipeTransportLogistics transport;
    public final Item item;
    public IBCPipePart bcPipePart;
    private boolean initialized = false;

    public CoreUnroutedPipe(PipeTransportLogistics transport, Item item) {
        this.transport = transport;
        this.item = item;
    }

    public void setTile(TileEntity tile) {
        this.container = (LogisticsTileGenericPipe)tile;
        this.transport.setTile((LogisticsTileGenericPipe)tile);
        this.bcPipePart = ((LogisticsTileGenericPipe)tile).tilePart.getBCPipePart();
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        return false;
    }

    public void onBlockPlaced() {
        this.transport.onBlockPlaced();
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
    }

    public void onNeighborBlockChange(int blockId) {
        this.transport.onNeighborBlockChange(blockId);
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        CoreUnroutedPipe otherPipe;
        if (tile instanceof LogisticsTileGenericPipe && !LogisticsBlockGenericPipe.isFullyDefined(otherPipe = ((LogisticsTileGenericPipe)tile).pipe)) {
            return false;
        }
        return this.transport.canPipeConnect(tile, side);
    }

    public int getIconIndexForItem() {
        return this.getIconIndex(ForgeDirection.UNKNOWN);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();

    public abstract int getIconIndex(ForgeDirection var1);

    public void updateEntity() {
        this.transport.updateEntity();
    }

    public void writeToNBT(NBTTagCompound data) {
        this.transport.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.transport.readFromNBT(data);
    }

    public boolean needsInit() {
        return !this.initialized;
    }

    public void initialize() {
        this.transport.initialize();
        this.initialized = true;
    }

    protected void notifyBlockOfNeighborChange(ForgeDirection side) {
        this.container.func_145831_w().func_147460_e(this.container.field_145851_c + side.offsetX, this.container.field_145848_d + side.offsetY, this.container.field_145849_e + side.offsetZ, LogisticsPipes.LogisticsPipeBlock);
    }

    public void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.container.func_145831_w().func_147460_e(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, LogisticsPipes.LogisticsPipeBlock);
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.notifyBlockOfNeighborChange(side);
        }
    }

    public void dropItem(ItemStack stack) {
        MainProxy.dropItems(this.container.func_145831_w(), stack, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }

    public void onBlockRemoval() {
        if (this.getWorld().func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
            for (ItemStack stack : this.computeItemDrop()) {
                this.dropItem(stack);
            }
        }
    }

    public ArrayList<ItemStack> computeItemDrop() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        this.bcPipePart.addItemDrops(result);
        return result;
    }

    public LogisticsTileGenericPipe getContainer() {
        return this.container;
    }

    public List<ItemStack> dropContents() {
        return this.transport.dropContents();
    }

    public ForgeDirection getOpenOrientation() {
        int connectionsNum = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(o) || ++connectionsNum != 1) continue;
            targetOrientation = o;
        }
        if (connectionsNum > 1 || connectionsNum == 0) {
            return ForgeDirection.UNKNOWN;
        }
        return targetOrientation.getOpposite();
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void onChunkUnload() {
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection direction, boolean flag) {
        return this.canPipeConnect(tile, direction);
    }

    public final int getX() {
        return this.container.field_145851_c;
    }

    public final int getY() {
        return this.container.field_145848_d;
    }

    public final int getZ() {
        return this.container.field_145849_e;
    }

    public boolean canBeDestroyed() {
        return false;
    }

    public boolean destroyByPlayer() {
        return false;
    }

    public void setPreventRemove(boolean flag) {
    }

    public boolean preventRemove() {
        return false;
    }

    @Override
    public boolean isRoutedPipe() {
        return false;
    }

    @Override
    public void setCCType(Object type) {
        this.ccType = type;
    }

    @Override
    public Object getCCType() {
        return this.ccType;
    }
}

