/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeItemsFluidSupplier
extends CoreRoutedPipe
implements IRequestItems,
IRequireReliableTransport {
    private boolean _lastRequestFailed = false;
    private ItemIdentifierInventory dummyInventory = new ItemIdentifierInventory(9, "Fluids to keep stocked", 127);
    private final HashMap<ItemIdentifier, Integer> _requestedItems = new HashMap();
    private boolean _requestPartials = false;

    public PipeItemsFluidSupplier(Item item) {
        super(new PipeTransportLogistics(){

            @Override
            public boolean canPipeConnect(TileEntity tile, ForgeDirection dir) {
                IFluidHandler liq;
                if (super.canPipeConnect(tile, dir)) {
                    return true;
                }
                if (SimpleServiceLocator.pipeInformaitonManager.isPipe(tile)) {
                    return false;
                }
                return tile instanceof IFluidHandler && (liq = (IFluidHandler)tile).getTankInfo(dir.getOpposite()) != null && liq.getTankInfo(dir.getOpposite()).length > 0;
            }
        }, item);
        this.throttleTime = 100;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_TEXTURE;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    public void endReached(LPTravelingItem.LPTravelingItemServer data, TileEntity tile) {
        this.transport.markChunkModified(tile);
        this.notifyOfItemArival(data.getInfo());
        if (!(tile instanceof IFluidHandler)) {
            return;
        }
        if (SimpleServiceLocator.pipeInformaitonManager.isPipe(tile)) {
            return;
        }
        IFluidHandler container = (IFluidHandler)tile;
        if (data.getItemIdentifierStack() == null) {
            return;
        }
        FluidStack liquidId = FluidContainerRegistry.getFluidForFilledItem((ItemStack)data.getItemIdentifierStack().makeNormalStack());
        if (liquidId == null) {
            return;
        }
        ForgeDirection orientation = data.output.getOpposite();
        if (this.getUpgradeManager().hasSneakyUpgrade()) {
            orientation = this.getUpgradeManager().getSneakyOrientation();
        }
        while (data.getItemIdentifierStack().getStackSize() > 0 && container.fill(orientation, liquidId, false) == liquidId.amount && this.useEnergy(5)) {
            container.fill(orientation, liquidId.copy(), true);
            data.getItemIdentifierStack().lowerStackSize(1);
            Item item = data.getItemIdentifierStack().getItem().item;
            if (!item.hasContainerItem(data.getItemIdentifierStack().makeNormalStack())) continue;
            Item containerItem = item.func_77668_q();
            this.transport.sendItem(new ItemStack(containerItem, 1));
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public void throttledUpdateEntity() {
        if (!this.isEnabled()) {
            return;
        }
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        super.throttledUpdateEntity();
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            FluidTankInfo[] result;
            IFluidHandler container;
            if (!(tile.tile instanceof IFluidHandler) || SimpleServiceLocator.pipeInformaitonManager.isPipe(tile.tile) || (container = (IFluidHandler)tile.tile).getTankInfo(ForgeDirection.UNKNOWN) == null || container.getTankInfo(ForgeDirection.UNKNOWN).length == 0) continue;
            Map<ItemIdentifier, Integer> wantContainers = this.dummyInventory.getItemsAndCount();
            HashMap<FluidIdentifier, Integer> wantFluids = new HashMap<FluidIdentifier, Integer>();
            for (Map.Entry<ItemIdentifier, Integer> item : wantContainers.entrySet()) {
                ItemStack wantItem = item.getKey().unsafeMakeNormalStack(1);
                FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)wantItem);
                if (fluidStack == null) continue;
                wantFluids.put(FluidIdentifier.get(fluidStack), item.getValue() * fluidStack.amount);
            }
            HashMap<FluidIdentifier, Integer> haveFluids = new HashMap<FluidIdentifier, Integer>();
            for (FluidTankInfo slot : result = container.getTankInfo(ForgeDirection.UNKNOWN)) {
                if (slot == null || slot.fluid == null || slot.fluid.fluidID == 0 || !wantFluids.containsKey(FluidIdentifier.get(slot.fluid))) continue;
                Integer liquidWant = (Integer)haveFluids.get(FluidIdentifier.get(slot.fluid));
                if (liquidWant == null) {
                    haveFluids.put(FluidIdentifier.get(slot.fluid), slot.fluid.amount);
                    continue;
                }
                haveFluids.put(FluidIdentifier.get(slot.fluid), liquidWant + slot.fluid.amount);
            }
            for (Map.Entry entry : wantFluids.entrySet()) {
                Integer haveCount = (Integer)haveFluids.get(entry.getKey());
                if (haveCount == null) continue;
                entry.setValue((Integer)entry.getValue() - haveCount);
            }
            for (Map.Entry<Object, Object> entry : this._requestedItems.entrySet()) {
                FluidIdentifier requestedFluid;
                Integer want;
                ItemStack wantItem = ((ItemIdentifier)entry.getKey()).unsafeMakeNormalStack(1);
                FluidStack requestedFluidId = FluidContainerRegistry.getFluidForFilledItem((ItemStack)wantItem);
                if (requestedFluidId == null || (want = (Integer)wantFluids.get(requestedFluid = FluidIdentifier.get(requestedFluidId))) == null) continue;
                wantFluids.put(requestedFluid, want - (Integer)entry.getValue() * requestedFluidId.amount);
            }
            ((PipeItemsFluidSupplier)this.container.pipe).setRequestFailed(false);
            for (ItemIdentifier itemIdentifier : wantContainers.keySet()) {
                int countToRequest;
                FluidStack requestedFluidId = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemIdentifier.unsafeMakeNormalStack(1));
                if (requestedFluidId == null || !wantFluids.containsKey(FluidIdentifier.get(requestedFluidId)) || (countToRequest = (Integer)wantFluids.get(FluidIdentifier.get(requestedFluidId)) / requestedFluidId.amount) < 1) continue;
                if (!this.useEnergy(11)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    if ((countToRequest = RequestTree.requestPartial(itemIdentifier.makeStack(countToRequest), (IRequestItems)((Object)this.container.pipe), null)) > 0) {
                        success = true;
                    }
                } else {
                    success = RequestTree.request(itemIdentifier.makeStack(countToRequest), (IRequestItems)((Object)this.container.pipe), null, null);
                }
                if (success) {
                    Integer currentRequest = this._requestedItems.get(itemIdentifier);
                    if (currentRequest == null) {
                        this._requestedItems.put(itemIdentifier, countToRequest);
                        continue;
                    }
                    this._requestedItems.put(itemIdentifier, currentRequest + countToRequest);
                    continue;
                }
                ((PipeItemsFluidSupplier)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        int remaining = item.getStackSize();
        Integer count = this._requestedItems.get(item.getItem());
        if (count != null) {
            this._requestedItems.put(item.getItem(), Math.max(0, count - remaining));
            remaining -= count.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry<ItemIdentifier, Integer> e : this._requestedItems.entrySet()) {
            if (e.getKey().item == item.getItem().item && e.getKey().itemDamage == item.getItem().itemDamage) {
                int expected = e.getValue();
                e.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        this.debug.log("liquid supplier got unexpected item " + item.toString());
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.decreaseRequested(item);
        this.delayThrottle();
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 11, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public ItemIdentifierInventory getDummyInventory() {
        return this.dummyInventory;
    }
}

