/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Set;
import java.util.TreeSet;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsBasicLogistics
extends CoreRoutedPipe {
    private ModuleItemSink itemSinkModule = new ModuleItemSink();

    public PipeItemsBasicLogistics(Item item) {
        super(new PipeTransportLogistics(){

            @Override
            public boolean canPipeConnect(TileEntity tile, ForgeDirection dir) {
                if (super.canPipeConnect(tile, dir)) {
                    return true;
                }
                if (tile instanceof LogisticsSecurityTileEntity) {
                    ForgeDirection ori = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile);
                    return ori != null && ori != ForgeDirection.UNKNOWN && ori != ForgeDirection.DOWN && ori != ForgeDirection.UP;
                }
                return false;
            }
        }, item);
        this.itemSinkModule.registerHandler(this, this);
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (this.isSecurityProvider(connection)) {
            return Textures.LOGISTICSPIPE_SECURITY_TEXTURE;
        }
        return super.getNonRoutedTexture(connection);
    }

    @Override
    public boolean isLockedExit(ForgeDirection orientation) {
        if (this.isPowerJunction(orientation) || this.isSecurityProvider(orientation)) {
            return true;
        }
        return super.isLockedExit(orientation);
    }

    private boolean isPowerJunction(ForgeDirection ori) {
        TileEntity tilePipe = this.container.getTile(ori);
        if (tilePipe == null || !this.container.canPipeConnect(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof LogisticsPowerJunctionTileEntity;
    }

    private boolean isSecurityProvider(ForgeDirection ori) {
        TileEntity tilePipe = this.container.getTile(ori);
        if (tilePipe == null || !this.container.canPipeConnect(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof LogisticsSecurityTileEntity;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return this.itemSinkModule;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void setTile(TileEntity tile) {
        super.setTile(tile);
        this.itemSinkModule.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    public Set<ItemIdentifier> getSpecificInterests() {
        if (this.itemSinkModule.isDefaultRoute()) {
            return null;
        }
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (int i = 0; i < 9; ++i) {
            ItemIdentifierStack item = this.itemSinkModule.getFilterInventory().getIDStackInSlot(i);
            if (item == null) continue;
            l1.add(item.getItem());
        }
        return l1;
    }

    @Override
    public boolean hasGenericInterests() {
        return this.itemSinkModule.isDefaultRoute();
    }
}

