/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.modules.ModuleSatelite;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.satpipe.SatPipeNext;
import logisticspipes.network.packets.satpipe.SatPipePrev;
import logisticspipes.network.packets.satpipe.SatPipeSetID;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidSatellite
extends FluidRoutedPipe
implements IRequestFluid,
IRequireReliableFluidTransport,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    public final LinkedList<ItemIdentifierStack> itemList = new LinkedList();
    public final LinkedList<ItemIdentifierStack> oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);
    public static HashSet<PipeFluidSatellite> AllSatellites = new HashSet();
    protected final Map<FluidIdentifier, Integer> _lostItems = new HashMap<FluidIdentifier, Integer>();
    public int satelliteId;

    public PipeFluidSatellite(Item item) {
        super(item);
        this.throttleTime = 40;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_SATELLITE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return new ModuleSatelite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.isNthTick(20) && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public void sendFailed(FluidIdentifier liquid, Integer amount) {
        this.liquidLost(liquid, amount);
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(false)) {
            IFluidHandler tankContainer;
            FluidTankInfo[] tanks;
            if (!(pair.getValue1() instanceof IFluidHandler) || (tanks = (tankContainer = (IFluidHandler)pair.getValue1()).getTankInfo(pair.getValue2().getOpposite())) == null) continue;
            for (FluidTankInfo tank : tanks) {
                FluidStack liquid;
                if (tank == null || (liquid = tank.fluid) == null || liquid.fluidID == 0) continue;
                this.addToList(FluidIdentifier.get(liquid).getItemIdentifier().makeStack(liquid.amount));
            }
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ChestContent.class).setIdentList(this.itemList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    public static void cleanup() {
        AllSatellites.clear();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.satelliteId = nbttagcompound.func_74762_e("satelliteid");
        this.ensureAllSatelliteStatus();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("satelliteid", this.satelliteId);
        super.writeToNBT(nbttagcompound);
    }

    protected int findId(int increment) {
        if (MainProxy.isClient(this.getWorld())) {
            return this.satelliteId;
        }
        int potentialId = this.satelliteId;
        boolean conflict = true;
        block0: while (conflict) {
            if ((potentialId += increment) < 0) {
                return 0;
            }
            conflict = false;
            for (PipeFluidSatellite sat : AllSatellites) {
                if (sat.satelliteId != potentialId) continue;
                conflict = true;
                continue block0;
            }
        }
        return potentialId;
    }

    protected void ensureAllSatelliteStatus() {
        if (MainProxy.isClient()) {
            return;
        }
        if (this.satelliteId == 0 && AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
        if (this.satelliteId != 0 && !AllSatellites.contains(this)) {
            AllSatellites.add(this);
        }
    }

    public void setNextId(EntityPlayer player) {
        this.satelliteId = this.findId(1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeNext.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer(packet);
        } else {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
        }
        this.updateWatchers();
    }

    public void setPrevId(EntityPlayer player) {
        this.satelliteId = this.findId(-1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipePrev.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToServer(packet);
        } else {
            CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
        }
        this.updateWatchers();
    }

    private void updateWatchers() {
        MainProxy.sendToPlayerList(PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), ((PipeFluidSatellite)this.container.pipe).localModeWatchers);
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        if (AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = PacketHandler.getPacket(SatPipeSetID.class).setSatID(this.satelliteId).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer(packet, entityplayer);
        entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<FluidIdentifier, Integer>> iterator = this._lostItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FluidIdentifier, Integer> stack = iterator.next();
            int received = RequestTree.requestFluidPartial(stack.getKey(), stack.getValue(), this, null);
            if (received <= 0) continue;
            if (received == stack.getValue()) {
                iterator.remove();
                continue;
            }
            stack.setValue(stack.getValue() - received);
        }
    }

    public void setSatelliteId(int integer) {
        this.satelliteId = integer;
    }

    @Override
    public void liquidLost(FluidIdentifier item, int amount) {
        if (this._lostItems.containsKey(item)) {
            this._lostItems.put(item, this._lostItems.get(item) + amount);
        } else {
            this._lostItems.put(item, amount);
        }
    }

    @Override
    public void liquidArrived(FluidIdentifier item, int amount) {
    }

    @Override
    public void liquidNotInserted(FluidIdentifier item, int amount) {
        this.liquidLost(item, amount);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

